/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.examples;

import io.fabric8.kubernetes.api.model.EditableNamespace;
import io.fabric8.kubernetes.api.model.Namespace;
import io.fabric8.kubernetes.api.model.NamespaceBuilder;
import io.fabric8.kubernetes.api.model.NamespaceFluent;
import io.fabric8.kubernetes.api.model.Quantity;
import io.fabric8.kubernetes.api.model.ServiceAccount;
import io.fabric8.kubernetes.api.model.ServiceAccountBuilder;
import io.fabric8.kubernetes.api.model.ServiceAccountFluent;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.EditableConfig;
import io.fabric8.kubernetes.client.dsl.ClientNonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.ClientResource;
import io.fabric8.kubernetes.client.dsl.Triggerable;
import io.fabric8.kubernetes.client.dsl.Typeable;
import io.fabric8.openshift.api.model.Build;
import io.fabric8.openshift.api.model.BuildConfigFluent;
import io.fabric8.openshift.api.model.BuildConfigSpecFluent;
import io.fabric8.openshift.api.model.BuildList;
import io.fabric8.openshift.api.model.BuildOutputFluent;
import io.fabric8.openshift.api.model.BuildRequestBuilder;
import io.fabric8.openshift.api.model.BuildRequestFluent;
import io.fabric8.openshift.api.model.BuildSourceFluent;
import io.fabric8.openshift.api.model.BuildStrategyFluent;
import io.fabric8.openshift.api.model.BuildTriggerPolicyFluent;
import io.fabric8.openshift.api.model.DoneableBuildConfig;
import io.fabric8.openshift.api.model.DoneableImageStream;
import io.fabric8.openshift.api.model.ImageStreamFluent;
import io.fabric8.openshift.api.model.ImageStreamSpecFluent;
import io.fabric8.openshift.api.model.SourceBuildStrategyFluent;
import io.fabric8.openshift.api.model.WebHookTriggerBuilder;
import io.fabric8.openshift.client.OpenShiftClient;
import io.fabric8.openshift.client.dsl.BuildConfigClientResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BuildConfigExamples {
    private static final Logger logger = LoggerFactory.getLogger(BuildConfigExamples.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws InterruptedException {
        String master = "https://localhost:8443/";
        if (args.length == 1) {
            master = args[0];
        }
        EditableConfig config = new ConfigBuilder().build();
        DefaultKubernetesClient kubernetesClient = new DefaultKubernetesClient((Config)config);
        OpenShiftClient client = (OpenShiftClient)kubernetesClient.adapt(OpenShiftClient.class);
        try {
            EditableNamespace ns = ((NamespaceBuilder)((NamespaceFluent.MetadataNested)((NamespaceFluent.MetadataNested)new NamespaceBuilder().withNewMetadata().withName("thisisatest")).addToLabels("this", "rocks")).endMetadata()).build();
            ServiceAccount fabric8 = (ServiceAccount)((ClientResource)((ClientNonNamespaceOperation)client.serviceAccounts().inNamespace("default")).withName("fabric8")).get();
            fabric8 = ((ServiceAccountBuilder)((ServiceAccountFluent.MetadataNested)((ServiceAccountFluent.MetadataNested)new ServiceAccountBuilder(fabric8).editMetadata().withNamespace("thisisatest")).withResourceVersion(null)).endMetadata()).build();
            BuildConfigExamples.log("Created namespace", client.namespaces().create((Object[])new Namespace[]{ns}));
            ((ClientNonNamespaceOperation)client.serviceAccounts().inNamespace("thisisatest")).create((Object[])new ServiceAccount[]{fabric8});
            BuildConfigExamples.log("Created image stream", ((DoneableImageStream)((ImageStreamFluent.StatusNested)((DoneableImageStream)((ImageStreamFluent.SpecNested)((ImageStreamFluent.SpecNested)((ImageStreamSpecFluent.TagsNested)((DoneableImageStream)((ImageStreamFluent.MetadataNested)((DoneableImageStream)((ClientNonNamespaceOperation)client.imageStreams().inNamespace("thisisatest")).createNew()).withNewMetadata().withName("example-camel-cdi")).endMetadata()).withNewSpec().addNewTag().withName("latest")).endTag()).withDockerImageRepository("fabric8/example-camel-cdi:latest")).endSpec()).withNewStatus().withDockerImageRepository("")).endStatus()).done());
            BuildConfigExamples.log("Created image stream", ((DoneableImageStream)((ImageStreamFluent.StatusNested)((DoneableImageStream)((ImageStreamFluent.SpecNested)((ImageStreamFluent.SpecNested)((ImageStreamSpecFluent.TagsNested)((DoneableImageStream)((ImageStreamFluent.MetadataNested)((DoneableImageStream)((ClientNonNamespaceOperation)client.imageStreams().inNamespace("thisisatest")).createNew()).withNewMetadata().withName("java-sti")).endMetadata()).withNewSpec().addNewTag().withName("latest")).endTag()).withDockerImageRepository("fabric8/java-sti")).endSpec()).withNewStatus().withDockerImageRepository("")).endStatus()).done());
            BuildConfigExamples.log("Created build config", ((DoneableBuildConfig)((BuildConfigFluent.SpecNested)((BuildConfigSpecFluent.TriggersNested)((BuildTriggerPolicyFluent.GithubNested)((BuildConfigSpecFluent.TriggersNested)((BuildConfigFluent.SpecNested)((BuildConfigSpecFluent.OutputNested)((BuildOutputFluent.ToNested)((BuildOutputFluent.ToNested)((BuildConfigFluent.SpecNested)((BuildConfigSpecFluent.StrategyNested)((BuildStrategyFluent.SourceStrategyNested)((SourceBuildStrategyFluent.FromNested)((SourceBuildStrategyFluent.FromNested)((BuildConfigSpecFluent.StrategyNested)((BuildConfigFluent.SpecNested)((BuildConfigSpecFluent.ResourcesNested)((BuildConfigSpecFluent.ResourcesNested)((BuildConfigFluent.SpecNested)((BuildConfigSpecFluent.SourceNested)((BuildSourceFluent.GitNested)((BuildConfigSpecFluent.SourceNested)((BuildConfigFluent.SpecNested)((DoneableBuildConfig)((BuildConfigFluent.MetadataNested)((DoneableBuildConfig)((ClientNonNamespaceOperation)client.buildConfigs().inNamespace("thisisatest")).createNew()).withNewMetadata().withName("custom-build-config")).endMetadata()).withNewSpec().withServiceAccount("fabric8")).withNewSource().withType("Git")).withNewGit().withUri("https://github.com/fabric8io/example-camel-cdi.git")).endGit()).endSource()).withNewResources().addToLimits("mykey", new Quantity("10"))).addToRequests("mykey", new Quantity("10"))).endResources()).withNewStrategy().withType("Source")).withNewSourceStrategy().withNewFrom().withName("java-sti:latest")).withKind("DockerImage")).endFrom()).endSourceStrategy()).endStrategy()).withNewOutput().withNewTo().withKind("DockerImage")).withName("example-camel-cdi:latest")).endTo()).endOutput()).addNewTrigger().withType("GitHub")).withNewGithub().withSecret("secret101")).endGithub()).endTrigger()).endSpec()).done());
            ((BuildConfigClientResource)((ClientNonNamespaceOperation)client.buildConfigs().inNamespace("thisisatest")).withName("custom-build-config")).instantiate((Object)((BuildRequestBuilder)((BuildRequestFluent.MetadataNested)new BuildRequestBuilder().withNewMetadata().withName("custom-build-config")).endMetadata()).build());
            ((Triggerable)((Typeable)((BuildConfigClientResource)((ClientNonNamespaceOperation)client.buildConfigs().inNamespace("thisisatest")).withName("custom-build-config")).withSecret("secret101")).withType("github")).trigger((Object)((WebHookTriggerBuilder)new WebHookTriggerBuilder().withSecret("secret101")).build());
            Thread.sleep(6000L);
            BuildConfigExamples.log("Builds:");
            for (Build build : ((BuildList)((ClientNonNamespaceOperation)client.builds().inNamespace("thisisatest")).list()).getItems()) {
                BuildConfigExamples.log("\t\t\t" + build.getMetadata().getName());
            }
            BuildConfigExamples.log("Done.");
        }
        finally {
            ((ClientResource)client.namespaces().withName("thisisatest")).delete();
            client.close();
        }
    }

    private static void log(String action, Object obj) {
        logger.info("{}: {}", (Object)action, obj);
    }

    private static void log(String action) {
        logger.info(action);
    }
}

