/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.dsl.internal;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesResourceList;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.OperationInfo;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.base.PatchContext;
import io.fabric8.kubernetes.client.dsl.base.PatchType;
import io.fabric8.kubernetes.client.dsl.internal.BaseOperation;
import io.fabric8.kubernetes.client.dsl.internal.OperationContext;
import io.fabric8.kubernetes.client.utils.IOHelpers;
import io.fabric8.kubernetes.client.utils.KubernetesResourceUtil;
import io.fabric8.kubernetes.client.utils.Serialization;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;

public class HasMetadataOperation<T extends HasMetadata, L extends KubernetesResourceList<T>, R extends Resource<T>>
extends BaseOperation<T, L, R> {
    public static final DeletionPropagation DEFAULT_PROPAGATION_POLICY = DeletionPropagation.BACKGROUND;
    public static final long DEFAULT_GRACE_PERIOD_IN_SECONDS = -1L;
    private static final String PATCH_OPERATION = "patch";
    private static final String REPLACE_OPERATION = "replace";

    public HasMetadataOperation(OperationContext ctx, Class<T> type, Class<L> listType) {
        super(ctx);
        this.type = type;
        this.listType = listType;
    }

    @Override
    public T edit(UnaryOperator<T> function) {
        Object item = this.getItemOrRequireFromServer();
        Object clone = this.clone(item);
        return (T)this.patch(null, clone, (HasMetadata)function.apply(item), false);
    }

    private T clone(T item) {
        return (T)((HasMetadata)Serialization.clone(item));
    }

    @Override
    public T editStatus(UnaryOperator<T> function) {
        Object item = this.getItemOrRequireFromServer();
        Object clone = this.clone(item);
        return (T)this.patch(null, clone, (HasMetadata)function.apply(item), true);
    }

    @Override
    public T accept(Consumer<T> consumer) {
        Object item = this.getItemOrRequireFromServer();
        Object clone = this.clone(item);
        consumer.accept(item);
        return this.patch(null, clone, item, false);
    }

    @Override
    public T edit(Visitor ... visitors) {
        Object item = this.getItemOrRequireFromServer();
        Object clone = this.clone(item);
        return (T)this.patch(null, clone, (HasMetadata)((VisitableBuilder)this.context.getHandler(item).edit(item).accept(visitors)).build(), false);
    }

    @Override
    public T replace() {
        return this.replace(this.getItem(), false);
    }

    @Override
    public T replaceStatus() {
        return this.replace(this.getItem(), true);
    }

    protected T modifyItemForReplaceOrPatch(Supplier<T> current, T item) {
        return item;
    }

    protected T replace(T item, boolean status) {
        String fixedResourceVersion = this.getResourceVersion();
        Throwable caught = null;
        int maxTries = 10;
        if ((item = this.clone(item)).getMetadata() == null) {
            item.setMetadata(new ObjectMeta());
        }
        if (!status) {
            try {
                item = this.modifyItemForReplaceOrPatch(this::requireFromServer, item);
            }
            catch (Exception e) {
                throw KubernetesClientException.launderThrowable((OperationInfo)this.forOperationType(REPLACE_OPERATION), (Throwable)e);
            }
        }
        String existingResourceVersion = KubernetesResourceUtil.getResourceVersion(item);
        for (int i = 0; i < maxTries; ++i) {
            try {
                String resourceVersion;
                if (fixedResourceVersion != null) {
                    resourceVersion = fixedResourceVersion;
                } else if (i == 0 && existingResourceVersion != null) {
                    resourceVersion = existingResourceVersion;
                } else {
                    Object got = this.requireFromServer();
                    resourceVersion = KubernetesResourceUtil.getResourceVersion(got);
                }
                UnaryOperator visitor = resource -> {
                    try {
                        resource.getMetadata().setResourceVersion(resourceVersion);
                        return this.handleUpdate(resource, status);
                    }
                    catch (Exception e) {
                        throw KubernetesClientException.launderThrowable((OperationInfo)this.forOperationType(REPLACE_OPERATION), (Throwable)e);
                    }
                };
                return (T)((HasMetadata)visitor.apply(item));
            }
            catch (KubernetesClientException e) {
                caught = e;
                if (e.getCode() != 409 || fixedResourceVersion != null) break;
                if (i >= maxTries - 1) continue;
                try {
                    TimeUnit.SECONDS.sleep(1L);
                }
                catch (InterruptedException e1) {
                    Thread.currentThread().interrupt();
                }
                continue;
            }
            catch (Exception e) {
                caught = e;
            }
        }
        throw KubernetesClientException.launderThrowable((OperationInfo)this.forOperationType(REPLACE_OPERATION), (Throwable)caught);
    }

    protected T patch(PatchContext context, T base, T item, boolean status) {
        if (context == null || context.getPatchType() == PatchType.JSON) {
            if (base == null) {
                base = this.requireFromServer();
            }
            if (base.getMetadata() != null) {
                if (item.getMetadata() == null) {
                    item.setMetadata(new ObjectMeta());
                }
                item.getMetadata().setResourceVersion(base.getMetadata().getResourceVersion());
            }
            Object current = base;
            try {
                item = this.modifyItemForReplaceOrPatch(() -> current, item);
            }
            catch (Exception e) {
                throw KubernetesClientException.launderThrowable((OperationInfo)this.forOperationType(PATCH_OPERATION), (Throwable)e);
            }
        }
        Object theBase = base;
        UnaryOperator visitor = resource -> {
            try {
                return this.handlePatch(context, theBase, resource, status);
            }
            catch (Exception e) {
                throw KubernetesClientException.launderThrowable((OperationInfo)this.forOperationType(PATCH_OPERATION), (Throwable)e);
            }
        };
        return (T)((HasMetadata)visitor.apply(item));
    }

    @Override
    public T patchStatus() {
        return this.patch(PatchContext.of((PatchType)PatchType.JSON_MERGE), null, this.getNonNullItem(), true);
    }

    @Override
    public T patch() {
        return this.patch(null, null, this.getNonNullItem(), false);
    }

    @Override
    public T patch(PatchContext patchContext) {
        return this.patch(patchContext, null, this.getNonNullItem(), false);
    }

    @Override
    public T patchStatus(T item) {
        return this.patch(PatchContext.of((PatchType)PatchType.JSON_MERGE), this.getItem(), this.clone(item), true);
    }

    @Override
    public T patch(PatchContext patchContext, T item) {
        return this.patch(patchContext, this.getItem(), this.clone(item), false);
    }

    @Override
    public T patch(PatchContext patchContext, String patch) {
        try {
            Object got = this.getItemOrRequireFromServer();
            return (T)((HasMetadata)this.handlePatch(patchContext, got, IOHelpers.convertToJson((String)patch), this.getType(), false));
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            throw KubernetesClientException.launderThrowable((OperationInfo)this.forOperationType(PATCH_OPERATION), (Throwable)interruptedException);
        }
        catch (IOException e) {
            throw KubernetesClientException.launderThrowable((OperationInfo)this.forOperationType(PATCH_OPERATION), (Throwable)e);
        }
    }

    @Override
    public HasMetadataOperation<T, L, R> newInstance(OperationContext context) {
        return new HasMetadataOperation<T, L, R>(context, this.type, this.listType);
    }
}

