/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.dsl.internal;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.fabric8.kubernetes.api.model.KubernetesResourceList;
import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.kubernetes.api.model.Status;
import io.fabric8.kubernetes.api.model.WatchEvent;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.WatcherException;
import io.fabric8.kubernetes.client.dsl.base.BaseOperation;
import io.fabric8.kubernetes.client.dsl.internal.AbstractWatchManager;
import io.fabric8.kubernetes.client.dsl.internal.BaseOperationRequestBuilder;
import io.fabric8.kubernetes.client.dsl.internal.WatchHTTPManager;
import io.fabric8.kubernetes.client.dsl.internal.WatcherWebSocketListener;
import io.fabric8.kubernetes.client.dsl.internal.WebSocketClientRunner;
import java.net.MalformedURLException;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import okhttp3.OkHttpClient;
import okhttp3.WebSocket;

public class WatchConnectionManager<T extends HasMetadata, L extends KubernetesResourceList<T>>
extends AbstractWatchManager<T> {
    public WatchConnectionManager(OkHttpClient client, BaseOperation<T, L, ?> baseOperation, ListOptions listOptions, Watcher<T> watcher, int reconnectInterval, int reconnectLimit, final long websocketTimeout, int maxIntervalExponent) throws MalformedURLException {
        super(watcher, listOptions, reconnectLimit, reconnectInterval, maxIntervalExponent, new BaseOperationRequestBuilder<T, L>(baseOperation, listOptions));
        this.initRunner(new WebSocketClientRunner<T>(client){

            @Override
            WatcherWebSocketListener<T> newListener(BlockingQueue<Object> queue, AtomicReference<WebSocket> webSocketRef) {
                return new TypedWatcherWebSocketListener(WatchConnectionManager.this, queue, webSocketRef);
            }

            @Override
            OkHttpClient cloneAndCustomize(OkHttpClient client) {
                return client.newBuilder().readTimeout(websocketTimeout, TimeUnit.MILLISECONDS).build();
            }
        });
        this.runWatch();
    }

    public WatchConnectionManager(OkHttpClient client, BaseOperation<T, L, ?> baseOperation, ListOptions listOptions, Watcher<T> watcher, int reconnectInterval, int reconnectLimit, long websocketTimeout) throws MalformedURLException {
        this(client, baseOperation, listOptions, watcher, reconnectInterval, reconnectLimit, websocketTimeout, 5);
    }

    private static class TypedWatcherWebSocketListener<T extends HasMetadata>
    extends WatcherWebSocketListener<T> {
        public TypedWatcherWebSocketListener(AbstractWatchManager<T> manager, BlockingQueue<Object> queue, AtomicReference<WebSocket> webSocketRef) {
            super(manager, queue, webSocketRef);
        }

        public void onMessage(WebSocket webSocket, String message) {
            try {
                WatchEvent event = WatchHTTPManager.readWatchEvent(message);
                KubernetesResource object = event.getObject();
                if (object instanceof HasMetadata) {
                    HasMetadata obj = (HasMetadata)object;
                    this.manager.updateResourceVersion(obj.getMetadata().getResourceVersion());
                    Watcher.Action action = Watcher.Action.valueOf(event.getType());
                    this.manager.eventReceived(action, obj);
                } else if (object instanceof KubernetesResourceList) {
                    KubernetesResourceList list = (KubernetesResourceList)object;
                    this.manager.updateResourceVersion(list.getMetadata().getResourceVersion());
                    Watcher.Action action = Watcher.Action.valueOf(event.getType());
                    List items = list.getItems();
                    if (items != null) {
                        for (HasMetadata item : items) {
                            this.manager.eventReceived(action, item);
                        }
                    }
                } else if (object instanceof Status) {
                    Status status = (Status)object;
                    if (status.getCode() == 410) {
                        this.webSocketRef.set(null);
                        this.manager.closeEvent(new WatcherException(status.getMessage(), new KubernetesClientException(status)));
                        this.manager.close();
                        return;
                    }
                    this.manager.eventReceived(Watcher.Action.ERROR, null);
                    logger.error("Error received: {}", (Object)status);
                } else {
                    logger.error("Unknown message received: {}", (Object)message);
                }
            }
            catch (ClassCastException e) {
                logger.error("Received wrong type of object for watch", (Throwable)e);
            }
            catch (IllegalArgumentException e) {
                logger.error("Invalid event type", (Throwable)e);
            }
            catch (Throwable e) {
                logger.error("Unhandled exception encountered in watcher event handler", e);
            }
        }
    }
}

