/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.dsl.base;

import io.fabric8.kubernetes.api.builder.TypedVisitor;
import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesResourceList;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.model.LabelSelectorRequirement;
import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.kubernetes.api.model.ListOptionsBuilder;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.RootPaths;
import io.fabric8.kubernetes.api.model.Status;
import io.fabric8.kubernetes.api.model.autoscaling.v1.Scale;
import io.fabric8.kubernetes.api.model.extensions.DeploymentRollback;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.OperationInfo;
import io.fabric8.kubernetes.client.ResourceNotFoundException;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.WatcherException;
import io.fabric8.kubernetes.client.dsl.EditReplacePatchDeletable;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.Gettable;
import io.fabric8.kubernetes.client.dsl.MixedOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Replaceable;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.WritableOperation;
import io.fabric8.kubernetes.client.dsl.base.OperationContext;
import io.fabric8.kubernetes.client.dsl.base.OperationSupport;
import io.fabric8.kubernetes.client.dsl.base.WaitForConditionWatcher;
import io.fabric8.kubernetes.client.dsl.internal.DefaultOperationInfo;
import io.fabric8.kubernetes.client.dsl.internal.WatchConnectionManager;
import io.fabric8.kubernetes.client.dsl.internal.WatchHTTPManager;
import io.fabric8.kubernetes.client.internal.readiness.Readiness;
import io.fabric8.kubernetes.client.utils.CreateOrReplaceHelper;
import io.fabric8.kubernetes.client.utils.HttpClientUtils;
import io.fabric8.kubernetes.client.utils.URLUtils;
import io.fabric8.kubernetes.client.utils.Utils;
import io.fabric8.kubernetes.client.utils.WatcherToggle;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import okhttp3.HttpUrl;
import okhttp3.Request;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseOperation<T extends HasMetadata, L extends KubernetesResourceList<T>, R extends Resource<T>>
extends OperationSupport
implements OperationInfo,
MixedOperation<T, L, R>,
Resource<T> {
    private static final Logger LOG = LoggerFactory.getLogger(BaseOperation.class);
    private static final String INVOLVED_OBJECT_NAME = "involvedObject.name";
    private static final String INVOLVED_OBJECT_NAMESPACE = "involvedObject.namespace";
    private static final String INVOLVED_OBJECT_KIND = "involvedObject.kind";
    private static final String INVOLVED_OBJECT_UID = "involvedObject.uid";
    private static final String INVOLVED_OBJECT_RESOURCE_VERSION = "involvedObject.resourceVersion";
    private static final String INVOLVED_OBJECT_API_VERSION = "involvedObject.apiVersion";
    private static final String INVOLVED_OBJECT_FIELD_PATH = "involvedObject.fieldPath";
    private final boolean cascading;
    private final T item;
    private final Map<String, String> labels;
    private final Map<String, String[]> labelsNot;
    private final Map<String, String[]> labelsIn;
    private final Map<String, String[]> labelsNotIn;
    private final Map<String, String> fields;
    private final Map<String, String[]> fieldsNot;
    private final String resourceVersion;
    private final boolean reloadingFromServer;
    private final long gracePeriodSeconds;
    private final DeletionPropagation propagationPolicy;
    private final long watchRetryInitialBackoffMillis;
    private final double watchRetryBackoffMultiplier;
    protected String apiVersion;
    protected Class<T> type;
    protected Class<L> listType;

    protected BaseOperation(OperationContext ctx) {
        super(ctx);
        this.cascading = ctx.getCascading();
        this.item = (HasMetadata)ctx.getItem();
        this.reloadingFromServer = ctx.isReloadingFromServer();
        this.resourceVersion = ctx.getResourceVersion();
        this.gracePeriodSeconds = ctx.getGracePeriodSeconds();
        this.propagationPolicy = ctx.getPropagationPolicy();
        this.labels = ctx.getLabels();
        this.labelsNot = ctx.getLabelsNot();
        this.labelsIn = ctx.getLabelsIn();
        this.labelsNotIn = ctx.getLabelsNotIn();
        this.fields = ctx.getFields();
        this.fieldsNot = ctx.getFieldsNot();
        this.watchRetryInitialBackoffMillis = ctx.getWatchRetryInitialBackoffMillis();
        this.watchRetryBackoffMultiplier = ctx.getWatchRetryBackoffMultiplier();
    }

    public BaseOperation<T, L, R> newInstance(OperationContext context) {
        return new BaseOperation<T, L, R>(context);
    }

    private L listRequestHelper(URL url) {
        try {
            HttpUrl.Builder requestUrlBuilder = HttpUrl.get((URL)url).newBuilder();
            this.addQueryStringParam(requestUrlBuilder, "labelSelector", this.getLabelQueryParam());
            this.addQueryStringParam(requestUrlBuilder, "fieldSelector", this.getFieldQueryParam());
            Request.Builder requestBuilder = new Request.Builder().get().url(requestUrlBuilder.build());
            KubernetesResourceList answer = (KubernetesResourceList)this.handleResponse(requestBuilder, this.listType);
            this.updateApiVersion(answer);
            return (L)answer;
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            throw KubernetesClientException.launderThrowable(this.forOperationType("list"), (Throwable)ie);
        }
        catch (IOException | ExecutionException e) {
            throw KubernetesClientException.launderThrowable(this.forOperationType("list"), (Throwable)e);
        }
    }

    protected URL fetchListUrl(URL url, ListOptions listOptions) throws MalformedURLException {
        return new URL(HttpClientUtils.appendListOptionParams(HttpUrl.get((String)url.toString()).newBuilder(), listOptions).toString());
    }

    private void addQueryStringParam(HttpUrl.Builder requestUrlBuilder, String name, String value) {
        if (Utils.isNotNullOrEmpty(value)) {
            requestUrlBuilder.addQueryParameter(name, value);
        }
    }

    @Override
    public T get() {
        try {
            T answer = this.getMandatory();
            this.updateApiVersion((HasMetadata)answer);
            return answer;
        }
        catch (KubernetesClientException e) {
            if (e.getCode() != 404) {
                throw e;
            }
            return null;
        }
    }

    @Override
    public T require() {
        try {
            T answer = this.getMandatory();
            if (answer == null) {
                throw new ResourceNotFoundException("The resource you request doesn't exist or couldn't be fetched.");
            }
            this.updateApiVersion((HasMetadata)answer);
            return answer;
        }
        catch (KubernetesClientException e) {
            if (e.getCode() != 404) {
                throw e;
            }
            throw new ResourceNotFoundException("Resource not found : " + e.getMessage());
        }
    }

    public T getMandatory() {
        if (this.item != null && !this.reloadingFromServer) {
            return this.item;
        }
        try {
            URL requestUrl = this.getCompleteResourceUrl();
            return this.handleGet(requestUrl);
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            throw KubernetesClientException.launderThrowable(this.forOperationType("get"), (Throwable)ie);
        }
        catch (IOException | ExecutionException e) {
            throw KubernetesClientException.launderThrowable(this.forOperationType("get"), (Throwable)e);
        }
    }

    public RootPaths getRootPaths() {
        try {
            URL requestUrl = new URL(this.config.getMasterUrl());
            Request.Builder req = new Request.Builder().get().url(requestUrl);
            return this.handleResponse(req, RootPaths.class);
        }
        catch (KubernetesClientException e) {
            if (e.getCode() != 404) {
                throw e;
            }
            return null;
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            throw KubernetesClientException.launderThrowable(ie);
        }
        catch (IOException | ExecutionException e) {
            throw KubernetesClientException.launderThrowable(e);
        }
    }

    @Override
    public T edit(UnaryOperator<T> function) {
        throw new KubernetesClientException("Cannot edit read-only resources");
    }

    @Override
    public T edit(Visitor ... visitors) {
        throw new KubernetesClientException("Cannot edit read-only resources");
    }

    @Override
    public <V> T edit(final Class<V> visitorType, final Visitor<V> visitor) {
        return this.edit(new Visitor[]{new TypedVisitor<V>(){

            public Class<V> getType() {
                return visitorType;
            }

            public void visit(V item) {
                visitor.visit(item);
            }
        }});
    }

    @Override
    public T accept(Consumer<T> consumer) {
        throw new KubernetesClientException("Cannot edit read-only resources");
    }

    @Override
    public R withName(String name) {
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("Name must be provided.");
        }
        return (R)this.newInstance(this.context.withName(name));
    }

    @Override
    public Replaceable<T> lockResourceVersion(String resourceVersion) {
        return this.newInstance(this.context.withResourceVersion(resourceVersion));
    }

    @Override
    public NonNamespaceOperation<T, L, R> inNamespace(String namespace) {
        return this.newInstance(this.context.withNamespace(namespace));
    }

    @Override
    public NonNamespaceOperation<T, L, R> inAnyNamespace() {
        Config updated = ((ConfigBuilder)new ConfigBuilder(this.config).withNamespace(null)).build();
        return this.newInstance(this.context.withConfig(updated).withNamespace(null));
    }

    @Override
    public EditReplacePatchDeletable<T> cascading(boolean cascading) {
        return this.newInstance(this.context.withCascading(cascading).withPropagationPolicy(null));
    }

    @Override
    public R load(InputStream is) {
        return (R)this.newInstance(this.context.withItem(BaseOperation.unmarshal(is, this.type)));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public R load(URL url) {
        try (InputStream inputStream = url.openStream();){
            Object object = this.load(inputStream);
            return (R)object;
        }
        catch (IOException e) {
            throw KubernetesClientException.launderThrowable(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public R load(File file) {
        try (FileInputStream fis = new FileInputStream(file);){
            Object object = this.load(fis);
            return (R)object;
        }
        catch (IOException e) {
            throw KubernetesClientException.launderThrowable(e);
        }
    }

    @Override
    public R load(String path) {
        return (R)this.load(new File(path));
    }

    @Override
    public Gettable<T> fromServer() {
        return this.newInstance(this.context.withReloadingFromServer(true));
    }

    @Override
    @SafeVarargs
    public final T create(T ... resources) {
        try {
            if (resources.length > 1) {
                throw new IllegalArgumentException("Too many items to create.");
            }
            if (resources.length == 1) {
                return (T)this.withItem(resources[0]).create(new HasMetadata[0]);
            }
            if (this.getItem() == null) {
                throw new IllegalArgumentException("Nothing to create.");
            }
            return this.handleCreate(this.getItem());
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            throw KubernetesClientException.launderThrowable(this.forOperationType("create"), (Throwable)ie);
        }
        catch (IOException | ExecutionException e) {
            throw KubernetesClientException.launderThrowable(this.forOperationType("create"), (Throwable)e);
        }
    }

    @Override
    public T create(T resource) {
        try {
            if (resource != null) {
                return this.handleCreate(resource);
            }
            throw new IllegalArgumentException("Nothing to create.");
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            throw KubernetesClientException.launderThrowable(this.forOperationType("create"), (Throwable)ie);
        }
        catch (IOException | ExecutionException e) {
            throw KubernetesClientException.launderThrowable(this.forOperationType("create"), (Throwable)e);
        }
    }

    @Override
    @SafeVarargs
    public final T createOrReplace(T ... items) {
        T itemToCreateOrReplace = this.getItem();
        if (items.length > 1) {
            throw new IllegalArgumentException("Too many items to create.");
        }
        if (items.length == 1) {
            itemToCreateOrReplace = items[0];
        }
        if (itemToCreateOrReplace == null) {
            throw new IllegalArgumentException("Nothing to create.");
        }
        if (Utils.isNullOrEmpty(this.name)) {
            return (T)this.withName(itemToCreateOrReplace.getMetadata().getName()).createOrReplace(itemToCreateOrReplace);
        }
        T finalItemToCreateOrReplace = itemToCreateOrReplace;
        CreateOrReplaceHelper<T> createOrReplaceHelper = new CreateOrReplaceHelper<T>(this::create, this::replace, m -> {
            try {
                return this.waitUntilCondition(Objects::nonNull, 1L, TimeUnit.SECONDS);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
                return null;
            }
        }, m -> (HasMetadata)this.fromServer().get());
        return createOrReplaceHelper.createOrReplace(finalItemToCreateOrReplace);
    }

    @Override
    public FilterWatchListDeletable<T, L> withLabels(Map<String, String> labels) {
        this.labels.putAll(labels);
        return this;
    }

    @Override
    public FilterWatchListDeletable<T, L> withLabelSelector(LabelSelector selector) {
        List matchExpressions;
        Map matchLabels = selector.getMatchLabels();
        if (matchLabels != null) {
            this.labels.putAll(matchLabels);
        }
        if ((matchExpressions = selector.getMatchExpressions()) != null) {
            block12: for (LabelSelectorRequirement req : matchExpressions) {
                String operator = req.getOperator();
                String key = req.getKey();
                switch (operator) {
                    case "In": {
                        this.withLabelIn(key, req.getValues().toArray(new String[0]));
                        continue block12;
                    }
                    case "NotIn": {
                        this.withLabelNotIn(key, req.getValues().toArray(new String[0]));
                        continue block12;
                    }
                    case "DoesNotExist": {
                        this.withoutLabel(key);
                        continue block12;
                    }
                    case "Exists": {
                        this.withLabel(key);
                        continue block12;
                    }
                }
                throw new IllegalArgumentException("Unsupported operator: " + operator);
            }
        }
        return this;
    }

    @Override
    @Deprecated
    public FilterWatchListDeletable<T, L> withoutLabels(Map<String, String> labels) {
        labels.forEach((string, string2) -> this.withoutLabel((String)string, (String)string2));
        return this;
    }

    @Override
    public FilterWatchListDeletable<T, L> withLabelIn(String key, String ... values) {
        this.labelsIn.put(key, values);
        return this;
    }

    @Override
    public FilterWatchListDeletable<T, L> withLabelNotIn(String key, String ... values) {
        this.labelsNotIn.put(key, values);
        return this;
    }

    @Override
    public FilterWatchListDeletable<T, L> withLabel(String key, String value) {
        this.labels.put(key, value);
        return this;
    }

    @Override
    public FilterWatchListDeletable<T, L> withLabel(String key) {
        return this.withLabel(key, null);
    }

    @Override
    public FilterWatchListDeletable<T, L> withoutLabel(String key, String value) {
        this.labelsNot.merge(key, new String[]{value}, (oldList, newList) -> {
            String[] concatList = (String[])Array.newInstance(String.class, ((String[])oldList).length + ((String[])newList).length);
            System.arraycopy(oldList, 0, concatList, 0, ((String[])oldList).length);
            System.arraycopy(newList, 0, concatList, ((String[])oldList).length, ((String[])newList).length);
            return concatList;
        });
        return this;
    }

    @Override
    public FilterWatchListDeletable<T, L> withoutLabel(String key) {
        return this.withoutLabel(key, null);
    }

    @Override
    public FilterWatchListDeletable<T, L> withFields(Map<String, String> fields) {
        this.fields.putAll(fields);
        return this;
    }

    @Override
    public FilterWatchListDeletable<T, L> withField(String key, String value) {
        this.fields.put(key, value);
        return this;
    }

    @Override
    public FilterWatchListDeletable<T, L> withInvolvedObject(ObjectReference objectReference) {
        if (objectReference != null) {
            if (objectReference.getName() != null) {
                this.fields.put(INVOLVED_OBJECT_NAME, objectReference.getName());
            }
            if (objectReference.getNamespace() != null) {
                this.fields.put(INVOLVED_OBJECT_NAMESPACE, objectReference.getNamespace());
            }
            if (objectReference.getKind() != null) {
                this.fields.put(INVOLVED_OBJECT_KIND, objectReference.getKind());
            }
            if (objectReference.getUid() != null) {
                this.fields.put(INVOLVED_OBJECT_UID, objectReference.getUid());
            }
            if (objectReference.getResourceVersion() != null) {
                this.fields.put(INVOLVED_OBJECT_RESOURCE_VERSION, objectReference.getResourceVersion());
            }
            if (objectReference.getApiVersion() != null) {
                this.fields.put(INVOLVED_OBJECT_API_VERSION, objectReference.getApiVersion());
            }
            if (objectReference.getFieldPath() != null) {
                this.fields.put(INVOLVED_OBJECT_FIELD_PATH, objectReference.getFieldPath());
            }
        }
        return this;
    }

    @Override
    @Deprecated
    public FilterWatchListDeletable<T, L> withoutFields(Map<String, String> fields) {
        this.labels.forEach((string, string2) -> this.withoutField((String)string, (String)string2));
        return this;
    }

    @Override
    public FilterWatchListDeletable<T, L> withoutField(String key, String value) {
        this.fieldsNot.merge(key, new String[]{value}, (oldList, newList) -> {
            if (Utils.isNotNullOrEmpty(newList[0])) {
                String[] concatList = (String[])Array.newInstance(String.class, ((String[])oldList).length + ((String[])newList).length);
                System.arraycopy(oldList, 0, concatList, 0, ((String[])oldList).length);
                System.arraycopy(newList, 0, concatList, ((String[])oldList).length, ((String[])newList).length);
                return concatList;
            }
            return oldList;
        });
        return this;
    }

    public String getLabelQueryParam() {
        Map.Entry<String, String> entry;
        Iterator<Map.Entry<String, String>> iter;
        StringBuilder sb = new StringBuilder();
        if (this.labels != null && !this.labels.isEmpty()) {
            iter = this.labels.entrySet().iterator();
            while (iter.hasNext()) {
                if (sb.length() > 0) {
                    sb.append(",");
                }
                if ((entry = iter.next()).getValue() != null) {
                    sb.append(entry.getKey()).append("=").append(entry.getValue());
                    continue;
                }
                sb.append(entry.getKey());
            }
        }
        if (this.labelsNot != null && !this.labelsNot.isEmpty()) {
            iter = this.labelsNot.entrySet().iterator();
            while (iter.hasNext()) {
                if (sb.length() > 0) {
                    sb.append(",");
                }
                if (Utils.isNotNull((Object[])(entry = iter.next()).getValue())) {
                    for (int i = 0; i < ((String[])entry.getValue()).length; ++i) {
                        if (i > 0) {
                            sb.append(",");
                        }
                        sb.append(entry.getKey()).append("!=").append(((String[])entry.getValue())[i]);
                    }
                    continue;
                }
                sb.append('!').append(entry.getKey());
            }
        }
        if (this.labelsIn != null && !this.labelsIn.isEmpty()) {
            iter = this.labelsIn.entrySet().iterator();
            while (iter.hasNext()) {
                if (sb.length() > 0) {
                    sb.append(",");
                }
                entry = iter.next();
                sb.append(entry.getKey()).append(" in ").append("(").append(Utils.join((Object[])entry.getValue())).append(")");
            }
        }
        if (this.labelsNotIn != null && !this.labelsNotIn.isEmpty()) {
            iter = this.labelsNotIn.entrySet().iterator();
            while (iter.hasNext()) {
                if (sb.length() > 0) {
                    sb.append(",");
                }
                entry = iter.next();
                sb.append(entry.getKey()).append(" notin ").append("(").append(Utils.join((Object[])entry.getValue())).append(")");
            }
        }
        return sb.toString();
    }

    public String getFieldQueryParam() {
        Map.Entry<String, String> entry;
        Iterator<Map.Entry<String, String>> iter;
        StringBuilder sb = new StringBuilder();
        if (this.fields != null && !this.fields.isEmpty()) {
            iter = this.fields.entrySet().iterator();
            while (iter.hasNext()) {
                if (sb.length() > 0) {
                    sb.append(",");
                }
                entry = iter.next();
                sb.append(entry.getKey()).append("=").append(entry.getValue());
            }
        }
        if (this.fieldsNot != null && !this.fieldsNot.isEmpty()) {
            iter = this.fieldsNot.entrySet().iterator();
            while (iter.hasNext()) {
                if (sb.length() > 0) {
                    sb.append(",");
                }
                entry = iter.next();
                for (int i = 0; i < ((String[])entry.getValue()).length; ++i) {
                    if (i > 0) {
                        sb.append(",");
                    }
                    sb.append(entry.getKey()).append("!=").append(((String[])entry.getValue())[i]);
                }
            }
        }
        return sb.toString();
    }

    @Override
    public L list() {
        try {
            return this.listRequestHelper(this.getResourceUrl(this.namespace, this.name));
        }
        catch (IOException e) {
            throw KubernetesClientException.launderThrowable(this.forOperationType("list"), (Throwable)e);
        }
    }

    @Override
    public L list(Integer limitVal, String continueVal) {
        return this.list(((ListOptionsBuilder)((ListOptionsBuilder)new ListOptionsBuilder().withLimit(Long.valueOf(Long.parseLong(limitVal.toString())))).withContinue(continueVal)).build());
    }

    @Override
    public L list(ListOptions listOptions) {
        try {
            return this.listRequestHelper(this.fetchListUrl(this.getNamespacedUrl(), listOptions));
        }
        catch (MalformedURLException e) {
            throw KubernetesClientException.launderThrowable(this.forOperationType("list"), (Throwable)e);
        }
    }

    @Override
    public Boolean delete() {
        if (this.item != null || this.name != null && !this.name.isEmpty()) {
            try {
                this.deleteThis();
                return true;
            }
            catch (KubernetesClientException e) {
                if (e.getCode() != 404) {
                    throw e;
                }
                return false;
            }
        }
        try {
            this.deleteList();
            return true;
        }
        catch (KubernetesClientException e) {
            if (e.getCode() != 404) {
                throw e;
            }
            return false;
        }
    }

    @Override
    @SafeVarargs
    public final Boolean delete(T ... items) {
        return this.delete(Arrays.asList(items));
    }

    @Override
    public Boolean delete(List<T> items) {
        boolean deleted = true;
        if (items != null) {
            for (HasMetadata toDelete : items) {
                if (toDelete == null) continue;
                this.updateApiVersion(toDelete);
                try {
                    if (toDelete.getMetadata() != null && toDelete.getMetadata().getName() != null && !toDelete.getMetadata().getName().isEmpty()) {
                        deleted &= ((Resource)this.inNamespace(this.checkNamespace(toDelete)).withName(toDelete.getMetadata().getName())).delete().booleanValue();
                        continue;
                    }
                    deleted &= this.withItem(toDelete).delete().booleanValue();
                }
                catch (KubernetesClientException e) {
                    if (e.getCode() != 404) {
                        throw e;
                    }
                    return false;
                }
            }
        }
        return deleted;
    }

    @Override
    public T updateStatus(T item) {
        try {
            return (T)((HasMetadata)this.handleStatusUpdate(item, this.getType()));
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            throw KubernetesClientException.launderThrowable(this.forOperationType("statusUpdate"), (Throwable)ie);
        }
        catch (IOException | ExecutionException e) {
            throw KubernetesClientException.launderThrowable(this.forOperationType("statusUpdate"), (Throwable)e);
        }
    }

    public BaseOperation<T, L, R> withItem(T item) {
        return this.newInstance(this.context.withItem(item));
    }

    void deleteThis() {
        try {
            if (this.item != null) {
                this.updateApiVersion((HasMetadata)this.item);
                this.handleDelete(this.item, this.gracePeriodSeconds, this.propagationPolicy, this.cascading);
            } else {
                this.handleDelete(this.getResourceURLForWriteOperation(this.getResourceUrl()), this.gracePeriodSeconds, this.propagationPolicy, this.cascading);
            }
        }
        catch (Exception e) {
            throw KubernetesClientException.launderThrowable(this.forOperationType("delete"), (Throwable)e);
        }
    }

    void deleteList() {
        this.delete(this.list().getItems());
    }

    @Override
    public R withResourceVersion(String resourceVersion) {
        return (R)this.newInstance(this.context.withResourceVersion(resourceVersion));
    }

    @Override
    public Watch watch(Watcher<T> watcher) {
        return this.watch(((ListOptionsBuilder)new ListOptionsBuilder().withResourceVersion(this.resourceVersion)).build(), watcher);
    }

    @Override
    public Watch watch(String resourceVersion, Watcher<T> watcher) {
        return this.watch(((ListOptionsBuilder)new ListOptionsBuilder().withResourceVersion(resourceVersion)).build(), watcher);
    }

    @Override
    public Watch watch(ListOptions options, Watcher<T> watcher) {
        WatcherToggle<T> watcherToggle = new WatcherToggle<T>(watcher, true);
        options.setWatch(Boolean.TRUE);
        WatchConnectionManager watch = null;
        try {
            watch = new WatchConnectionManager(this.client, this, options, watcherToggle, this.config.getWatchReconnectInterval(), this.config.getWatchReconnectLimit(), this.config.getWebsocketTimeout());
            watch.waitUntilReady();
            return watch;
        }
        catch (MalformedURLException e) {
            throw KubernetesClientException.launderThrowable(this.forOperationType("watch"), (Throwable)e);
        }
        catch (KubernetesClientException ke) {
            List<Integer> furtherProcessedCodes = Arrays.asList(200, 503);
            if (!furtherProcessedCodes.contains(ke.getCode())) {
                if (watch != null) {
                    watch.close();
                }
                throw ke;
            }
            if (watch != null) {
                watcherToggle.disable();
                watch.close();
            }
            try {
                return new WatchHTTPManager(this.client, this, options, watcher, this.config.getWatchReconnectInterval(), this.config.getWatchReconnectLimit(), this.config.getConnectionTimeout());
            }
            catch (MalformedURLException e) {
                throw KubernetesClientException.launderThrowable(this.forOperationType("watch"), (Throwable)e);
            }
        }
    }

    @Override
    public T replace(T item) {
        throw new KubernetesClientException("Cannot update read-only resources");
    }

    @Override
    public T patch(T item) {
        throw new KubernetesClientException("Cannot update read-only resources");
    }

    @Override
    public boolean isResourceNamespaced() {
        return Utils.isResourceNamespaced(this.getType());
    }

    protected T handleResponse(Request.Builder requestBuilder) throws ExecutionException, InterruptedException, IOException {
        return (T)((HasMetadata)this.handleResponse(requestBuilder, this.getType()));
    }

    protected T handleCreate(T resource) throws ExecutionException, InterruptedException, IOException {
        this.updateApiVersion((HasMetadata)resource);
        return (T)((HasMetadata)this.handleCreate(resource, this.getType()));
    }

    protected T handleReplace(T updated) throws ExecutionException, InterruptedException, IOException {
        this.updateApiVersion((HasMetadata)updated);
        return (T)((HasMetadata)this.handleReplace(updated, this.getType()));
    }

    protected T handlePatch(T current, T updated) throws ExecutionException, InterruptedException, IOException {
        this.updateApiVersion((HasMetadata)updated);
        return (T)((HasMetadata)this.handlePatch(current, updated, this.getType()));
    }

    protected T handlePatch(T current, Map<String, Object> patchedUpdate) throws ExecutionException, InterruptedException, IOException {
        this.updateApiVersion((HasMetadata)current);
        return (T)((HasMetadata)this.handlePatch(current, patchedUpdate, this.getType()));
    }

    protected T sendPatchedObject(T oldObject, T updatedObject) {
        try {
            return this.handlePatch(oldObject, updatedObject);
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            throw KubernetesClientException.launderThrowable(interruptedException);
        }
        catch (IOException | ExecutionException e) {
            throw KubernetesClientException.launderThrowable(e);
        }
    }

    protected Scale handleScale(Scale scaleParam) {
        try {
            return this.handleScale(this.getCompleteResourceUrl().toString(), scaleParam);
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            throw KubernetesClientException.launderThrowable(this.forOperationType("scale"), (Throwable)ie);
        }
        catch (IOException | ExecutionException e) {
            throw KubernetesClientException.launderThrowable(this.forOperationType("scale"), (Throwable)e);
        }
    }

    protected Status handleDeploymentRollback(DeploymentRollback deploymentRollback) {
        try {
            return this.handleDeploymentRollback(this.getCompleteResourceUrl().toString(), deploymentRollback);
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            throw KubernetesClientException.launderThrowable(this.forOperationType("rollback"), (Throwable)ie);
        }
        catch (IOException | ExecutionException e) {
            throw KubernetesClientException.launderThrowable(this.forOperationType("rollback"), (Throwable)e);
        }
    }

    protected T handleGet(URL resourceUrl) throws InterruptedException, ExecutionException, IOException {
        HasMetadata answer = (HasMetadata)this.handleGet(resourceUrl, this.getType());
        this.updateApiVersion(answer);
        return (T)answer;
    }

    private URL getCompleteResourceUrl() throws MalformedURLException {
        URL requestUrl = null;
        requestUrl = this.item != null ? this.getNamespacedUrl(this.item) : this.getNamespacedUrl();
        if (this.name != null) {
            requestUrl = new URL(URLUtils.join(requestUrl.toString(), this.name));
        } else if (this.item != null && this.reloadingFromServer) {
            requestUrl = new URL(URLUtils.join(requestUrl.toString(), this.checkName(this.item)));
        }
        return requestUrl;
    }

    public Boolean isCascading() {
        return this.cascading;
    }

    public T getItem() {
        return this.item;
    }

    public String getResourceVersion() {
        return this.resourceVersion;
    }

    public Boolean isReloadingFromServer() {
        return this.reloadingFromServer;
    }

    public Long getGracePeriodSeconds() {
        return this.gracePeriodSeconds;
    }

    public DeletionPropagation getPropagationPolicy() {
        return this.propagationPolicy;
    }

    @Override
    public String getResourceT() {
        return this.resourceT;
    }

    public Class<T> getType() {
        return this.type;
    }

    public Class<L> getListType() {
        return this.listType;
    }

    protected Map<String, String> getLabels() {
        return this.labels;
    }

    protected Map<String, String[]> getLabelsNot() {
        return this.labelsNot;
    }

    protected Map<String, String[]> getLabelsIn() {
        return this.labelsIn;
    }

    protected Map<String, String[]> getLabelsNotIn() {
        return this.labelsNotIn;
    }

    protected Map<String, String> getFields() {
        return this.fields;
    }

    protected Map<String, String[]> getFieldsNot() {
        return this.fieldsNot;
    }

    @Override
    public String getKind() {
        return this.type != null ? this.type.getSimpleName() : "Resource";
    }

    @Override
    public String getOperationType() {
        return null;
    }

    @Override
    public OperationInfo forOperationType(String type) {
        return new DefaultOperationInfo(this.getKind(), type, this.name, this.namespace);
    }

    @Override
    public FilterWatchListDeletable<T, L> withGracePeriod(long gracePeriodSeconds) {
        return this.newInstance(this.context.withGracePeriodSeconds(gracePeriodSeconds));
    }

    @Override
    public EditReplacePatchDeletable<T> withPropagationPolicy(DeletionPropagation propagationPolicy) {
        return this.newInstance(this.context.withPropagationPolicy(propagationPolicy));
    }

    public BaseOperation<T, L, R> withWaitRetryBackoff(long initialBackoff, TimeUnit backoffUnit, double backoffMultiplier) {
        return this.newInstance(this.context.withWatchRetryInitialBackoffMillis(backoffUnit.toMillis(initialBackoff)).withWatchRetryBackoffMultiplier(backoffMultiplier));
    }

    protected Class<? extends Config> getConfigType() {
        return Config.class;
    }

    protected void updateApiVersion(KubernetesResourceList<T> list) {
        String version = this.getApiVersion();
        if (list != null && version != null && version.length() > 0 && list.getItems() != null) {
            list.getItems().forEach(this::updateApiVersion);
        }
    }

    protected void updateApiVersion(HasMetadata hasMetadata) {
        String current;
        String version = this.getApiVersion();
        if (hasMetadata != null && version != null && version.length() > 0 && ((current = hasMetadata.getApiVersion()) == null || "v1".equals(current) || current.indexOf(47) < 0 && version.indexOf(47) > 0)) {
            hasMetadata.setApiVersion(version);
        }
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public boolean isApiGroup() {
        return this.apiVersion != null && this.apiVersion.indexOf(47) > 0;
    }

    public Readiness getReadiness() {
        return Readiness.getInstance();
    }

    @Override
    public final Boolean isReady() {
        return this.getReadiness().isReady((HasMetadata)this.get());
    }

    @Override
    public T waitUntilReady(long amount, TimeUnit timeUnit) throws InterruptedException {
        return (T)this.waitUntilCondition(resource -> Objects.nonNull(resource) && this.getReadiness().isReady((HasMetadata)resource), amount, timeUnit);
    }

    @Override
    public T waitUntilCondition(Predicate<T> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
        return this.waitUntilConditionWithRetries(condition, timeUnit.toNanos(amount), this.watchRetryInitialBackoffMillis);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private T waitUntilConditionWithRetries(Predicate<T> condition, long timeoutNanos, long backoffMillis) throws InterruptedException {
        long startTime;
        ListOptions options = null;
        if (this.resourceVersion != null) {
            options = BaseOperation.createListOptions(this.resourceVersion);
        }
        long currentBackOff = backoffMillis;
        for (long remainingNanosToWait = timeoutNanos; remainingNanosToWait > 0L; remainingNanosToWait -= System.nanoTime() - startTime) {
            HasMetadata item = (HasMetadata)this.fromServer().get();
            if (condition.test(item)) {
                return (T)item;
            }
            if (options == null) {
                options = BaseOperation.createListOptions(BaseOperation.getResourceVersion(item));
            }
            WaitForConditionWatcher<HasMetadata> watcher = new WaitForConditionWatcher<HasMetadata>(condition);
            startTime = System.nanoTime();
            try (Watch ignored = this.watch(options, (Watcher<T>)watcher);){
                HasMetadata hasMetadata = watcher.getFuture().get(remainingNanosToWait, TimeUnit.NANOSECONDS);
                return (T)hasMetadata;
            }
            catch (ExecutionException e) {
                Throwable cause = e.getCause();
                if (!(cause instanceof WatcherException)) throw KubernetesClientException.launderThrowable(cause);
                if (!((WatcherException)cause).isShouldRetry()) throw KubernetesClientException.launderThrowable(cause);
                LOG.debug("retryable watch exception encountered, retrying after {} millis", (Object)currentBackOff, (Object)cause);
                Thread.sleep(currentBackOff);
                currentBackOff = (long)((double)currentBackOff * this.watchRetryBackoffMultiplier);
                continue;
            }
            catch (TimeoutException e) {}
            break;
        }
        LOG.debug("ran out of time waiting for watcher, wait condition not met");
        throw new IllegalArgumentException(this.type.getSimpleName() + " with name:[" + this.name + "] in namespace:[" + this.namespace + "] matching condition not found!");
    }

    private static String getResourceVersion(HasMetadata item) {
        return item == null ? null : item.getMetadata().getResourceVersion();
    }

    private static ListOptions createListOptions(String resourceVersion) {
        return ((ListOptionsBuilder)new ListOptionsBuilder().withResourceVersion(resourceVersion)).build();
    }

    public void setType(Class<T> type) {
        this.type = type;
    }

    public void setListType(Class<L> listType) {
        this.listType = listType;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    @Override
    public WritableOperation<T> dryRun(boolean isDryRun) {
        return this.newInstance(this.context.withDryRun(isDryRun));
    }
}

