/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.extended.run;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Predicate;
import io.fabric8.kubernetes.api.model.Quantity;
import io.fabric8.kubernetes.client.extended.run.RunConfig;
import io.fabric8.kubernetes.client.extended.run.RunConfigFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class RunConfigFluentImpl<A extends RunConfigFluent<A>>
extends BaseFluent<A>
implements RunConfigFluent<A> {
    private String name;
    private String image;
    private String imagePullPolicy;
    private String command;
    private List<String> args;
    private String restartPolicy;
    private String serviceAccount;
    private Map<String, String> labels;
    private Map<String, String> env;
    private Map<String, Quantity> limits;
    private Map<String, Quantity> requests;
    private int port;

    public RunConfigFluentImpl() {
    }

    public RunConfigFluentImpl(RunConfig instance) {
        this.withName(instance.getName());
        this.withImage(instance.getImage());
        this.withImagePullPolicy(instance.getImagePullPolicy());
        this.withCommand(instance.getCommand());
        this.withArgs(instance.getArgs());
        this.withRestartPolicy(instance.getRestartPolicy());
        this.withServiceAccount(instance.getServiceAccount());
        this.withLabels(instance.getLabels());
        this.withEnv(instance.getEnv());
        this.withLimits(instance.getLimits());
        this.withRequests(instance.getRequests());
        this.withPort(instance.getPort());
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public A withName(String name) {
        this.name = name;
        return (A)this;
    }

    @Override
    public Boolean hasName() {
        return this.name != null;
    }

    @Override
    public A withNewName(String arg1) {
        return this.withName(new String(arg1));
    }

    @Override
    public A withNewName(StringBuilder arg1) {
        return this.withName(new String(arg1));
    }

    @Override
    public A withNewName(StringBuffer arg1) {
        return this.withName(new String(arg1));
    }

    @Override
    public String getImage() {
        return this.image;
    }

    @Override
    public A withImage(String image) {
        this.image = image;
        return (A)this;
    }

    @Override
    public Boolean hasImage() {
        return this.image != null;
    }

    @Override
    public A withNewImage(String arg1) {
        return this.withImage(new String(arg1));
    }

    @Override
    public A withNewImage(StringBuilder arg1) {
        return this.withImage(new String(arg1));
    }

    @Override
    public A withNewImage(StringBuffer arg1) {
        return this.withImage(new String(arg1));
    }

    @Override
    public String getImagePullPolicy() {
        return this.imagePullPolicy;
    }

    @Override
    public A withImagePullPolicy(String imagePullPolicy) {
        this.imagePullPolicy = imagePullPolicy;
        return (A)this;
    }

    @Override
    public Boolean hasImagePullPolicy() {
        return this.imagePullPolicy != null;
    }

    @Override
    public A withNewImagePullPolicy(String arg1) {
        return this.withImagePullPolicy(new String(arg1));
    }

    @Override
    public A withNewImagePullPolicy(StringBuilder arg1) {
        return this.withImagePullPolicy(new String(arg1));
    }

    @Override
    public A withNewImagePullPolicy(StringBuffer arg1) {
        return this.withImagePullPolicy(new String(arg1));
    }

    @Override
    public String getCommand() {
        return this.command;
    }

    @Override
    public A withCommand(String command) {
        this.command = command;
        return (A)this;
    }

    @Override
    public Boolean hasCommand() {
        return this.command != null;
    }

    @Override
    public A withNewCommand(String arg1) {
        return this.withCommand(new String(arg1));
    }

    @Override
    public A withNewCommand(StringBuilder arg1) {
        return this.withCommand(new String(arg1));
    }

    @Override
    public A withNewCommand(StringBuffer arg1) {
        return this.withCommand(new String(arg1));
    }

    @Override
    public A addToArgs(int index, String item) {
        if (this.args == null) {
            this.args = new ArrayList<String>();
        }
        this.args.add(index, item);
        return (A)this;
    }

    @Override
    public A setToArgs(int index, String item) {
        if (this.args == null) {
            this.args = new ArrayList<String>();
        }
        this.args.set(index, item);
        return (A)this;
    }

    @Override
    public A addToArgs(String ... items) {
        if (this.args == null) {
            this.args = new ArrayList<String>();
        }
        for (String item : items) {
            this.args.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToArgs(Collection<String> items) {
        if (this.args == null) {
            this.args = new ArrayList<String>();
        }
        for (String item : items) {
            this.args.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromArgs(String ... items) {
        for (String item : items) {
            if (this.args == null) continue;
            this.args.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromArgs(Collection<String> items) {
        for (String item : items) {
            if (this.args == null) continue;
            this.args.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getArgs() {
        return this.args;
    }

    @Override
    public String getArg(int index) {
        return this.args.get(index);
    }

    @Override
    public String getFirstArg() {
        return this.args.get(0);
    }

    @Override
    public String getLastArg() {
        return this.args.get(this.args.size() - 1);
    }

    @Override
    public String getMatchingArg(Predicate<String> predicate) {
        for (String item : this.args) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingArg(Predicate<String> predicate) {
        for (String item : this.args) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withArgs(List<String> args) {
        if (this.args != null) {
            this._visitables.get((Object)"args").removeAll(this.args);
        }
        if (args != null) {
            this.args = new ArrayList<String>();
            for (String item : args) {
                this.addToArgs(item);
            }
        } else {
            this.args = null;
        }
        return (A)this;
    }

    @Override
    public A withArgs(String ... args) {
        if (this.args != null) {
            this.args.clear();
        }
        if (args != null) {
            for (String item : args) {
                this.addToArgs(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasArgs() {
        return this.args != null && !this.args.isEmpty();
    }

    @Override
    public A addNewArg(String arg1) {
        return this.addToArgs(new String(arg1));
    }

    @Override
    public A addNewArg(StringBuilder arg1) {
        return this.addToArgs(new String(arg1));
    }

    @Override
    public A addNewArg(StringBuffer arg1) {
        return this.addToArgs(new String(arg1));
    }

    @Override
    public String getRestartPolicy() {
        return this.restartPolicy;
    }

    @Override
    public A withRestartPolicy(String restartPolicy) {
        this.restartPolicy = restartPolicy;
        return (A)this;
    }

    @Override
    public Boolean hasRestartPolicy() {
        return this.restartPolicy != null;
    }

    @Override
    public A withNewRestartPolicy(String arg1) {
        return this.withRestartPolicy(new String(arg1));
    }

    @Override
    public A withNewRestartPolicy(StringBuilder arg1) {
        return this.withRestartPolicy(new String(arg1));
    }

    @Override
    public A withNewRestartPolicy(StringBuffer arg1) {
        return this.withRestartPolicy(new String(arg1));
    }

    @Override
    public String getServiceAccount() {
        return this.serviceAccount;
    }

    @Override
    public A withServiceAccount(String serviceAccount) {
        this.serviceAccount = serviceAccount;
        return (A)this;
    }

    @Override
    public Boolean hasServiceAccount() {
        return this.serviceAccount != null;
    }

    @Override
    public A withNewServiceAccount(String arg1) {
        return this.withServiceAccount(new String(arg1));
    }

    @Override
    public A withNewServiceAccount(StringBuilder arg1) {
        return this.withServiceAccount(new String(arg1));
    }

    @Override
    public A withNewServiceAccount(StringBuffer arg1) {
        return this.withServiceAccount(new String(arg1));
    }

    @Override
    public A addToLabels(String key, String value) {
        if (this.labels == null && key != null && value != null) {
            this.labels = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.labels.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToLabels(Map<String, String> map) {
        if (this.labels == null && map != null) {
            this.labels = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.labels.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromLabels(String key) {
        if (this.labels == null) {
            return (A)this;
        }
        if (key != null && this.labels != null) {
            this.labels.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromLabels(Map<String, String> map) {
        if (this.labels == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.labels == null) continue;
                this.labels.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, String> getLabels() {
        return this.labels;
    }

    @Override
    public A withLabels(Map<String, String> labels) {
        this.labels = labels == null ? null : new LinkedHashMap<String, String>(labels);
        return (A)this;
    }

    @Override
    public Boolean hasLabels() {
        return this.labels != null;
    }

    @Override
    public A addToEnv(String key, String value) {
        if (this.env == null && key != null && value != null) {
            this.env = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.env.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToEnv(Map<String, String> map) {
        if (this.env == null && map != null) {
            this.env = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.env.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromEnv(String key) {
        if (this.env == null) {
            return (A)this;
        }
        if (key != null && this.env != null) {
            this.env.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromEnv(Map<String, String> map) {
        if (this.env == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.env == null) continue;
                this.env.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, String> getEnv() {
        return this.env;
    }

    @Override
    public A withEnv(Map<String, String> env) {
        this.env = env == null ? null : new LinkedHashMap<String, String>(env);
        return (A)this;
    }

    @Override
    public Boolean hasEnv() {
        return this.env != null;
    }

    @Override
    public A addToLimits(String key, Quantity value) {
        if (this.limits == null && key != null && value != null) {
            this.limits = new LinkedHashMap<String, Quantity>();
        }
        if (key != null && value != null) {
            this.limits.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToLimits(Map<String, Quantity> map) {
        if (this.limits == null && map != null) {
            this.limits = new LinkedHashMap<String, Quantity>();
        }
        if (map != null) {
            this.limits.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromLimits(String key) {
        if (this.limits == null) {
            return (A)this;
        }
        if (key != null && this.limits != null) {
            this.limits.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromLimits(Map<String, Quantity> map) {
        if (this.limits == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.limits == null) continue;
                this.limits.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Quantity> getLimits() {
        return this.limits;
    }

    @Override
    public A withLimits(Map<String, Quantity> limits) {
        this.limits = limits == null ? null : new LinkedHashMap<String, Quantity>(limits);
        return (A)this;
    }

    @Override
    public Boolean hasLimits() {
        return this.limits != null;
    }

    @Override
    public A addToRequests(String key, Quantity value) {
        if (this.requests == null && key != null && value != null) {
            this.requests = new LinkedHashMap<String, Quantity>();
        }
        if (key != null && value != null) {
            this.requests.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToRequests(Map<String, Quantity> map) {
        if (this.requests == null && map != null) {
            this.requests = new LinkedHashMap<String, Quantity>();
        }
        if (map != null) {
            this.requests.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromRequests(String key) {
        if (this.requests == null) {
            return (A)this;
        }
        if (key != null && this.requests != null) {
            this.requests.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromRequests(Map<String, Quantity> map) {
        if (this.requests == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.requests == null) continue;
                this.requests.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Quantity> getRequests() {
        return this.requests;
    }

    @Override
    public A withRequests(Map<String, Quantity> requests) {
        this.requests = requests == null ? null : new LinkedHashMap<String, Quantity>(requests);
        return (A)this;
    }

    @Override
    public Boolean hasRequests() {
        return this.requests != null;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public A withPort(int port) {
        this.port = port;
        return (A)this;
    }

    @Override
    public Boolean hasPort() {
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RunConfigFluentImpl that = (RunConfigFluentImpl)o;
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.image != null ? !this.image.equals(that.image) : that.image != null) {
            return false;
        }
        if (this.imagePullPolicy != null ? !this.imagePullPolicy.equals(that.imagePullPolicy) : that.imagePullPolicy != null) {
            return false;
        }
        if (this.command != null ? !this.command.equals(that.command) : that.command != null) {
            return false;
        }
        if (this.args != null ? !this.args.equals(that.args) : that.args != null) {
            return false;
        }
        if (this.restartPolicy != null ? !this.restartPolicy.equals(that.restartPolicy) : that.restartPolicy != null) {
            return false;
        }
        if (this.serviceAccount != null ? !this.serviceAccount.equals(that.serviceAccount) : that.serviceAccount != null) {
            return false;
        }
        if (this.labels != null ? !this.labels.equals(that.labels) : that.labels != null) {
            return false;
        }
        if (this.env != null ? !this.env.equals(that.env) : that.env != null) {
            return false;
        }
        if (this.limits != null ? !this.limits.equals(that.limits) : that.limits != null) {
            return false;
        }
        if (this.requests != null ? !this.requests.equals(that.requests) : that.requests != null) {
            return false;
        }
        return this.port == that.port;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.image, this.imagePullPolicy, this.command, this.args, this.restartPolicy, this.serviceAccount, this.labels, this.env, this.limits, this.requests, this.port, super.hashCode());
    }
}

