/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.internal.readiness;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.KubernetesClientTimeoutException;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.internal.readiness.Readiness;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

public class ReadinessWatcher<T extends HasMetadata>
implements Watcher<T> {
    private final CountDownLatch latch = new CountDownLatch(1);
    private final AtomicReference<T> reference = new AtomicReference();
    private final T resource;

    public ReadinessWatcher(T resource) {
        this.resource = resource;
    }

    @Override
    public void eventReceived(Watcher.Action action, T resource) {
        switch (action) {
            case MODIFIED: {
                if (!Readiness.isReady(resource)) break;
                this.reference.set(resource);
                this.latch.countDown();
                break;
            }
        }
    }

    @Override
    public void onClose(KubernetesClientException e) {
    }

    public T await(long amount, TimeUnit timeUnit) {
        try {
            if (this.latch.await(amount, timeUnit)) {
                return (T)((HasMetadata)this.reference.get());
            }
            throw new KubernetesClientTimeoutException((HasMetadata)this.resource, amount, timeUnit);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new KubernetesClientTimeoutException((HasMetadata)this.resource, amount, timeUnit);
        }
    }
}

