/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.dsl.internal;

import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerBuilder;
import io.fabric8.kubernetes.api.model.DoneableReplicationController;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.PodTemplateSpecFluent;
import io.fabric8.kubernetes.api.model.ReplicationController;
import io.fabric8.kubernetes.api.model.ReplicationControllerBuilder;
import io.fabric8.kubernetes.api.model.ReplicationControllerFluent;
import io.fabric8.kubernetes.api.model.ReplicationControllerList;
import io.fabric8.kubernetes.api.model.ReplicationControllerSpecFluent;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.ClientNonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.ClientRollableScallableResource;
import io.fabric8.kubernetes.client.dsl.EditReplacePatchDeletable;
import io.fabric8.kubernetes.client.dsl.ImageEditReplacePatchable;
import io.fabric8.kubernetes.client.dsl.Reaper;
import io.fabric8.kubernetes.client.dsl.TimeoutImageEditReplacePatchable;
import io.fabric8.kubernetes.client.dsl.Watchable;
import io.fabric8.kubernetes.client.dsl.base.HasMetadataOperation;
import io.fabric8.kubernetes.client.dsl.internal.ReplicationControllerRollingUpdater;
import io.fabric8.kubernetes.client.internal.readiness.Readiness;
import io.fabric8.kubernetes.client.internal.readiness.ReadinessWatcher;
import io.fabric8.kubernetes.client.utils.Utils;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import okhttp3.OkHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReplicationControllerOperationsImpl
extends HasMetadataOperation<ReplicationController, ReplicationControllerList, DoneableReplicationController, ClientRollableScallableResource<ReplicationController, DoneableReplicationController>>
implements ClientRollableScallableResource<ReplicationController, DoneableReplicationController>,
TimeoutImageEditReplacePatchable<ReplicationController, ReplicationController, DoneableReplicationController> {
    static final transient Logger LOG = LoggerFactory.getLogger(ReplicationControllerOperationsImpl.class);
    private final Boolean rolling;
    private final long rollingTimeout;
    private final TimeUnit rollingTimeUnit;

    public ReplicationControllerOperationsImpl(OkHttpClient client, Config config, String namespace) {
        this(client, config, null, namespace, null, true, null, null, false, -1L, new TreeMap<String, String>(), new TreeMap<String, String>(), new TreeMap<String, String[]>(), new TreeMap<String, String[]>(), new TreeMap<String, String>(), false, config.getRollingTimeout(), TimeUnit.MILLISECONDS);
    }

    public ReplicationControllerOperationsImpl(OkHttpClient client, Config config, String apiVersion, String namespace, String name, Boolean cascading, ReplicationController item, String resourceVersion, Boolean reloadingFromServer, long gracePeriodSeconds, Map<String, String> labels, Map<String, String> labelsNot, Map<String, String[]> labelsIn, Map<String, String[]> labelsNotIn, Map<String, String> fields) {
        this(client, config, apiVersion, namespace, name, cascading, item, resourceVersion, reloadingFromServer, gracePeriodSeconds, labels, labelsNot, labelsIn, labelsNotIn, fields, false, config.getRollingTimeout(), TimeUnit.MILLISECONDS);
    }

    public ReplicationControllerOperationsImpl(OkHttpClient client, Config config, String apiVersion, String namespace, String name, Boolean cascading, ReplicationController item, String resourceVersion, Boolean reloadingFromServer, long gracePeriodSeconds, Map<String, String> labels, Map<String, String> labelsNot, Map<String, String[]> labelsIn, Map<String, String[]> labelsNotIn, Map<String, String> fields, Boolean rolling, long rollingTimeout, TimeUnit rollingTimeUnit) {
        super(client, config, null, apiVersion, "replicationcontrollers", namespace, name, cascading, item, resourceVersion, reloadingFromServer, gracePeriodSeconds, labels, labelsNot, labelsIn, labelsNotIn, fields);
        this.rolling = rolling;
        this.rollingTimeout = rollingTimeout;
        this.rollingTimeUnit = rollingTimeUnit;
        this.reaper = new ReplicationControllerReaper(this);
    }

    @Override
    public ClientRollableScallableResource<ReplicationController, DoneableReplicationController> load(InputStream is) {
        try {
            ReplicationController item = ReplicationControllerOperationsImpl.unmarshal(is, ReplicationController.class);
            return new ReplicationControllerOperationsImpl(this.client, this.getConfig(), this.getAPIVersion(), this.getNamespace(), this.getName(), this.isCascading(), item, this.getResourceVersion(), this.isReloadingFromServer(), this.getGracePeriodSeconds(), this.getLabels(), this.getLabelsNot(), this.getLabelsIn(), this.getLabelsNotIn(), this.getFields(), this.rolling, this.rollingTimeout, this.rollingTimeUnit);
        }
        catch (Throwable t) {
            throw KubernetesClientException.launderThrowable(t);
        }
    }

    @Override
    public ClientNonNamespaceOperation<ReplicationController, ReplicationControllerList, DoneableReplicationController, ClientRollableScallableResource<ReplicationController, DoneableReplicationController>> inNamespace(String namespace) {
        return new ReplicationControllerOperationsImpl(this.client, this.getConfig(), this.getAPIVersion(), namespace, this.getName(), this.isCascading(), (ReplicationController)this.getItem(), this.getResourceVersion(), this.isReloadingFromServer(), this.getGracePeriodSeconds(), this.getLabels(), this.getLabelsNot(), this.getLabelsIn(), this.getLabelsNotIn(), this.getFields(), this.rolling, this.rollingTimeout, this.rollingTimeUnit);
    }

    @Override
    public ImageEditReplacePatchable<ReplicationController, ReplicationController, DoneableReplicationController> withTimeout(long timeout, TimeUnit unit) {
        return new ReplicationControllerOperationsImpl(this.client, this.getConfig(), this.getAPIVersion(), this.namespace, this.getName(), this.isCascading(), (ReplicationController)this.getItem(), this.getResourceVersion(), this.isReloadingFromServer(), this.getGracePeriodSeconds(), this.getLabels(), this.getLabelsNot(), this.getLabelsIn(), this.getLabelsNotIn(), this.getFields(), this.rolling, timeout, unit);
    }

    @Override
    public ImageEditReplacePatchable<ReplicationController, ReplicationController, DoneableReplicationController> withTimeoutInMillis(long timeoutInMillis) {
        return new ReplicationControllerOperationsImpl(this.client, this.getConfig(), this.getAPIVersion(), this.namespace, this.getName(), this.isCascading(), (ReplicationController)this.getItem(), this.getResourceVersion(), this.isReloadingFromServer(), this.getGracePeriodSeconds(), this.getLabels(), this.getLabelsNot(), this.getLabelsIn(), this.getLabelsNotIn(), this.getFields(), this.rolling, timeoutInMillis, TimeUnit.MILLISECONDS);
    }

    @Override
    public ReplicationController scale(int count) {
        return this.scale(count, false);
    }

    @Override
    public ClientRollableScallableResource<ReplicationController, DoneableReplicationController> withName(String name) {
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("Name must be provided.");
        }
        return new ReplicationControllerOperationsImpl(this.client, this.getConfig(), this.getAPIVersion(), this.getNamespace(), name, this.isCascading(), (ReplicationController)this.getItem(), this.getResourceVersion(), this.isReloadingFromServer(), this.getGracePeriodSeconds(), this.getLabels(), this.getLabelsNot(), this.getLabelsIn(), this.getLabelsNotIn(), this.getFields(), this.rolling, this.rollingTimeout, this.rollingTimeUnit);
    }

    @Override
    public ClientRollableScallableResource<ReplicationController, DoneableReplicationController> fromServer() {
        return new ReplicationControllerOperationsImpl(this.client, this.getConfig(), this.getAPIVersion(), this.getNamespace(), this.getName(), this.isCascading(), (ReplicationController)this.getItem(), this.getResourceVersion(), true, this.getGracePeriodSeconds(), this.getLabels(), this.getLabelsNot(), this.getLabelsIn(), this.getLabelsNotIn(), this.getFields(), this.rolling, this.rollingTimeout, this.rollingTimeUnit);
    }

    @Override
    public Watchable<Watch, Watcher<ReplicationController>> withResourceVersion(String resourceVersion) {
        return new ReplicationControllerOperationsImpl(this.client, this.getConfig(), this.getAPIVersion(), this.getNamespace(), this.getName(), this.isCascading(), (ReplicationController)this.getItem(), resourceVersion, this.isReloadingFromServer(), this.getGracePeriodSeconds(), this.getLabels(), this.getLabelsNot(), this.getLabelsIn(), this.getLabelsNotIn(), this.getFields(), this.rolling, this.rollingTimeout, this.rollingTimeUnit);
    }

    @Override
    public EditReplacePatchDeletable<ReplicationController, ReplicationController, DoneableReplicationController, Boolean> cascading(boolean enabled) {
        return new ReplicationControllerOperationsImpl(this.client, this.getConfig(), this.getAPIVersion(), this.getNamespace(), this.getName(), enabled, (ReplicationController)this.getItem(), this.getResourceVersion(), this.isReloadingFromServer(), this.getGracePeriodSeconds(), this.getLabels(), this.getLabelsNot(), this.getLabelsIn(), this.getLabelsNotIn(), this.getFields(), this.rolling, this.rollingTimeout, this.rollingTimeUnit);
    }

    @Override
    public ReplicationController scale(int count, boolean wait) {
        ReplicationController res = ((DoneableReplicationController)((ReplicationControllerFluent.SpecNested)((DoneableReplicationController)this.cascading(false).edit()).editSpec().withReplicas(Integer.valueOf(count))).endSpec()).done();
        if (wait) {
            this.waitUntilRCIsScaled(count);
            res = (ReplicationController)this.getMandatory();
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitUntilRCIsScaled(final int count) {
        final ArrayBlockingQueue<Object> queue = new ArrayBlockingQueue<Object>(1);
        final AtomicReference<Integer> replicasRef = new AtomicReference<Integer>(0);
        String name = this.checkName(this.getItem());
        final String namespace = this.checkNamespace(this.getItem());
        Runnable rcPoller = new Runnable(){

            @Override
            public void run() {
                try {
                    ReplicationController rc = (ReplicationController)ReplicationControllerOperationsImpl.this.get();
                    if (rc == null) {
                        if (count == 0) {
                            queue.put(true);
                            return;
                        }
                        queue.put(new IllegalStateException("Can't wait for ReplicationController: " + ReplicationControllerOperationsImpl.this.checkName(ReplicationControllerOperationsImpl.this.getItem()) + " in namespace: " + ReplicationControllerOperationsImpl.this.checkName(ReplicationControllerOperationsImpl.this.getItem()) + " to scale. Resource is no longer available."));
                    }
                    replicasRef.set(rc.getStatus().getReplicas());
                    if (Objects.equals(rc.getSpec().getReplicas(), rc.getStatus().getReplicas())) {
                        queue.put(true);
                    } else {
                        LOG.debug("Only {}/{} replicas scheduled for ReplicationController: {} in namespace: {} seconds so waiting...", new Object[]{rc.getStatus().getReplicas(), rc.getSpec().getReplicas(), rc.getMetadata().getName(), namespace});
                    }
                }
                catch (Throwable t) {
                    LOG.error("Error while waiting for ReplicationController to be scaled.", t);
                }
            }
        };
        ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
        ScheduledFuture<?> poller = executor.scheduleWithFixedDelay(rcPoller, 0L, 100L, TimeUnit.MILLISECONDS);
        try {
            if (Utils.waitUntilReady(queue, this.rollingTimeout, this.rollingTimeUnit)) {
                LOG.debug("{}/{} pod(s) ready for ReplicationController: {} in namespace: {}.", new Object[]{replicasRef.get(), count, name, namespace});
            } else {
                LOG.error("{}/{} pod(s) ready for ReplicationController: {} in namespace: {}  after waiting for {} seconds so giving up", new Object[]{replicasRef.get(), count, name, namespace, this.rollingTimeUnit.toSeconds(this.rollingTimeout)});
            }
        }
        finally {
            poller.cancel(true);
            executor.shutdown();
        }
    }

    @Override
    public ReplicationControllerOperationsImpl rolling() {
        return new ReplicationControllerOperationsImpl(this.client, this.getConfig(), this.getAPIVersion(), this.getNamespace(), this.getName(), this.isCascading(), (ReplicationController)this.getItem(), this.getResourceVersion(), this.isReloadingFromServer(), this.getGracePeriodSeconds(), this.getLabels(), this.getLabelsNot(), this.getLabelsIn(), this.getLabelsNotIn(), this.getFields(), true, this.rollingTimeout, this.rollingTimeUnit);
    }

    @Override
    public ReplicationController updateImage(String image) {
        ReplicationController oldRC = (ReplicationController)this.get();
        if (oldRC == null) {
            throw new KubernetesClientException("Existing replication controller doesn't exist");
        }
        if (oldRC.getSpec().getTemplate().getSpec().getContainers().size() > 1) {
            throw new KubernetesClientException("Image update is not supported for multicontainer pods");
        }
        if (oldRC.getSpec().getTemplate().getSpec().getContainers().size() == 0) {
            throw new KubernetesClientException("Pod has no containers!");
        }
        Container updatedContainer = ((ContainerBuilder)new ContainerBuilder((Container)oldRC.getSpec().getTemplate().getSpec().getContainers().iterator().next()).withImage(image)).build();
        ReplicationControllerBuilder newRCBuilder = new ReplicationControllerBuilder(oldRC);
        ((ReplicationControllerFluent.SpecNested)((ReplicationControllerSpecFluent.TemplateNested)((PodTemplateSpecFluent.SpecNested)((ReplicationControllerBuilder)((ReplicationControllerFluent.MetadataNested)newRCBuilder.editMetadata().withResourceVersion(null)).endMetadata()).editSpec().editTemplate().editSpec().withContainers(Collections.singletonList(updatedContainer))).endSpec()).endTemplate()).endSpec();
        return new ReplicationControllerRollingUpdater(this.client, this.config, this.namespace).rollUpdate(oldRC, newRCBuilder.build());
    }

    @Override
    public DoneableReplicationController edit() {
        if (!this.rolling.booleanValue()) {
            return (DoneableReplicationController)super.edit();
        }
        Visitor<ReplicationController> visitor = new Visitor<ReplicationController>(){

            public void visit(ReplicationController rc) {
                try {
                    new ReplicationControllerRollingUpdater(ReplicationControllerOperationsImpl.this.client, ReplicationControllerOperationsImpl.this.config, ReplicationControllerOperationsImpl.this.namespace).rollUpdate((HasMetadata)ReplicationControllerOperationsImpl.this.getMandatory(), rc);
                }
                catch (Exception e) {
                    throw KubernetesClientException.launderThrowable(e);
                }
            }
        };
        try {
            return (DoneableReplicationController)this.getDoneableType().getDeclaredConstructor(this.getType(), Visitor.class).newInstance(this.get(), visitor);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw KubernetesClientException.launderThrowable(e);
        }
    }

    @Override
    public ReplicationController replace(ReplicationController rc) {
        if (!this.rolling.booleanValue()) {
            return super.replace(rc);
        }
        return new ReplicationControllerRollingUpdater(this.client, this.config, this.namespace, this.rollingTimeUnit.toMillis(this.rollingTimeout), this.getConfig().getLoggingInterval()).rollUpdate((HasMetadata)this.getMandatory(), rc);
    }

    @Override
    public ReplicationController waitUntilReady(long amount, TimeUnit timeUnit) throws InterruptedException {
        ReplicationController rc = (ReplicationController)this.get();
        if (rc == null) {
            throw new IllegalArgumentException("ReplicationController with name:[" + this.name + "] in namespace:[" + this.namespace + "] not found!");
        }
        if (Readiness.isReady((HasMetadata)rc)) {
            return rc;
        }
        ReadinessWatcher<ReplicationController> watcher = new ReadinessWatcher<ReplicationController>(rc);
        try (Watch watch = this.watch(watcher);){
            ReplicationController replicationController = watcher.await(amount, timeUnit);
            return replicationController;
        }
    }

    private static class ReplicationControllerReaper
    implements Reaper {
        private ReplicationControllerOperationsImpl oper;

        public ReplicationControllerReaper(ReplicationControllerOperationsImpl oper) {
            this.oper = oper;
        }

        @Override
        public boolean reap() {
            this.oper.scale(0, true);
            return false;
        }
    }
}

