/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client;

import io.fabric8.kubernetes.client.KubernetesClientException;
import java.util.concurrent.TimeUnit;

public class KubernetesClientTimeoutException
extends KubernetesClientException {
    private static final String RESOURCE_FORMAT = "Timed out waiting for [] milliseconds for [%s] with name:[%s] in namespace [%s].";
    private static final String RESOURCES_FORMAT = "Timed out waiting for [] milliseconds for multiple resources in namespace [%s].";

    public KubernetesClientTimeoutException(String kind, String name, String namespace, long amount, TimeUnit timeUnit) {
        super(String.format(RESOURCE_FORMAT, kind, name, namespace, timeUnit.toMillis(amount)));
    }

    public KubernetesClientTimeoutException(String namespace, long amount, TimeUnit timeUnit) {
        super(String.format(RESOURCES_FORMAT, namespace, timeUnit.toMillis(amount)));
    }
}

