/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.dsl.internal;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.squareup.okhttp.HttpUrl;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import com.squareup.okhttp.ws.WebSocket;
import com.squareup.okhttp.ws.WebSocketCall;
import com.squareup.okhttp.ws.WebSocketListener;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesResourceList;
import io.fabric8.kubernetes.api.model.Status;
import io.fabric8.kubernetes.api.model.WatchEvent;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.base.BaseOperation;
import io.fabric8.kubernetes.client.dsl.base.OperationSupport;
import java.io.IOException;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import okio.Buffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WatchConnectionManager<T, L extends KubernetesResourceList>
implements Watch {
    private static final ObjectMapper mapper = new ObjectMapper();
    private final AtomicBoolean forceClosed = new AtomicBoolean();
    private final AtomicReference<String> resourceVersion;
    private final BaseOperation<T, L, ?, ?> baseOperation;
    private final Watcher<T> watcher;
    private final int reconnectLimit;
    private final int reconnectInterval;
    private final AtomicInteger currentReconnectAttempt = new AtomicInteger(0);
    private final AtomicReference<WebSocket> webSocketRef = new AtomicReference();
    private final ExecutorService executor = Executors.newSingleThreadExecutor();
    private final AtomicBoolean started = new AtomicBoolean(false);
    private final ArrayBlockingQueue<Object> queue = new ArrayBlockingQueue(1);
    private WebSocketCall webSocketCall;
    private OkHttpClient clonedClient;

    public WatchConnectionManager(OkHttpClient client, BaseOperation<T, L, ?, ?> baseOperation, String version, Watcher<T> watcher, int reconnectInterval, int reconnectLimit) throws InterruptedException, ExecutionException, MalformedURLException {
        if (version == null) {
            L currentList = baseOperation.list();
            this.resourceVersion = new AtomicReference<String>(currentList.getMetadata().getResourceVersion());
        } else {
            this.resourceVersion = new AtomicReference<String>(version);
        }
        this.clonedClient = client.clone();
        this.baseOperation = baseOperation;
        this.watcher = watcher;
        this.reconnectInterval = reconnectInterval;
        this.reconnectLimit = reconnectLimit;
        this.runWatch();
    }

    private final void runWatch() throws MalformedURLException, ExecutionException, InterruptedException {
        URL requestUrl = this.baseOperation.getNamespacedUrl();
        HttpUrl.Builder httpUrlBuilder = HttpUrl.get((URL)requestUrl).newBuilder();
        String labelQueryParam = this.baseOperation.getLabelQueryParam();
        if (labelQueryParam.length() > 0) {
            httpUrlBuilder.addQueryParameter("labelSelector", labelQueryParam);
        }
        String fieldQueryString = this.baseOperation.getFieldQueryParam();
        String name = this.baseOperation.getName();
        if (name != null && name.length() > 0) {
            if (fieldQueryString.length() > 0) {
                fieldQueryString = fieldQueryString + ",";
            }
            fieldQueryString = fieldQueryString + "metadata.name=" + name;
        }
        httpUrlBuilder.addQueryParameter("fieldSelector", fieldQueryString);
        httpUrlBuilder.addQueryParameter("resourceVersion", this.resourceVersion.get()).addQueryParameter("watch", "true");
        Request request = new Request.Builder().get().url(httpUrlBuilder.build()).addHeader("Origin", requestUrl.getProtocol() + "://" + requestUrl.getHost() + ":" + requestUrl.getPort()).build();
        this.clonedClient.setReadTimeout(0L, TimeUnit.MILLISECONDS);
        this.webSocketCall = WebSocketCall.create((OkHttpClient)this.clonedClient, (Request)request);
        this.webSocketCall.enqueue(new WebSocketListener(){
            private final Logger logger = LoggerFactory.getLogger(this.getClass());

            public void onOpen(WebSocket webSocket, Response response) {
                WatchConnectionManager.this.webSocketRef.set(webSocket);
                WatchConnectionManager.this.currentReconnectAttempt.set(0);
                WatchConnectionManager.this.started.set(true);
                WatchConnectionManager.this.queue.add(true);
            }

            public void onFailure(IOException e, Response response) {
                Status status = OperationSupport.createStatus(response);
                this.logger.error("Exec Failure: HTTP:" + status.getCode() + ". Message:" + status.getMessage(), (Throwable)e);
                if (!WatchConnectionManager.this.started.get()) {
                    WatchConnectionManager.this.queue.add(new KubernetesClientException(status));
                }
                try {
                    if (response != null && response.body() != null) {
                        response.body().close();
                    }
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
                if (WatchConnectionManager.this.forceClosed.get()) {
                    WatchConnectionManager.this.watcher.onClose(null);
                    return;
                }
                if (WatchConnectionManager.this.reconnectLimit >= 0 && WatchConnectionManager.this.currentReconnectAttempt.getAndIncrement() >= WatchConnectionManager.this.reconnectLimit) {
                    WatchConnectionManager.this.watcher.onClose(new KubernetesClientException("Connection unexpectedly closed", e));
                    return;
                }
                try {
                    TimeUnit.MILLISECONDS.sleep(WatchConnectionManager.this.reconnectInterval);
                }
                catch (InterruptedException e1) {
                    WatchConnectionManager.this.watcher.onClose(new KubernetesClientException("Connection unexpectedly closed", e1));
                    return;
                }
                this.onClose(4000, "Connection unexpectedly closed");
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onMessage(ResponseBody message) throws IOException {
                try {
                    WatchEvent event = (WatchEvent)mapper.readValue(message.byteStream(), WatchEvent.class);
                    HasMetadata obj = event.getObject();
                    String currentResourceVersion = (String)WatchConnectionManager.this.resourceVersion.get();
                    String newResourceVersion = obj.getMetadata().getResourceVersion();
                    if (currentResourceVersion.compareTo(newResourceVersion) < 0) {
                        WatchConnectionManager.this.resourceVersion.compareAndSet(currentResourceVersion, newResourceVersion);
                    }
                    Watcher.Action action = Watcher.Action.valueOf(event.getType());
                    WatchConnectionManager.this.watcher.eventReceived(action, obj);
                }
                catch (IOException e) {
                    this.logger.error("Could not deserialize watch event: {}", (Object)message.source().readUtf8(), (Object)e);
                }
                catch (ClassCastException e) {
                    this.logger.error("Received wrong type of object for watch", (Throwable)e);
                }
                catch (IllegalArgumentException e) {
                    this.logger.error("Invalid event type", (Throwable)e);
                }
                finally {
                    message.close();
                }
            }

            public void onPong(Buffer buffer) {
            }

            public void onClose(final int code, final String reason) {
                if (WatchConnectionManager.this.forceClosed.get()) {
                    WatchConnectionManager.this.watcher.onClose(null);
                    return;
                }
                WatchConnectionManager.this.executor.submit(new Runnable(){

                    @Override
                    public void run() {
                        block6: {
                            try {
                                WatchConnectionManager.this.runWatch();
                            }
                            catch (ExecutionException e) {
                                if (e.getCause() == null || e.getCause().getCause() == null || !(e.getCause().getCause() instanceof ConnectException)) break block6;
                                if (WatchConnectionManager.this.reconnectLimit >= 0 && WatchConnectionManager.this.currentReconnectAttempt.getAndIncrement() >= WatchConnectionManager.this.reconnectLimit) {
                                    WatchConnectionManager.this.watcher.onClose(new KubernetesClientException("Connection unexpectedly closed", e));
                                    return;
                                }
                                try {
                                    TimeUnit.MILLISECONDS.sleep(WatchConnectionManager.this.reconnectInterval);
                                }
                                catch (InterruptedException e1) {
                                    WatchConnectionManager.this.watcher.onClose(new KubernetesClientException("Connection unexpectedly closed", e1));
                                    return;
                                }
                                this.onClose(code, reason);
                            }
                            catch (InterruptedException | MalformedURLException e) {
                                throw KubernetesClientException.launderThrowable(e);
                            }
                        }
                    }
                });
            }
        });
    }

    public void waitUntilReady() {
        try {
            Object obj = this.queue.poll(10L, TimeUnit.SECONDS);
            if (obj instanceof Boolean && ((Boolean)obj).booleanValue()) {
                return;
            }
            if (obj instanceof Throwable) {
                throw (Throwable)obj;
            }
        }
        catch (Throwable t) {
            throw KubernetesClientException.launderThrowable(t);
        }
    }

    @Override
    public void close() {
        this.forceClosed.set(true);
        try {
            WebSocket ws = this.webSocketRef.get();
            if (ws != null) {
                ws.close(1000, "Closing...");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            this.executor.shutdown();
            if (!this.executor.awaitTermination(10L, TimeUnit.SECONDS)) {
                this.executor.shutdownNow();
            }
        }
        catch (Throwable t) {
            throw KubernetesClientException.launderThrowable(t);
        }
    }
}

