/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.internal.org.jboss.netty.handler.codec.socks;

import io.fabric8.kubernetes.client.internal.org.jboss.netty.buffer.ChannelBuffer;

public abstract class SocksMessage {
    private final MessageType messageType;
    private final ProtocolVersion protocolVersion = ProtocolVersion.SOCKS5;

    protected SocksMessage(MessageType messageType) {
        if (messageType == null) {
            throw new NullPointerException("messageType");
        }
        this.messageType = messageType;
    }

    public MessageType getMessageType() {
        return this.messageType;
    }

    public ProtocolVersion getProtocolVersion() {
        return this.protocolVersion;
    }

    public abstract void encodeAsByteBuf(ChannelBuffer var1) throws Exception;

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SubnegotiationVersion {
        AUTH_PASSWORD(1),
        UNKNOWN(-1);

        private final byte b;

        private SubnegotiationVersion(byte b) {
            this.b = b;
        }

        public static SubnegotiationVersion fromByte(byte b) {
            for (SubnegotiationVersion code : SubnegotiationVersion.values()) {
                if (code.b != b) continue;
                return code;
            }
            return UNKNOWN;
        }

        public byte getByteValue() {
            return this.b;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ProtocolVersion {
        SOCKS4a(4),
        SOCKS5(5),
        UNKNOWN(-1);

        private final byte b;

        private ProtocolVersion(byte b) {
            this.b = b;
        }

        public static ProtocolVersion fromByte(byte b) {
            for (ProtocolVersion code : ProtocolVersion.values()) {
                if (code.b != b) continue;
                return code;
            }
            return UNKNOWN;
        }

        public byte getByteValue() {
            return this.b;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CmdStatus {
        SUCCESS(0),
        FAILURE(1),
        FORBIDDEN(2),
        NETWORK_UNREACHABLE(3),
        HOST_UNREACHABLE(4),
        REFUSED(5),
        TTL_EXPIRED(6),
        COMMAND_NOT_SUPPORTED(7),
        ADDRESS_NOT_SUPPORTED(8),
        UNASSIGNED(-1);

        private final byte b;

        private CmdStatus(byte b) {
            this.b = b;
        }

        public static CmdStatus fromByte(byte b) {
            for (CmdStatus code : CmdStatus.values()) {
                if (code.b != b) continue;
                return code;
            }
            return UNASSIGNED;
        }

        public byte getByteValue() {
            return this.b;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum AuthStatus {
        SUCCESS(0),
        FAILURE(-1);

        private final byte b;

        private AuthStatus(byte b) {
            this.b = b;
        }

        public static AuthStatus fromByte(byte b) {
            for (AuthStatus code : AuthStatus.values()) {
                if (code.b != b) continue;
                return code;
            }
            return FAILURE;
        }

        public byte getByteValue() {
            return this.b;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum AddressType {
        IPv4(1),
        DOMAIN(3),
        IPv6(4),
        UNKNOWN(-1);

        private final byte b;

        private AddressType(byte b) {
            this.b = b;
        }

        public static AddressType fromByte(byte b) {
            for (AddressType code : AddressType.values()) {
                if (code.b != b) continue;
                return code;
            }
            return UNKNOWN;
        }

        public byte getByteValue() {
            return this.b;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CmdType {
        CONNECT(1),
        BIND(2),
        UDP(3),
        UNKNOWN(-1);

        private final byte b;

        private CmdType(byte b) {
            this.b = b;
        }

        public static CmdType fromByte(byte b) {
            for (CmdType code : CmdType.values()) {
                if (code.b != b) continue;
                return code;
            }
            return UNKNOWN;
        }

        public byte getByteValue() {
            return this.b;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum AuthScheme {
        NO_AUTH(0),
        AUTH_GSSAPI(1),
        AUTH_PASSWORD(2),
        UNKNOWN(-1);

        private final byte b;

        private AuthScheme(byte b) {
            this.b = b;
        }

        public static AuthScheme fromByte(byte b) {
            for (AuthScheme code : AuthScheme.values()) {
                if (code.b != b) continue;
                return code;
            }
            return UNKNOWN;
        }

        public byte getByteValue() {
            return this.b;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MessageType {
        REQUEST,
        RESPONSE,
        UNKNOWN;

    }
}

