/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.internal.com.ning.http.client.providers.netty.request.body;

import io.fabric8.kubernetes.client.internal.com.ning.http.client.AsyncHttpClientConfig;
import io.fabric8.kubernetes.client.internal.com.ning.http.client.Body;
import io.fabric8.kubernetes.client.internal.com.ning.http.client.BodyGenerator;
import io.fabric8.kubernetes.client.internal.com.ning.http.client.RandomAccessBody;
import io.fabric8.kubernetes.client.internal.com.ning.http.client.providers.netty.NettyAsyncHttpProviderConfig;
import io.fabric8.kubernetes.client.internal.com.ning.http.client.providers.netty.channel.ChannelManager;
import io.fabric8.kubernetes.client.internal.com.ning.http.client.providers.netty.future.NettyResponseFuture;
import io.fabric8.kubernetes.client.internal.com.ning.http.client.providers.netty.request.ProgressListener;
import io.fabric8.kubernetes.client.internal.com.ning.http.client.providers.netty.request.body.BodyChunkedInput;
import io.fabric8.kubernetes.client.internal.com.ning.http.client.providers.netty.request.body.BodyFileRegion;
import io.fabric8.kubernetes.client.internal.com.ning.http.client.providers.netty.request.body.FeedableBodyGenerator;
import io.fabric8.kubernetes.client.internal.com.ning.http.client.providers.netty.request.body.NettyBody;
import io.fabric8.kubernetes.client.internal.com.ning.http.util.MiscUtils;
import io.fabric8.kubernetes.client.internal.org.jboss.netty.channel.Channel;
import io.fabric8.kubernetes.client.internal.org.jboss.netty.channel.ChannelFuture;
import io.fabric8.kubernetes.client.internal.org.jboss.netty.handler.stream.ChunkedWriteHandler;
import java.io.IOException;

public class NettyBodyBody
implements NettyBody {
    private final Body body;
    private final NettyAsyncHttpProviderConfig nettyConfig;

    public NettyBodyBody(Body body, NettyAsyncHttpProviderConfig nettyConfig) {
        this.body = body;
        this.nettyConfig = nettyConfig;
    }

    public Body getBody() {
        return this.body;
    }

    @Override
    public long getContentLength() {
        return this.body.getContentLength();
    }

    @Override
    public String getContentType() {
        return null;
    }

    @Override
    public void write(final Channel channel, NettyResponseFuture<?> future, AsyncHttpClientConfig config) throws IOException {
        Object msg;
        if (this.body instanceof RandomAccessBody && !ChannelManager.isSslHandlerConfigured(channel.getPipeline()) && !this.nettyConfig.isDisableZeroCopy()) {
            msg = new BodyFileRegion((RandomAccessBody)this.body);
        } else {
            msg = new BodyChunkedInput(this.body);
            BodyGenerator bg = future.getRequest().getBodyGenerator();
            if (bg instanceof FeedableBodyGenerator) {
                ((FeedableBodyGenerator)FeedableBodyGenerator.class.cast(bg)).setListener(new FeedableBodyGenerator.FeedListener(){

                    @Override
                    public void onContentAdded() {
                        channel.getPipeline().get(ChunkedWriteHandler.class).resumeTransfer();
                    }
                });
            }
        }
        channel.write(msg).addListener(new ProgressListener(config, future.getAsyncHandler(), future, false){

            @Override
            public void operationComplete(ChannelFuture cf) {
                MiscUtils.closeSilently(NettyBodyBody.this.body);
                super.operationComplete(cf);
            }
        });
    }
}

