/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.osgi;

import io.fabric8.kubernetes.api.model.DoneableEndpoints;
import io.fabric8.kubernetes.api.model.DoneableEvent;
import io.fabric8.kubernetes.api.model.DoneableNamespace;
import io.fabric8.kubernetes.api.model.DoneableNode;
import io.fabric8.kubernetes.api.model.DoneablePersistentVolume;
import io.fabric8.kubernetes.api.model.DoneablePersistentVolumeClaim;
import io.fabric8.kubernetes.api.model.DoneablePod;
import io.fabric8.kubernetes.api.model.DoneableReplicationController;
import io.fabric8.kubernetes.api.model.DoneableResourceQuota;
import io.fabric8.kubernetes.api.model.DoneableSecret;
import io.fabric8.kubernetes.api.model.DoneableSecurityContextConstraints;
import io.fabric8.kubernetes.api.model.DoneableService;
import io.fabric8.kubernetes.api.model.DoneableServiceAccount;
import io.fabric8.kubernetes.api.model.Endpoints;
import io.fabric8.kubernetes.api.model.EndpointsList;
import io.fabric8.kubernetes.api.model.Event;
import io.fabric8.kubernetes.api.model.EventList;
import io.fabric8.kubernetes.api.model.Namespace;
import io.fabric8.kubernetes.api.model.NamespaceList;
import io.fabric8.kubernetes.api.model.Node;
import io.fabric8.kubernetes.api.model.NodeList;
import io.fabric8.kubernetes.api.model.PersistentVolume;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaim;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimList;
import io.fabric8.kubernetes.api.model.PersistentVolumeList;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.api.model.ReplicationController;
import io.fabric8.kubernetes.api.model.ReplicationControllerList;
import io.fabric8.kubernetes.api.model.ResourceQuota;
import io.fabric8.kubernetes.api.model.ResourceQuotaList;
import io.fabric8.kubernetes.api.model.RootPaths;
import io.fabric8.kubernetes.api.model.Secret;
import io.fabric8.kubernetes.api.model.SecretList;
import io.fabric8.kubernetes.api.model.SecurityContextConstraints;
import io.fabric8.kubernetes.api.model.SecurityContextConstraintsList;
import io.fabric8.kubernetes.api.model.ServiceAccount;
import io.fabric8.kubernetes.api.model.ServiceAccountList;
import io.fabric8.kubernetes.api.model.ServiceList;
import io.fabric8.kubernetes.client.Adapters;
import io.fabric8.kubernetes.client.BaseClient;
import io.fabric8.kubernetes.client.Client;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.EditableConfig;
import io.fabric8.kubernetes.client.ExtensionAdapter;
import io.fabric8.kubernetes.client.Handlers;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.dsl.ClientKubernetesListMixedOperation;
import io.fabric8.kubernetes.client.dsl.ClientLoggableResource;
import io.fabric8.kubernetes.client.dsl.ClientMixedOperation;
import io.fabric8.kubernetes.client.dsl.ClientNonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.ClientResource;
import io.fabric8.kubernetes.client.dsl.ClientRollableScallableResource;
import io.fabric8.kubernetes.client.utils.Utils;
import java.net.URL;
import java.util.Map;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.References;
import org.apache.felix.scr.annotations.Service;

@Component(immediate=true, configurationPid="io.fabric8.kubernetes.client", policy=ConfigurationPolicy.OPTIONAL)
@Service(value={KubernetesClient.class})
@References(value={@Reference(referenceInterface=ResourceHandler.class, cardinality=ReferenceCardinality.OPTIONAL_MULTIPLE, policy=ReferencePolicy.DYNAMIC, bind="bindResourceHandler", unbind="unbindResourceHandler"), @Reference(referenceInterface=ExtensionAdapter.class, cardinality=ReferenceCardinality.OPTIONAL_MULTIPLE, policy=ReferencePolicy.DYNAMIC, bind="bindExtensionAdapter", unbind="unbindExtensionAdapter")})
public class ManagedKubernetesClient
extends BaseClient
implements KubernetesClient {
    @Property(name="kubernetes.master", description="Master URL", value={"https://kubernetes.default.svc"})
    private String masterUrl = Utils.getSystemPropertyOrEnvVar("kubernetes.master", "https://kubernetes.default.svc");
    @Property(name="kubernetes.api.version", description="Api Version", value={"v1"})
    private String apiVersion = Utils.getSystemPropertyOrEnvVar("kubernetes.api.version", "v1");
    @Property(name="kubernetes.namespace", description="Default namespace", value={"default"})
    private String namespace = Utils.getSystemPropertyOrEnvVar("kubernetes.namespace", "default");
    @Property(name="kubernetes.certs.ca.file", description="CA Certificate (Path to file)")
    private String caCertFile = Utils.getSystemPropertyOrEnvVar("kubernetes.certs.ca.file");
    @Property(name="kubernetes.certs.ca.data", description="CA Certificate (Data)")
    private String caCertData = Utils.getSystemPropertyOrEnvVar("kubernetes.certs.ca.data");
    @Property(name="kubernetes.certs.client.file", description="Client Certificate (Path to file)")
    private String clientCertFile = Utils.getSystemPropertyOrEnvVar("kubernetes.certs.client.file");
    @Property(name="kubernetes.certs.client.data", description="Client Certificate (Data)")
    private String clientCertData = Utils.getSystemPropertyOrEnvVar("kubernetes.certs.client.data");
    @Property(name="kubernetes.certs.client.key.file", description="Client Key (Path to file)")
    private String clientKeyFile = Utils.getSystemPropertyOrEnvVar("kubernetes.certs.client.key.file");
    @Property(name="kubernetes.certs.client.key.data", description="Client Key (Data)")
    private String clientKeyData = Utils.getSystemPropertyOrEnvVar("kubernetes.certs.client.key.data");
    @Property(name="kubernetes.certs.client.key.algo", description="Client Key Algorithm")
    private String clientKeyAlgo = Utils.getSystemPropertyOrEnvVar("kubernetes.certs.client.key.algo", "RSA");
    @Property(name="kubernetes.certs.client.key.passphrase", description="Client passphrase")
    private String clientKeyPassphrase = Utils.getSystemPropertyOrEnvVar("kubernetes.certs.client.key.passphrase", "changeit");
    @Property(name="kubernetes.auth.basic.username", description="Username")
    private String username = Utils.getSystemPropertyOrEnvVar("kubernetes.auth.basic.username");
    @Property(name="kubernetes.auth.basic.password", description="Username")
    private String password = Utils.getSystemPropertyOrEnvVar("kubernetes.auth.basic.password");
    @Property(name="kubernetes.auth.token", description="OAuth Token")
    private String oauthToken = Utils.getSystemPropertyOrEnvVar("kubernetes.auth.token");
    @Property(name="kubernetes.watch.reconnectInterval", description="Watch reconnect interval", intValue={1000})
    private int watchReconnectInterval = Integer.parseInt(Utils.getSystemPropertyOrEnvVar("kubernetes.watch.reconnectInterval", "1000"));
    @Property(name="kubernetes.watch.reconnectLimit", description="Watch reconnect limit", intValue={-1})
    private int watchReconnectLimit = Integer.parseInt(Utils.getSystemPropertyOrEnvVar("kubernetes.watch.reconnectLimit", "-1"));
    @Property(name="kubernetes.request.timeout", description="Request timeout", intValue={10000})
    private int requestTimeout = Integer.parseInt(Utils.getSystemPropertyOrEnvVar("kubernetes.request.timeout", "10000"));
    @Property(name="http.proxy", description="HTTP Proxy")
    private String httpProxy = Utils.getSystemPropertyOrEnvVar("http.proxy");
    @Property(name="https.proxy", description="HTTPS Proxy")
    private String httpsProxy = Utils.getSystemPropertyOrEnvVar("https.proxy");
    @Property(name="all.proxy", description="All Proxy")
    private String allProxy = Utils.getSystemPropertyOrEnvVar("all.proxy");
    @Property(name="no.proxy", description="No Proxy")
    private String noProxy = Utils.getSystemPropertyOrEnvVar("no.proxy");
    @Property(name="kubernetes.trust.certificates", description="Kubernetes trust certifacates flag", boolValue={false})
    private Boolean trustCerts = Utils.getSystemPropertyOrEnvVar("kubernetes.trust.certificates", Boolean.FALSE);
    private KubernetesClient delegate;

    @Activate
    public void activate(Map<String, Object> properties) {
        String noProxyProperty = (String)properties.get("no.proxy");
        String[] noProxy = noProxyProperty != null ? noProxyProperty.split(",") : null;
        EditableConfig config = ((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)new ConfigBuilder().withMasterUrl((String)properties.get("kubernetes.master"))).withApiVersion((String)properties.get("kubernetes.api.version"))).withNamespace((String)properties.get("kubernetes.namespace"))).withCaCertFile((String)properties.get("kubernetes.certs.ca.file"))).withCaCertData((String)properties.get("kubernetes.certs.ca.data"))).withClientCertFile((String)properties.get("kubernetes.certs.client.file"))).withClientCertData((String)properties.get("kubernetes.certs.client.data"))).withClientKeyFile((String)properties.get("kubernetes.certs.client.key.file"))).withClientKeyData((String)properties.get("kubernetes.certs.client.key.data"))).withClientKeyAlgo((String)properties.get("kubernetes.certs.client.key.algo"))).withClientKeyPassphrase((String)properties.get("kubernetes.certs.client.key.passphrase"))).withUsername((String)properties.get("kubernetes.auth.basic.username"))).withPassword((String)properties.get("kubernetes.auth.basic.password"))).withOauthToken((String)properties.get("kubernetes.auth.token"))).withWatchReconnectInterval((Integer)properties.get("kubernetes.watch.reconnectInterval"))).withWatchReconnectLimit((Integer)properties.get("kubernetes.watch.reconnectLimit"))).withRequestTimeout((Integer)properties.get("kubernetes.request.timeout"))).withHttpProxy((String)properties.get("http.proxy"))).withHttpsProxy((String)properties.get("https.proxy"))).withNoProxy(noProxy)).build();
        this.delegate = new DefaultKubernetesClient(config);
    }

    @Deactivate
    public void deactivate() {
        this.delegate.close();
    }

    @Override
    public ClientMixedOperation<Endpoints, EndpointsList, DoneableEndpoints, ClientResource<Endpoints, DoneableEndpoints>> endpoints() {
        return this.delegate.endpoints();
    }

    @Override
    public ClientMixedOperation<Pod, PodList, DoneablePod, ClientLoggableResource<Pod, DoneablePod>> pods() {
        return this.delegate.pods();
    }

    @Override
    public ClientMixedOperation<io.fabric8.kubernetes.api.model.Service, ServiceList, DoneableService, ClientResource<io.fabric8.kubernetes.api.model.Service, DoneableService>> services() {
        return this.delegate.services();
    }

    @Override
    public ClientNonNamespaceOperation<Namespace, NamespaceList, DoneableNamespace, ClientResource<Namespace, DoneableNamespace>> namespaces() {
        return this.delegate.namespaces();
    }

    @Override
    public ClientMixedOperation<ServiceAccount, ServiceAccountList, DoneableServiceAccount, ClientResource<ServiceAccount, DoneableServiceAccount>> serviceAccounts() {
        return this.delegate.serviceAccounts();
    }

    @Override
    public ClientMixedOperation<PersistentVolume, PersistentVolumeList, DoneablePersistentVolume, ClientResource<PersistentVolume, DoneablePersistentVolume>> persistentVolumes() {
        return this.delegate.persistentVolumes();
    }

    @Override
    public ClientMixedOperation<ResourceQuota, ResourceQuotaList, DoneableResourceQuota, ClientResource<ResourceQuota, DoneableResourceQuota>> resourceQuotas() {
        return this.delegate.resourceQuotas();
    }

    @Override
    public ClientKubernetesListMixedOperation lists() {
        return this.delegate.lists();
    }

    @Override
    public ClientNonNamespaceOperation<SecurityContextConstraints, SecurityContextConstraintsList, DoneableSecurityContextConstraints, ClientResource<SecurityContextConstraints, DoneableSecurityContextConstraints>> securityContextConstraints() {
        return this.delegate.securityContextConstraints();
    }

    @Override
    public ClientNonNamespaceOperation<Node, NodeList, DoneableNode, ClientResource<Node, DoneableNode>> nodes() {
        return this.delegate.nodes();
    }

    @Override
    public KubernetesClient inNamespace(String name) {
        return (KubernetesClient)this.delegate.inNamespace(name);
    }

    @Override
    public KubernetesClient inAnyNamespace() {
        return (KubernetesClient)this.delegate.inAnyNamespace();
    }

    @Override
    public ClientMixedOperation<PersistentVolumeClaim, PersistentVolumeClaimList, DoneablePersistentVolumeClaim, ClientResource<PersistentVolumeClaim, DoneablePersistentVolumeClaim>> persistentVolumeClaims() {
        return this.delegate.persistentVolumeClaims();
    }

    @Override
    public ClientMixedOperation<Event, EventList, DoneableEvent, ClientResource<Event, DoneableEvent>> events() {
        return this.delegate.events();
    }

    @Override
    public ClientMixedOperation<ReplicationController, ReplicationControllerList, DoneableReplicationController, ClientRollableScallableResource<ReplicationController, DoneableReplicationController>> replicationControllers() {
        return this.delegate.replicationControllers();
    }

    @Override
    public ClientMixedOperation<Secret, SecretList, DoneableSecret, ClientResource<Secret, DoneableSecret>> secrets() {
        return this.delegate.secrets();
    }

    @Override
    public RootPaths rootPaths() {
        return this.delegate.rootPaths();
    }

    @Override
    public String getApiVersion() {
        return this.delegate.getApiVersion();
    }

    @Override
    public String getNamespace() {
        return this.delegate.getNamespace();
    }

    @Override
    public URL getMasterUrl() {
        return this.delegate.getMasterUrl();
    }

    @Override
    public <C extends Client> C adapt(Class<C> type) {
        return this.delegate.adapt(type);
    }

    @Override
    public void close() {
        this.delegate.close();
    }

    @Override
    public Config getConfiguration() {
        return this.delegate.getConfiguration();
    }

    public void bindResourceHandler(ResourceHandler resourceHandler) {
        Handlers.register(resourceHandler);
    }

    public void unbindResourceHandler(ResourceHandler resourceHandler) {
        Handlers.unregister(resourceHandler);
    }

    public void bindExtensionAdapter(ExtensionAdapter adapter) {
        Adapters.register(adapter);
    }

    public void unbindExtensionAdapter(ExtensionAdapter adapter) {
        Adapters.unregister(adapter);
    }
}

