/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client;

import io.fabric8.kubernetes.client.Client;
import io.fabric8.kubernetes.client.ExtensionAdapter;
import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;

public final class Adapters {
    private static final Map<Class, ExtensionAdapter> EXTENSION_ADAPTER_MAP = new HashMap<Class, ExtensionAdapter>();

    private Adapters() {
    }

    public static <C extends Client> void register(ExtensionAdapter<C> adapter) {
        EXTENSION_ADAPTER_MAP.put(adapter.getExtensionType(), adapter);
    }

    public static <C extends Client> void unregister(ExtensionAdapter<C> adapter) {
        EXTENSION_ADAPTER_MAP.remove(adapter.getExtensionType());
    }

    public static <C extends Client> ExtensionAdapter<C> get(Class<C> type) {
        return EXTENSION_ADAPTER_MAP.get(type);
    }

    static {
        for (ExtensionAdapter adapter : ServiceLoader.load(ExtensionAdapter.class)) {
            Adapters.register(adapter);
        }
    }
}

