/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.dsl.internal;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.ListenableFuture;
import com.ning.http.client.Request;
import com.ning.http.client.Response;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.Status;
import io.fabric8.kubernetes.api.model.StatusBuilder;
import io.fabric8.kubernetes.client.Client;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.internal.URLUtils;
import io.fabric8.kubernetes.client.internal.Utils;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.concurrent.ExecutionException;

public class OperationSupport<C extends Client> {
    public static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    final C client;
    final String resourceT;
    final String namespace;
    final String name;

    public OperationSupport(C client, String resourceT, String namespace, String name) {
        this.client = client;
        this.resourceT = resourceT;
        this.namespace = namespace;
        this.name = name;
    }

    public C getClient() {
        return this.client;
    }

    public String getResourceT() {
        return this.resourceT;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getName() {
        return this.name;
    }

    public boolean isNamespaceRequired() {
        return false;
    }

    public URL getRootUrl() {
        try {
            return new URL(URLUtils.join(this.client.getMasterUrl().toString(), "api", this.client.getApiVersion()));
        }
        catch (MalformedURLException e) {
            throw KubernetesClientException.launderThrowable(e);
        }
    }

    protected URL getNamespacedUrl(String namespace) throws MalformedURLException {
        URL requestUrl = this.getRootUrl();
        if (namespace != null) {
            requestUrl = new URL(URLUtils.join(requestUrl.toString(), "namespaces", namespace));
        }
        requestUrl = new URL(URLUtils.join(requestUrl.toString(), this.resourceT));
        return requestUrl;
    }

    protected URL getNamespacedUrl() throws MalformedURLException {
        return this.getNamespacedUrl(this.getNamespace());
    }

    protected URL getResourceUrl(String namespace, String name) throws MalformedURLException {
        if (name == null) {
            return this.getNamespacedUrl(namespace);
        }
        return new URL(URLUtils.join(this.getNamespacedUrl(namespace).toString(), name));
    }

    protected URL getResourceUrl() throws MalformedURLException {
        if (this.name == null) {
            return this.getNamespacedUrl();
        }
        return new URL(URLUtils.join(this.getNamespacedUrl().toString(), this.name));
    }

    protected <T> String checkNamespace(T item) {
        String itemNs;
        String operationNs = this.getNamespace();
        String string = itemNs = item instanceof HasMetadata ? ((HasMetadata)item).getMetadata().getNamespace() : null;
        if (Utils.isNullOrEmpty(operationNs) && Utils.isNullOrEmpty(itemNs)) {
            if (!this.isNamespaceRequired()) {
                return null;
            }
            throw new KubernetesClientException("Namespace not specified. But operation requires namespace.");
        }
        if (Utils.isNullOrEmpty(itemNs)) {
            return operationNs;
        }
        if (Utils.isNullOrEmpty(operationNs)) {
            return itemNs;
        }
        if (itemNs.equals(operationNs)) {
            return itemNs;
        }
        throw new KubernetesClientException("Namespace mismatch. Item namespace:" + itemNs + ". Operation namespace:" + operationNs + ".");
    }

    protected <T> String checkName(T item) {
        String itemName;
        String operationName = this.getName();
        String string = itemName = item instanceof HasMetadata ? ((HasMetadata)item).getMetadata().getName() : null;
        if (Utils.isNullOrEmpty(operationName) && Utils.isNullOrEmpty(itemName)) {
            return null;
        }
        if (Utils.isNullOrEmpty(itemName)) {
            return operationName;
        }
        if (Utils.isNullOrEmpty(operationName)) {
            return itemName;
        }
        if (itemName.equals(operationName)) {
            return itemName;
        }
        throw new KubernetesClientException("Name mismatch. Item name:" + itemName + ". Operation name:" + operationName + ".");
    }

    protected <T> void handleDelete(T resource) throws ExecutionException, InterruptedException, KubernetesClientException, IOException {
        this.handleDelete(this.getResourceUrl(this.checkNamespace(resource), this.checkName(resource)));
    }

    protected void handleDelete(URL requestUrl) throws ExecutionException, InterruptedException, KubernetesClientException, IOException {
        AsyncHttpClient.BoundRequestBuilder requestBuilder = this.getClient().getHttpClient().prepareDelete(requestUrl.toString());
        this.handleResponse(requestBuilder, 200, null);
    }

    protected <T, I> T handleCreate(I resource, Class<T> outputType) throws ExecutionException, InterruptedException, KubernetesClientException, IOException {
        AsyncHttpClient.BoundRequestBuilder requestBuilder = this.getClient().getHttpClient().preparePost(this.getNamespacedUrl(this.checkNamespace(resource)).toString());
        requestBuilder.setBody(OBJECT_MAPPER.writer().writeValueAsString(resource));
        return this.handleResponse(requestBuilder, 201, outputType);
    }

    protected <T> T handleReplace(T updated, Class<T> type) throws ExecutionException, InterruptedException, KubernetesClientException, IOException {
        AsyncHttpClient.BoundRequestBuilder requestBuilder = this.getClient().getHttpClient().preparePut(this.getResourceUrl(this.checkNamespace(updated), this.checkName(updated)).toString());
        requestBuilder.setBody(OBJECT_MAPPER.writer().writeValueAsString(updated));
        return this.handleResponse(requestBuilder, 200, type);
    }

    protected <T> T handleGet(URL resourceUrl, Class<T> type) throws ExecutionException, InterruptedException, KubernetesClientException, IOException {
        AsyncHttpClient.BoundRequestBuilder requestBuilder = this.getClient().getHttpClient().prepareGet(resourceUrl.toString());
        return this.handleResponse(requestBuilder, 200, type);
    }

    protected <T> T handleResponse(AsyncHttpClient.BoundRequestBuilder requestBuilder, int successStatusCode, Class<T> type) throws ExecutionException, InterruptedException, KubernetesClientException, IOException {
        Request request = requestBuilder.build();
        Response response = null;
        try {
            ListenableFuture f = this.client.getHttpClient().executeRequest(request);
            response = (Response)f.get();
        }
        catch (Exception e) {
            throw this.requestException(request, e);
        }
        this.assertResponseCode(request, response, successStatusCode);
        if (type != null) {
            return (T)OBJECT_MAPPER.readValue(response.getResponseBodyAsStream(), type);
        }
        return null;
    }

    void assertResponseCode(Request request, Response response, int expectedStatusCode) {
        int statusCode = response.getStatusCode();
        String customMessage = ((Config)this.client.getConfiguration()).getErrorMessages().get(statusCode);
        if (statusCode == expectedStatusCode) {
            return;
        }
        if (customMessage != null) {
            throw this.requestFailure(request, this.createStatus(statusCode, customMessage));
        }
        try {
            Status status = (Status)OBJECT_MAPPER.readValue(response.getResponseBodyAsStream(), Status.class);
            throw this.requestFailure(request, status);
        }
        catch (IOException e) {
            throw this.requestFailure(request, this.createStatus(statusCode, ""));
        }
    }

    Status createStatus(int statusCode, String message) {
        return ((StatusBuilder)((StatusBuilder)new StatusBuilder().withCode(Integer.valueOf(statusCode))).withMessage(message)).build();
    }

    KubernetesClientException requestFailure(Request request, Status status) {
        StringBuilder sb = new StringBuilder();
        sb.append("Failure executing: ").append(request.getMethod()).append(" at: ").append(request.getUri()).append(". Received status: ").append(status).append(".");
        if (status.getMessage() != null && !status.getMessage().isEmpty()) {
            sb.append(" Message: ").append(status.getMessage()).append(".");
        }
        if (status.getReason() != null && !status.getReason().isEmpty()) {
            sb.append(" Reason: ").append(status.getReason()).append(".");
        }
        return new KubernetesClientException(sb.toString(), status.getCode(), status);
    }

    KubernetesClientException requestException(Request request, Exception e) {
        StringBuilder sb = new StringBuilder();
        sb.append("Error executing: ").append(request.getMethod()).append(" at: ").append(request.getUri()).append(". Cause: ").append(e.getMessage());
        return new KubernetesClientException(sb.toString(), e);
    }
}

