/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.dsl.internal;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.ListenableFuture;
import com.ning.http.client.Response;
import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesResourceList;
import io.fabric8.kubernetes.api.model.Status;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.ClientNonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.ClientResource;
import io.fabric8.kubernetes.client.dsl.EditReplaceDeletable;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.internal.ClientMixedOperation;
import io.fabric8.kubernetes.client.dsl.internal.Reaper;
import io.fabric8.kubernetes.client.dsl.internal.ReaperFactory;
import io.fabric8.kubernetes.client.dsl.internal.WatchConnectionManager;
import io.fabric8.kubernetes.client.internal.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ExecutionException;

public class BaseOperation<K extends KubernetesClient, T, L extends KubernetesResourceList, D extends Doneable<T>, R extends ClientResource<T, D>>
implements ClientMixedOperation<K, T, L, D, R> {
    protected static final ObjectMapper mapper = new ObjectMapper();
    private final K client;
    private final String name;
    private final String namespace;
    private final String resourceT;
    private final Boolean cascading;
    private final T item;
    private final Map<String, String> labels = new TreeMap<String, String>();
    private final Map<String, String> labelsNot = new TreeMap<String, String>();
    private final Map<String, String[]> labelsIn = new TreeMap<String, String[]>();
    private final Map<String, String[]> labelsNotIn = new TreeMap<String, String[]>();
    private final Map<String, String> fields = new TreeMap<String, String>();
    private final Class<K> clientType;
    private final Class<T> type;
    private final Class<L> listType;
    private final Class<D> doneableType;
    private boolean reaping;

    protected BaseOperation(K client, String resourceT, String namespace, String name, Boolean cascading, T item) {
        this.client = client;
        this.resourceT = resourceT;
        this.namespace = namespace;
        this.name = name;
        this.cascading = cascading;
        this.item = item;
        this.clientType = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
        this.type = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[1];
        this.listType = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[2];
        this.doneableType = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[3];
    }

    protected BaseOperation(K client, String resourceT, String namespace, String name, Boolean cascading, T item, Class<K> clientType, Class<T> type, Class<L> listType, Class<D> doneableType) {
        this.client = client;
        this.resourceT = resourceT;
        this.namespace = namespace;
        this.name = name;
        this.cascading = cascading;
        this.item = item;
        this.clientType = clientType;
        this.type = type;
        this.listType = listType;
        this.doneableType = doneableType;
    }

    @Override
    public T get() {
        if (this.item != null) {
            return this.item;
        }
        try {
            URL requestUrl = this.getNamespacedUrl();
            if (this.name != null) {
                requestUrl = new URL(requestUrl, this.name);
            }
            return this.handleGet(requestUrl);
        }
        catch (KubernetesClientException e) {
            if (e.getCode() != 404) {
                throw e;
            }
            return null;
        }
        catch (IOException | InterruptedException | ExecutionException e) {
            throw KubernetesClientException.launderThrowable(e);
        }
    }

    @Override
    public D edit() throws KubernetesClientException {
        throw new KubernetesClientException("Cannot edit read-only resources");
    }

    @Override
    public R withName(String name) {
        try {
            return (R)((ClientResource)this.getClass().getConstructor(this.clientType, String.class, String.class, Boolean.class, this.type).newInstance(this.client, this.namespace, name, this.cascading, this.item));
        }
        catch (Throwable t) {
            throw KubernetesClientException.launderThrowable(t);
        }
    }

    @Override
    public ClientNonNamespaceOperation<K, T, L, D, R> inNamespace(String namespace) {
        try {
            return (ClientNonNamespaceOperation)this.getClass().getConstructor(this.clientType, String.class, String.class, Boolean.class, this.type).newInstance(this.client, namespace, this.name, this.cascading, this.item);
        }
        catch (Throwable t) {
            throw KubernetesClientException.launderThrowable(t);
        }
    }

    @Override
    public EditReplaceDeletable<T, T, D, Boolean> cascading(boolean enabled) {
        try {
            return (EditReplaceDeletable)this.getClass().getConstructor(this.clientType, String.class, String.class, Boolean.class, this.type).newInstance(this.client, this.namespace, this.name, enabled, this.item);
        }
        catch (Throwable t) {
            throw KubernetesClientException.launderThrowable(t);
        }
    }

    @Override
    public R load(InputStream is) {
        try {
            return (R)((ClientResource)this.getClass().getConstructor(this.clientType, String.class, String.class, Boolean.class, this.type).newInstance(this.client, this.namespace, this.name, this.cascading, this.client.unmarshal(is, this.type)));
        }
        catch (Throwable t) {
            throw KubernetesClientException.launderThrowable(t);
        }
    }

    @Override
    public T create(T ... resources) throws KubernetesClientException {
        try {
            if (resources.length > 1) {
                throw new IllegalArgumentException("Too many items to create.");
            }
            if (resources.length == 1) {
                return this.handleCreate(resources[0]);
            }
            if (this.getItem() == null) {
                throw new IllegalArgumentException("Nothing to create.");
            }
            return this.handleCreate(this.getItem());
        }
        catch (IOException | InterruptedException | ExecutionException e) {
            throw KubernetesClientException.launderThrowable(e);
        }
    }

    @Override
    public D createNew() throws KubernetesClientException {
        Visitor visitor = new Visitor<T>(){

            public void visit(T resource) {
                try {
                    BaseOperation.this.create((T[])new Object[]{resource});
                }
                catch (Exception e) {
                    throw KubernetesClientException.launderThrowable(e);
                }
            }
        };
        try {
            return (D)((Doneable)this.getDoneableType().getDeclaredConstructor(Visitor.class).newInstance(visitor));
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw KubernetesClientException.launderThrowable(e);
        }
    }

    @Override
    public FilterWatchListDeletable<T, L, Boolean> withLabels(Map<String, String> labels) {
        labels.putAll(labels);
        return this;
    }

    @Override
    public FilterWatchListDeletable<T, L, Boolean> withoutLabels(Map<String, String> labels) throws KubernetesClientException {
        this.labelsNot.putAll(labels);
        return this;
    }

    @Override
    public FilterWatchListDeletable<T, L, Boolean> withLabelIn(String key, String ... values) throws KubernetesClientException {
        this.labelsIn.put(key, values);
        return this;
    }

    @Override
    public FilterWatchListDeletable<T, L, Boolean> withLabelNotIn(String key, String ... values) throws KubernetesClientException {
        this.labelsNotIn.put(key, values);
        return this;
    }

    @Override
    public FilterWatchListDeletable<T, L, Boolean> withLabel(String key, String value) {
        this.labels.put(key, value);
        return this;
    }

    @Override
    public FilterWatchListDeletable<T, L, Boolean> withoutLabel(String key, String value) throws KubernetesClientException {
        this.labelsNot.put(key, value);
        return this;
    }

    @Override
    public FilterWatchListDeletable<T, L, Boolean> withFields(Map<String, String> labels) {
        this.fields.putAll(labels);
        return this;
    }

    @Override
    public FilterWatchListDeletable<T, L, Boolean> withField(String key, String value) {
        this.fields.put(key, value);
        return this;
    }

    String getLabelQueryParam() {
        Iterator<Map.Entry<String, String>> iter;
        Map.Entry<String, String> entry2;
        StringBuilder sb = new StringBuilder();
        if (this.labels != null && !this.labels.isEmpty()) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            for (Map.Entry<String, String> entry2 : this.labels.entrySet()) {
                sb.append(entry2.getKey()).append("=").append(entry2.getValue());
            }
        }
        if (this.labelsNot != null && !this.labelsNot.isEmpty()) {
            iter = this.labelsNot.entrySet().iterator();
            while (iter.hasNext()) {
                if (sb.length() > 0) {
                    sb.append(",");
                }
                entry2 = iter.next();
                sb.append(entry2.getKey()).append("!=").append(entry2.getValue());
            }
        }
        if (this.labelsIn != null && !this.labelsIn.isEmpty()) {
            iter = this.labelsIn.entrySet().iterator();
            while (iter.hasNext()) {
                if (sb.length() > 0) {
                    sb.append(",");
                }
                entry2 = iter.next();
                sb.append(entry2.getKey()).append(" in ").append("(").append(Utils.join((Object[])entry2.getValue())).append(")");
            }
        }
        if (this.labelsNotIn != null && !this.labelsNotIn.isEmpty()) {
            iter = this.labelsNotIn.entrySet().iterator();
            while (iter.hasNext()) {
                if (sb.length() > 0) {
                    sb.append(",");
                }
                entry2 = iter.next();
                sb.append(entry2.getKey()).append(" notin ").append("(").append(Utils.join((Object[])entry2.getValue())).append(")");
            }
        }
        return sb.toString();
    }

    String getFieldQueryParam() {
        StringBuilder sb = new StringBuilder();
        if (this.fields != null && !this.fields.isEmpty()) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            for (Map.Entry<String, String> entry : this.fields.entrySet()) {
                sb.append(entry.getKey()).append("=").append(entry.getValue());
            }
        }
        return sb.toString();
    }

    @Override
    public L list() throws KubernetesClientException {
        try {
            String fieldQueryString;
            URL requestUrl = this.getNamespacedUrl();
            AsyncHttpClient.BoundRequestBuilder requestBuilder = this.getClient().getHttpClient().prepareGet(requestUrl.toString());
            String labelQueryParam = this.getLabelQueryParam();
            if (labelQueryParam.length() > 0) {
                requestBuilder.addQueryParam("labelSelector", labelQueryParam);
            }
            if ((fieldQueryString = this.getFieldQueryParam()).length() > 0) {
                requestBuilder.addQueryParam("fieldSelector", fieldQueryString);
            }
            ListenableFuture f = requestBuilder.execute();
            Response r = (Response)f.get();
            this.assertResponseCode(r, 200);
            return (L)((KubernetesResourceList)mapper.readerFor(this.listType).readValue(r.getResponseBodyAsStream()));
        }
        catch (IOException | InterruptedException | ExecutionException e) {
            throw KubernetesClientException.launderThrowable(e);
        }
    }

    @Override
    public Boolean delete() {
        if (this.name != null && !this.name.isEmpty()) {
            try {
                Reaper reaper;
                if (this.cascading.booleanValue() && !this.isReaping() && (reaper = ReaperFactory.getReaper(this)) != null) {
                    this.setReaping(true);
                    reaper.reap();
                }
                this.deleteThis();
                return true;
            }
            catch (KubernetesClientException e) {
                if (e.getCode() != 404) {
                    throw e;
                }
                return false;
            }
        }
        try {
            this.deleteList();
            return true;
        }
        catch (KubernetesClientException e) {
            if (e.getCode() != 404) {
                throw e;
            }
            return false;
        }
    }

    void deleteThis() throws KubernetesClientException {
        try {
            this.handleDelete(this.getResourceUrl());
        }
        catch (Exception e) {
            throw KubernetesClientException.launderThrowable(e);
        }
    }

    void deleteList() throws KubernetesClientException {
        try {
            L discoveredResources = this.list();
            for (Object resource : discoveredResources.getItems()) {
                HasMetadata metadataResource = (HasMetadata)resource;
                URL requestUrl = this.getRootUrl();
                if (metadataResource.getMetadata().getNamespace() != null) {
                    requestUrl = new URL(requestUrl, "namespaces/" + metadataResource.getMetadata().getNamespace() + "/");
                }
                requestUrl = new URL(requestUrl, this.getResourceT() + "/" + metadataResource.getMetadata().getName());
                AsyncHttpClient.BoundRequestBuilder requestBuilder = this.getClient().getHttpClient().prepareDelete(requestUrl.toString());
                ListenableFuture f = requestBuilder.execute();
                Response r = (Response)f.get();
                this.assertResponseCode(r, 200);
            }
        }
        catch (IOException | InterruptedException | ExecutionException e) {
            throw KubernetesClientException.launderThrowable(e);
        }
    }

    @Override
    public Watch watch(Watcher<T> watcher) throws KubernetesClientException {
        return this.watch(null, watcher);
    }

    @Override
    public Watch watch(String resourceVersion, Watcher<T> watcher) throws KubernetesClientException {
        try {
            return new WatchConnectionManager(this, resourceVersion, watcher, ((Config)this.client.getConfiguration()).getWatchReconnectInterval(), ((Config)this.client.getConfiguration()).getWatchReconnectLimit());
        }
        catch (InterruptedException | MalformedURLException | ExecutionException e) {
            throw KubernetesClientException.launderThrowable(e);
        }
    }

    @Override
    public T update(T item) {
        return this.replace(item);
    }

    @Override
    public T replace(T item) {
        throw new KubernetesClientException("Cannot update read-only resources");
    }

    protected URL getNamespacedUrl() throws MalformedURLException {
        URL requestUrl = this.getRootUrl();
        if (this.getNamespace() != null) {
            requestUrl = new URL(requestUrl, "namespaces/" + this.getNamespace() + "/");
        }
        requestUrl = new URL(requestUrl, this.resourceT + "/");
        return requestUrl;
    }

    protected URL getResourceUrl() throws MalformedURLException {
        if (this.name == null) {
            return this.getNamespacedUrl();
        }
        return new URL(this.getNamespacedUrl(), this.name + "/");
    }

    protected void assertResponseCode(Response r, int expectedStatusCode) {
        int statusCode = r.getStatusCode();
        String customMessage = ((Config)this.client.getConfiguration()).getErrorMessages().get(statusCode);
        if (statusCode == expectedStatusCode) {
            return;
        }
        if (customMessage != null) {
            throw new KubernetesClientException("Error accessing: " + r.getUri().toString() + ",due to:" + customMessage);
        }
        try {
            Status status = (Status)mapper.readerFor(Status.class).readValue(r.getResponseBodyAsStream());
            throw new KubernetesClientException(status.getMessage(), status.getCode(), status);
        }
        catch (IOException e) {
            throw KubernetesClientException.launderThrowable(e);
        }
    }

    protected T handleResponse(AsyncHttpClient.BoundRequestBuilder requestBuilder, int successStatusCode) throws ExecutionException, InterruptedException, KubernetesClientException, IOException {
        ListenableFuture f = requestBuilder.execute();
        Response r = (Response)f.get();
        this.assertResponseCode(r, successStatusCode);
        return (T)mapper.readerFor(this.getType()).readValue(r.getResponseBodyAsStream());
    }

    protected void handleDelete(URL requestUrl) throws ExecutionException, InterruptedException, KubernetesClientException, IOException {
        AsyncHttpClient.BoundRequestBuilder requestBuilder = this.getClient().getHttpClient().prepareDelete(requestUrl.toString());
        ListenableFuture f = requestBuilder.execute();
        Response r = (Response)f.get();
        this.assertResponseCode(r, 200);
    }

    protected T handleCreate(T resource) throws ExecutionException, InterruptedException, KubernetesClientException, IOException {
        AsyncHttpClient.BoundRequestBuilder requestBuilder = this.getClient().getHttpClient().preparePost(this.getNamespacedUrl().toString());
        requestBuilder.setBody(mapper.writer().writeValueAsString(resource));
        return this.handleResponse(requestBuilder, 201);
    }

    protected T handleReplace(URL resourceUrl, T updated) throws ExecutionException, InterruptedException, KubernetesClientException, IOException {
        AsyncHttpClient.BoundRequestBuilder requestBuilder = this.getClient().getHttpClient().preparePut(resourceUrl.toString());
        requestBuilder.setBody(mapper.writer().writeValueAsString(updated));
        return this.handleResponse(requestBuilder, 200);
    }

    protected T handleGet(URL resourceUrl) throws ExecutionException, InterruptedException, KubernetesClientException, IOException {
        AsyncHttpClient.BoundRequestBuilder requestBuilder = this.getClient().getHttpClient().prepareGet(resourceUrl.toString());
        return this.handleResponse(requestBuilder, 200);
    }

    public URL getRootUrl() {
        return this.client.getMasterUrl();
    }

    public String getName() {
        return this.name;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public Boolean isCascading() {
        return this.cascading;
    }

    public T getItem() {
        return this.item;
    }

    public String getResourceT() {
        return this.resourceT;
    }

    public Class<T> getType() {
        return this.type;
    }

    public Class<L> getListType() {
        return this.listType;
    }

    public Class<D> getDoneableType() {
        return this.doneableType;
    }

    @Override
    public K getClient() {
        return this.client;
    }

    protected boolean isReaping() {
        return this.reaping;
    }

    protected void setReaping(boolean reaping) {
        this.reaping = reaping;
    }
}

