/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.internal;

import com.ning.http.client.AsyncHttpClient;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesResourceList;
import io.fabric8.kubernetes.client.FilteredResourceList;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.ResourceList;
import io.fabric8.kubernetes.client.internal.BaseResourceList;
import java.net.URL;
import java.util.Map;

public class DefaultResourceList<T extends HasMetadata, L extends KubernetesResourceList, B extends Builder<T>, D extends Doneable<T>>
extends BaseResourceList<T, L, B, D>
implements ResourceList<T, L, B>,
FilteredResourceList<T, L> {
    public DefaultResourceList(AsyncHttpClient httpClient, URL rootUrl, String resourceT, Class<T> clazz, Class<L> listClazz, Class<B> builderClazz, Class<D> updateableClazz) {
        super(httpClient, rootUrl, resourceT, clazz, listClazz, builderClazz, updateableClazz);
    }

    @Override
    public FilteredResourceList<T, L> withLabels(Map<String, String> labels) {
        this.getLabels().putAll(labels);
        return this;
    }

    @Override
    public FilteredResourceList<T, L> withoutLabels(Map<String, String> labels) throws KubernetesClientException {
        this.getLabelsNot().putAll(labels);
        return this;
    }

    @Override
    public FilteredResourceList<T, L> withLabelIn(String key, String ... values) throws KubernetesClientException {
        this.getLabelsIn().put(key, values);
        return this;
    }

    @Override
    public FilteredResourceList<T, L> withLabelNotIn(String key, String ... values) throws KubernetesClientException {
        this.getLabelsNotIn().put(key, values);
        return this;
    }

    @Override
    public FilteredResourceList<T, L> withLabel(String key, String value) {
        this.getLabels().put(key, value);
        return this;
    }

    @Override
    public FilteredResourceList<T, L> withoutLabel(String key, String value) throws KubernetesClientException {
        this.getLabelsNot().put(key, value);
        return this;
    }

    @Override
    public FilteredResourceList<T, L> withFields(Map<String, String> labels) {
        this.getFields().putAll(labels);
        return this;
    }

    @Override
    public FilteredResourceList<T, L> withField(String key, String value) {
        this.getFields().put(key, value);
        return this;
    }
}

