/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.http;

import io.fabric8.kubernetes.client.RequestConfigBuilder;
import io.fabric8.kubernetes.client.http.HttpClient;
import io.fabric8.kubernetes.client.internal.SSLUtils;
import io.fabric8.kubernetes.client.utils.HttpClientUtils;
import io.fabric8.mockwebserver.Context;
import io.fabric8.mockwebserver.DefaultMockServer;
import io.fabric8.mockwebserver.MockWebServer;
import io.fabric8.mockwebserver.ServerRequest;
import io.fabric8.mockwebserver.ServerResponse;
import io.fabric8.mockwebserver.dsl.HttpMethod;
import io.fabric8.mockwebserver.http.Dispatcher;
import io.fabric8.mockwebserver.http.Headers;
import io.fabric8.mockwebserver.http.RecordedRequest;
import io.fabric8.mockwebserver.internal.MockDispatcher;
import io.fabric8.mockwebserver.internal.SimpleRequest;
import io.fabric8.mockwebserver.internal.SimpleResponse;
import io.fabric8.mockwebserver.utils.ResponseProvider;
import java.net.InetSocketAddress;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;

public abstract class AbstractHttpClientProxyHttpsTest {
    private static Map<ServerRequest, Queue<ServerResponse>> responses;
    private static DefaultMockServer proxyServer;

    @BeforeAll
    static void beforeAll() {
        responses = new HashMap<ServerRequest, Queue<ServerResponse>>();
        proxyServer = new DefaultMockServer(new Context(), new MockWebServer(), responses, (Dispatcher)new MockDispatcher(responses), false);
        proxyServer.start();
    }

    @AfterAll
    static void afterAll() {
        proxyServer.shutdown();
    }

    protected abstract HttpClient.Factory getHttpClientFactory();

    @Test
    @DisplayName(value="Proxied HttpClient with basic authorization adds required headers to the request")
    protected void proxyConfigurationAddsRequiredHeadersForHttps() throws Exception {
        final AtomicReference initialConnectRequest = new AtomicReference();
        ResponseProvider<String> bodyProvider = new ResponseProvider<String>(){

            public String getBody(RecordedRequest request) {
                return "\n";
            }

            public void setHeaders(Headers headers) {
            }

            public int getStatusCode(RecordedRequest request) {
                if (request.getHeader("Proxy-Authorization") != null) {
                    initialConnectRequest.compareAndSet(null, request);
                    return 200;
                }
                return 407;
            }

            public Headers getHeaders() {
                return new Headers.Builder().add("Proxy-Authenticate", "Basic").build();
            }
        };
        responses.computeIfAbsent((ServerRequest)new SimpleRequest(HttpMethod.CONNECT, "example.com:443"), k -> new ArrayDeque()).add(new SimpleResponse(true, (ResponseProvider)bodyProvider, null, 0L, TimeUnit.SECONDS));
        HttpClient.Builder builder = this.getHttpClientFactory().newBuilder().sslContext(null, SSLUtils.trustManagers(null, null, (boolean)true, null, null)).proxyAddress(new InetSocketAddress("localhost", proxyServer.getPort())).proxyAuthorization(HttpClientUtils.basicCredentials((String)"auth", (String)"cred"));
        builder.tag((Object)((RequestConfigBuilder)new RequestConfigBuilder().withRequestRetryBackoffInterval(Integer.valueOf(1))).build());
        try (HttpClient client = builder.build();){
            ((CompletableFuture)client.sendAsync(client.newHttpRequestBuilder().uri("https://example.com/proxied").build(), String.class).exceptionally(t -> null)).get(30L, TimeUnit.SECONDS);
            Assertions.assertThat(initialConnectRequest).doesNotHaveNullValue().hasValueMatching(r -> r.getHeader("Proxy-Authorization").equals("Basic YXV0aDpjcmVk"));
        }
    }
}

