/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client;

import io.fabric8.kubernetes.api.model.Config;
import io.fabric8.kubernetes.api.model.NamedCluster;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.ConfigTest;
import io.fabric8.kubernetes.client.utils.Serialization;
import io.fabric8.kubernetes.client.utils.Utils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.assertj.core.api.AssertionsForInterfaceTypes;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

class ConfigProxySourceTest {
    @TempDir
    private File temporaryFolder;

    ConfigProxySourceTest() {
    }

    private File createKubeConfigWithCluster(String masterUrl, String proxyUrl) throws IOException {
        Config kubeConfig = (Config)Serialization.unmarshal((InputStream)ConfigTest.class.getResourceAsStream("/config-proxy-source/kubeconfig-with-proxy-url"), Config.class);
        ((NamedCluster)kubeConfig.getClusters().get(0)).getCluster().setServer(masterUrl);
        ((NamedCluster)kubeConfig.getClusters().get(0)).getCluster().setProxyUrl(proxyUrl);
        File updatedKubeConfig = new File(this.temporaryFolder, "kubeconfig");
        Files.write(updatedKubeConfig.toPath(), Serialization.asYaml((Object)kubeConfig).getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        return updatedKubeConfig;
    }

    @Nested
    @DisplayName(value="HTTPS Proxy")
    class HttpsProxyConfig {
        HttpsProxyConfig() {
        }

        @Nested
        @DisplayName(value="kubeconfig contains proxy-url in cluster configuration")
        class KubeConfigWithProxyUrl {
            KubeConfigWithProxyUrl() {
            }

            @BeforeEach
            void setup() {
                System.setProperty("kubeconfig", Utils.filePath((URL)ConfigTest.class.getResource("/config-proxy-source/kubeconfig-with-proxy-url")));
            }

            @AfterEach
            void tearDown() {
                System.clearProperty("kubeconfig");
            }

            @Test
            @DisplayName(value="proxy-url with socks5 scheme, masterUrl with https scheme, then Config sets httpsProxy")
            void whenProxyUrlSocks5_thenHttpsProxySetInConfig() {
                System.setProperty("kubeconfig", Utils.filePath((URL)ConfigTest.class.getResource("/config-proxy-source/kubeconfig-with-proxy-url")));
                AssertionsForInterfaceTypes.assertThat((Object)new ConfigBuilder().build()).hasFieldOrPropertyWithValue("httpsProxy", (Object)"socks5://proxy-via-kubeconfig-proxy-url:1080");
            }

            @Test
            @DisplayName(value="proxy-url with https scheme, masterUrl with https scheme, then Config sets httpsProxy")
            void whenProxyUrlHttps_thenHttpsProxySetInConfig() throws IOException {
                System.setProperty("kubeconfig", ConfigProxySourceTest.this.createKubeConfigWithCluster("https://kubernetes-remote-server.example:6443", "https://proxy-server.example:80").getAbsolutePath());
                AssertionsForInterfaceTypes.assertThat((Object)new ConfigBuilder().build()).hasFieldOrPropertyWithValue("httpsProxy", (Object)"https://proxy-server.example:80");
            }

            @Test
            @DisplayName(value="https.proxy property configuration, kubeconfig proxy-url takes precedence")
            void httpsProxySystemProperty() {
                try {
                    System.setProperty("https.proxy", "https://proxy-via-http-proxy-property:3128");
                    AssertionsForInterfaceTypes.assertThat((Object)new ConfigBuilder().build()).hasFieldOrPropertyWithValue("httpsProxy", (Object)"socks5://proxy-via-kubeconfig-proxy-url:1080");
                }
                finally {
                    System.clearProperty("https.proxy");
                }
            }

            @Test
            @DisplayName(value="all.proxy property configuration, then kubeconfig proxy-url takes precedence")
            void allProxySystemProperty() {
                try {
                    System.setProperty("all.proxy", "https://proxy-via-all-proxy-property:3128");
                    AssertionsForInterfaceTypes.assertThat((Object)new ConfigBuilder().build()).hasFieldOrPropertyWithValue("httpsProxy", (Object)"socks5://proxy-via-kubeconfig-proxy-url:1080");
                }
                finally {
                    System.clearProperty("all.proxy");
                }
            }

            @Test
            @DisplayName(value="user configures proxy via builder, then user configuration via builder takes precedence")
            void httpsProxyViaBuilder() {
                AssertionsForInterfaceTypes.assertThat((Object)((ConfigBuilder)new ConfigBuilder().withHttpsProxy("https://proxy-via-builder:3128")).build()).hasFieldOrPropertyWithValue("httpsProxy", (Object)"https://proxy-via-builder:3128");
            }
        }

        @Nested
        @DisplayName(value="all.proxy System property")
        class AllProxySystemProperty {
            AllProxySystemProperty() {
            }

            @BeforeEach
            void setup() {
                System.setProperty("all.proxy", "http://proxy-via-all-proxy-property:3128");
            }

            @AfterEach
            void tearDown() {
                System.clearProperty("all.proxy");
            }

            @Test
            @DisplayName(value="no other proxy configuration, then all.proxy property takes precedence")
            void noOtherConfiguration() {
                AssertionsForInterfaceTypes.assertThat((Object)new ConfigBuilder().build()).hasFieldOrPropertyWithValue("httpsProxy", (Object)"http://proxy-via-all-proxy-property:3128");
            }

            @Test
            @DisplayName(value="https.proxy property configuration, then https.proxy property takes precedence")
            void allProxySystemProperty() {
                try {
                    System.setProperty("https.proxy", "http://proxy-via-http-proxy-property:3128");
                    AssertionsForInterfaceTypes.assertThat((Object)new ConfigBuilder().build()).hasFieldOrPropertyWithValue("httpsProxy", (Object)"http://proxy-via-http-proxy-property:3128");
                }
                finally {
                    System.clearProperty("https.proxy");
                }
            }

            @Test
            @DisplayName(value="user configures proxy via builder, then user configuration via builder takes precedence")
            void httpsProxyViaBuilder() {
                AssertionsForInterfaceTypes.assertThat((Object)((ConfigBuilder)new ConfigBuilder().withHttpsProxy("https://proxy-via-builder:3128")).build()).hasFieldOrPropertyWithValue("httpsProxy", (Object)"https://proxy-via-builder:3128");
            }

            @Test
            @DisplayName(value="kubeconfig cluster has proxy-url, then kubeconfig proxy-url takes precedence")
            void kubeConfigProxyUrl() throws IOException {
                try {
                    System.setProperty("kubeconfig", ConfigProxySourceTest.this.createKubeConfigWithCluster("https://kubernetes-remote-server.example:6443", "https://proxy-server.example:80").getAbsolutePath());
                    AssertionsForInterfaceTypes.assertThat((Object)new ConfigBuilder().build()).hasFieldOrPropertyWithValue("httpsProxy", (Object)"https://proxy-server.example:80");
                }
                finally {
                    System.clearProperty("kubeconfig");
                }
            }
        }

        @Nested
        @DisplayName(value="withHttpsProxy via builder")
        class ProxyViaBuilder {
            private ConfigBuilder configBuilder;

            ProxyViaBuilder() {
            }

            @BeforeEach
            void setUp() {
                this.configBuilder = (ConfigBuilder)new ConfigBuilder().withHttpsProxy("https://proxy-via-builder:3128");
            }

            @Test
            @DisplayName(value="no other proxy configuration, then user configuration via builder takes precedence")
            void noOtherConfiguration() {
                AssertionsForInterfaceTypes.assertThat((Object)this.configBuilder.build()).hasFieldOrPropertyWithValue("httpsProxy", (Object)"https://proxy-via-builder:3128");
            }

            @Test
            @DisplayName(value="https.proxy property configuration, then user configuration via builder takes precedence")
            void httpsProxySystemProperty() {
                try {
                    System.setProperty("https.proxy", "https://proxy-via-https-proxy-property:3128");
                    AssertionsForInterfaceTypes.assertThat((Object)this.configBuilder.build()).hasFieldOrPropertyWithValue("httpsProxy", (Object)"https://proxy-via-builder:3128");
                }
                finally {
                    System.clearProperty("https.proxy");
                }
            }

            @Test
            @DisplayName(value="all.proxy property configuration, then user configuration via builder takes precedence")
            void allProxySystemProperty() {
                try {
                    System.setProperty("all.proxy", "https://proxy-via-all-proxy-property:3128");
                    AssertionsForInterfaceTypes.assertThat((Object)this.configBuilder.build()).hasFieldOrPropertyWithValue("httpsProxy", (Object)"https://proxy-via-builder:3128");
                }
                finally {
                    System.clearProperty("all.proxy");
                }
            }

            @Test
            @DisplayName(value="kubeconfig cluster has proxy-url, then user configuration via builder takes precedence")
            void kubeConfigProxyUrl() {
                try {
                    System.setProperty("kubeconfig", Utils.filePath((URL)ConfigTest.class.getResource("/config-proxy-source/kubeconfig-with-proxy-url")));
                    AssertionsForInterfaceTypes.assertThat((Object)this.configBuilder.build()).hasFieldOrPropertyWithValue("httpsProxy", (Object)"https://proxy-via-builder:3128");
                }
                finally {
                    System.clearProperty("kubeconfig");
                }
            }
        }

        @Nested
        @DisplayName(value="https.proxy System property")
        class HttpsProxySystemProperty {
            HttpsProxySystemProperty() {
            }

            @BeforeEach
            void setup() {
                System.setProperty("https.proxy", "http://proxy-via-http-proxy-property:3128");
            }

            @AfterEach
            void tearDown() {
                System.clearProperty("https.proxy");
            }

            @Test
            @DisplayName(value="no other proxy configuration, then https.proxy property takes precedence")
            void noOtherConfiguration() {
                AssertionsForInterfaceTypes.assertThat((Object)new ConfigBuilder().build()).hasFieldOrPropertyWithValue("httpsProxy", (Object)"http://proxy-via-http-proxy-property:3128");
            }

            @Test
            @DisplayName(value="all.proxy property configuration, then https.proxy property takes precedence")
            void allProxySystemProperty() {
                try {
                    System.setProperty("all.proxy", "http://proxy-via-all-proxy-property:3128");
                    AssertionsForInterfaceTypes.assertThat((Object)new ConfigBuilder().build()).hasFieldOrPropertyWithValue("httpsProxy", (Object)"http://proxy-via-http-proxy-property:3128");
                }
                finally {
                    System.clearProperty("all.proxy");
                }
            }

            @Test
            @DisplayName(value="user configures proxy via builder, then user configuration via builder takes precedence")
            void httpsProxyViaBuilder() {
                AssertionsForInterfaceTypes.assertThat((Object)((ConfigBuilder)new ConfigBuilder().withHttpsProxy("https://proxy-via-builder:3128")).build()).hasFieldOrPropertyWithValue("httpsProxy", (Object)"https://proxy-via-builder:3128");
            }

            @Test
            @DisplayName(value="kubeconfig cluster has proxy-url, then kubeconfig proxy-url takes precedence")
            void kubeConfigProxyUrl() {
                try {
                    System.setProperty("kubeconfig", Utils.filePath((URL)ConfigTest.class.getResource("/config-proxy-source/kubeconfig-with-proxy-url")));
                    AssertionsForInterfaceTypes.assertThat((Object)new ConfigBuilder().build()).hasFieldOrPropertyWithValue("httpsProxy", (Object)"socks5://proxy-via-kubeconfig-proxy-url:1080");
                }
                finally {
                    System.clearProperty("kubeconfig");
                }
            }
        }
    }

    @Nested
    @DisplayName(value="HTTP Proxy")
    class HttpProxyConfig {
        HttpProxyConfig() {
        }

        @Nested
        @DisplayName(value="kubeconfig contains proxy-url in cluster configuration")
        class KubeConfigWithProxyUrl {
            KubeConfigWithProxyUrl() {
            }

            @BeforeEach
            void setup() throws IOException {
                System.setProperty("kubeconfig", ConfigProxySourceTest.this.createKubeConfigWithCluster("http://kubernetes-remote-server.example:6443", "socks5://proxy-server.example:80").getAbsolutePath());
            }

            @AfterEach
            void tearDown() {
                System.clearProperty("kubeconfig");
            }

            @Test
            @DisplayName(value="proxy-url with sock5 scheme, masterUrl with http scheme, then Config sets httpProxy")
            void whenProxyUrlSocks5MasterUrlHttp_thenHttpProxySetInConfig() {
                ((ObjectAssert)AssertionsForInterfaceTypes.assertThat((Object)new ConfigBuilder().build()).hasFieldOrPropertyWithValue("httpProxy", (Object)"socks5://proxy-server.example:80")).hasFieldOrPropertyWithValue("httpsProxy", null);
            }

            @Test
            @DisplayName(value="proxy-url with http scheme, masterUrl with http scheme, then Config sets httpProxy")
            void whenProxyUrlHttp_thenHttpProxySetInConfig() throws IOException {
                System.setProperty("kubeconfig", ConfigProxySourceTest.this.createKubeConfigWithCluster("http://kubernetes-remote-server.example:6443", "http://proxy-server.example:80").getAbsolutePath());
                ((ObjectAssert)AssertionsForInterfaceTypes.assertThat((Object)new ConfigBuilder().build()).hasFieldOrPropertyWithValue("httpProxy", (Object)"http://proxy-server.example:80")).hasFieldOrPropertyWithValue("httpsProxy", null);
            }

            @Test
            @DisplayName(value="http.proxy property configuration, kubeconfig proxy-url takes precedence")
            void httpProxySystemProperty() {
                try {
                    System.setProperty("http.proxy", "http://proxy-via-http-proxy-property:3128");
                    AssertionsForInterfaceTypes.assertThat((Object)new ConfigBuilder().build()).hasFieldOrPropertyWithValue("httpProxy", (Object)"socks5://proxy-server.example:80");
                }
                finally {
                    System.clearProperty("http.proxy");
                }
            }

            @Test
            @DisplayName(value="all.proxy property configuration, then kubeconfig proxy-url takes precedence")
            void allProxySystemProperty() {
                try {
                    System.setProperty("all.proxy", "http://proxy-via-all-proxy-property:3128");
                    AssertionsForInterfaceTypes.assertThat((Object)new ConfigBuilder().build()).hasFieldOrPropertyWithValue("httpProxy", (Object)"socks5://proxy-server.example:80");
                }
                finally {
                    System.clearProperty("all.proxy");
                }
            }

            @Test
            @DisplayName(value="user configures proxy via builder, then user configuration via builder takes precedence")
            void httpProxyViaBuilder() {
                AssertionsForInterfaceTypes.assertThat((Object)((ConfigBuilder)new ConfigBuilder().withHttpProxy("http://proxy-via-builder:3128")).build()).hasFieldOrPropertyWithValue("httpProxy", (Object)"http://proxy-via-builder:3128");
            }
        }

        @Nested
        @DisplayName(value="all.proxy System property")
        class AllProxySystemProperty {
            AllProxySystemProperty() {
            }

            @BeforeEach
            void setup() {
                System.setProperty("all.proxy", "http://proxy-via-all-proxy-property:3128");
            }

            @AfterEach
            void tearDown() {
                System.clearProperty("all.proxy");
            }

            @Test
            @DisplayName(value="no other proxy configuration, then all.proxy property takes precedence")
            void noOtherConfiguration() {
                AssertionsForInterfaceTypes.assertThat((Object)new ConfigBuilder().build()).hasFieldOrPropertyWithValue("httpProxy", (Object)"http://proxy-via-all-proxy-property:3128");
            }

            @Test
            @DisplayName(value="http.proxy property configuration, then http.proxy property takes precedence")
            void allProxySystemProperty() {
                try {
                    System.setProperty("http.proxy", "http://proxy-via-http-proxy-property:3128");
                    AssertionsForInterfaceTypes.assertThat((Object)new ConfigBuilder().build()).hasFieldOrPropertyWithValue("httpProxy", (Object)"http://proxy-via-http-proxy-property:3128");
                }
                finally {
                    System.clearProperty("http.proxy");
                }
            }

            @Test
            @DisplayName(value="user configures proxy via builder, then user configuration via builder takes precedence")
            void httpProxyViaBuilder() {
                AssertionsForInterfaceTypes.assertThat((Object)((ConfigBuilder)new ConfigBuilder().withHttpProxy("http://proxy-via-builder:3128")).build()).hasFieldOrPropertyWithValue("httpProxy", (Object)"http://proxy-via-builder:3128");
            }

            @Test
            @DisplayName(value="kubeconfig cluster has proxy-url, then kubeconfig proxy-url takes precedence")
            void kubeConfigProxyUrl() throws IOException {
                try {
                    System.setProperty("kubeconfig", ConfigProxySourceTest.this.createKubeConfigWithCluster("http://kubernetes-remote-server.example:6443", "http://proxy-server.example:80").getAbsolutePath());
                    AssertionsForInterfaceTypes.assertThat((Object)new ConfigBuilder().build()).hasFieldOrPropertyWithValue("httpProxy", (Object)"http://proxy-server.example:80");
                }
                finally {
                    System.clearProperty("kubeconfig");
                }
            }
        }

        @Nested
        @DisplayName(value="withHttpProxy via builder")
        class ProxyViaBuilder {
            private ConfigBuilder configBuilder;

            ProxyViaBuilder() {
            }

            @BeforeEach
            void setUp() {
                this.configBuilder = (ConfigBuilder)new ConfigBuilder().withHttpProxy("http://proxy-via-builder:3128");
            }

            @Test
            @DisplayName(value="no other proxy configuration, then user configuration via builder takes precedence")
            void noOtherConfiguration() {
                AssertionsForInterfaceTypes.assertThat((Object)this.configBuilder.build()).hasFieldOrPropertyWithValue("httpProxy", (Object)"http://proxy-via-builder:3128");
            }

            @Test
            @DisplayName(value="http.proxy property configuration, then user configuration via builder takes precedence")
            void httpProxySystemProperty() {
                try {
                    System.setProperty("http.proxy", "http://proxy-via-http-proxy-property:3128");
                    AssertionsForInterfaceTypes.assertThat((Object)this.configBuilder.build()).hasFieldOrPropertyWithValue("httpProxy", (Object)"http://proxy-via-builder:3128");
                }
                finally {
                    System.clearProperty("http.proxy");
                }
            }

            @Test
            @DisplayName(value="all.proxy property configuration, then user configuration via builder takes precedence")
            void allProxySystemProperty() {
                try {
                    System.setProperty("all.proxy", "http://proxy-via-all-proxy-property:3128");
                    AssertionsForInterfaceTypes.assertThat((Object)this.configBuilder.build()).hasFieldOrPropertyWithValue("httpProxy", (Object)"http://proxy-via-builder:3128");
                }
                finally {
                    System.clearProperty("all.proxy");
                }
            }

            @Test
            @DisplayName(value="kubeconfig cluster has proxy-url, then user configuration via builder takes precedence")
            void kubeConfigProxyUrl() throws IOException {
                try {
                    System.setProperty("kubeconfig", ConfigProxySourceTest.this.createKubeConfigWithCluster("http://kubernetes-remote-server.example:6443", "http://proxy-server.example:80").getAbsolutePath());
                    AssertionsForInterfaceTypes.assertThat((Object)this.configBuilder.build()).hasFieldOrPropertyWithValue("httpProxy", (Object)"http://proxy-via-builder:3128");
                }
                finally {
                    System.clearProperty("kubeconfig");
                }
            }
        }

        @Nested
        @DisplayName(value="http.proxy System property")
        class HttpProxySystemProperty {
            HttpProxySystemProperty() {
            }

            @BeforeEach
            void setup() {
                System.setProperty("http.proxy", "http://proxy-via-http-proxy-property:3128");
            }

            @AfterEach
            void tearDown() {
                System.clearProperty("http.proxy");
            }

            @Test
            @DisplayName(value="no other proxy configuration, then http.proxy property takes precedence")
            void noOtherConfiguration() {
                AssertionsForInterfaceTypes.assertThat((Object)new ConfigBuilder().build()).hasFieldOrPropertyWithValue("httpProxy", (Object)"http://proxy-via-http-proxy-property:3128");
            }

            @Test
            @DisplayName(value="all.proxy property configuration, then http.proxy property takes precedence")
            void allProxySystemProperty() {
                try {
                    System.setProperty("all.proxy", "http://proxy-via-all-proxy-property:3128");
                    AssertionsForInterfaceTypes.assertThat((Object)new ConfigBuilder().build()).hasFieldOrPropertyWithValue("httpProxy", (Object)"http://proxy-via-http-proxy-property:3128");
                }
                finally {
                    System.clearProperty("all.proxy");
                }
            }

            @Test
            @DisplayName(value="user configures proxy via builder, then user configuration via builder takes precedence")
            void httpProxyViaBuilder() {
                AssertionsForInterfaceTypes.assertThat((Object)((ConfigBuilder)new ConfigBuilder().withHttpProxy("http://proxy-via-builder:3128")).build()).hasFieldOrPropertyWithValue("httpProxy", (Object)"http://proxy-via-builder:3128");
            }

            @Test
            @DisplayName(value="kubeconfig cluster has http proxy-url, then kubeconfig proxy-url takes precedence")
            void kubeConfigProxyUrl() throws IOException {
                try {
                    System.setProperty("kubeconfig", ConfigProxySourceTest.this.createKubeConfigWithCluster("http://kubernetes-remote-server.example:6443", "http://proxy-server.example:80").getAbsolutePath());
                    AssertionsForInterfaceTypes.assertThat((Object)new ConfigBuilder().build()).hasFieldOrPropertyWithValue("httpProxy", (Object)"http://proxy-server.example:80");
                }
                finally {
                    System.clearProperty("kubeconfig");
                }
            }
        }
    }
}

