/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.http;

import io.fabric8.kubernetes.client.http.HttpClient;
import io.fabric8.mockwebserver.DefaultMockServer;
import io.fabric8.mockwebserver.dsl.DelayPathable;
import io.fabric8.mockwebserver.dsl.ReturnOrWebsocketable;
import io.fabric8.mockwebserver.dsl.TimesOnceableOrHttpHeaderable;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import okhttp3.mockwebserver.RecordedRequest;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;

public abstract class AbstractHttpPostTest {
    private static DefaultMockServer server;

    @BeforeAll
    static void beforeAll() {
        server = new DefaultMockServer(false);
        server.start();
    }

    @AfterAll
    static void afterAll() {
        server.shutdown();
    }

    protected abstract HttpClient.Factory getHttpClientFactory();

    protected abstract Class<? extends Exception> getConnectionFailedExceptionType();

    @Test
    @DisplayName(value="String body, should send a POST request with body")
    public void postStringBody() throws Exception {
        try (HttpClient client = this.getHttpClientFactory().newBuilder().build();){
            client.sendAsync(client.newHttpRequestBuilder().uri(server.url("/post-string")).post("text/plain", "A string body").build(), String.class).get(10L, TimeUnit.SECONDS);
        }
        ((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)server.getLastRequest()).returns((Object)"POST", RecordedRequest::getMethod)).returns((Object)"A string body", rr -> rr.getBody().readUtf8())).extracting(rr -> rr.getHeader("Content-Type")).asString().startsWith((CharSequence)"text/plain");
    }

    @Test
    @DisplayName(value="InputStream body, should send a POST request with body")
    public void postInputStreamBody() throws Exception {
        try (HttpClient client = this.getHttpClientFactory().newBuilder().build();){
            client.sendAsync(client.newHttpRequestBuilder().uri(server.url("/post-input-stream")).post("text/plain", (InputStream)new ByteArrayInputStream("A string body".getBytes(StandardCharsets.UTF_8)), -1L).build(), String.class).get(10L, TimeUnit.SECONDS);
        }
        ((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)server.getLastRequest()).returns((Object)"POST", RecordedRequest::getMethod)).returns((Object)"A string body", rr -> rr.getBody().readUtf8())).extracting(rr -> rr.getHeader("Content-Type")).asString().startsWith((CharSequence)"text/plain");
    }

    @Test
    @DisplayName(value="byte[] body, should send a POST request with body")
    public void postBytesBody() throws Exception {
        try (HttpClient client = this.getHttpClientFactory().newBuilder().build();){
            client.sendAsync(client.newHttpRequestBuilder().uri(server.url("/post-bytes")).post("text/plain", "A string body".getBytes(StandardCharsets.UTF_8)).build(), String.class).get(10L, TimeUnit.SECONDS);
        }
        ((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)server.getLastRequest()).returns((Object)"POST", RecordedRequest::getMethod)).returns((Object)"A string body", rr -> rr.getBody().readUtf8())).extracting(rr -> rr.getHeader("Content-Type")).asString().startsWith((CharSequence)"text/plain");
    }

    @Test
    @DisplayName(value="FormData body, should send a POST request with body")
    public void postFormDataBody() throws Exception {
        try (HttpClient client = this.getHttpClientFactory().newBuilder().build();){
            client.sendAsync(client.newHttpRequestBuilder().uri(server.url("/post-bytes")).post(Collections.singletonMap("field", "value")).build(), String.class).get(10L, TimeUnit.SECONDS);
        }
        ((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)server.getLastRequest()).returns((Object)"POST", RecordedRequest::getMethod)).returns((Object)"field=value", rr -> rr.getBody().readUtf8())).extracting(rr -> rr.getHeader("Content-Type")).asString().startsWith((CharSequence)"application/x-www-form-urlencoded");
    }

    @Test
    public void expectContinue() throws Exception {
        ((TimesOnceableOrHttpHeaderable)((ReturnOrWebsocketable)((DelayPathable)server.expect().post()).withPath("/post-expect-continue")).andReturn(200, (Object)"")).always();
        try (HttpClient client = this.getHttpClientFactory().newBuilder().build();){
            CompletableFuture response = client.sendAsync(client.newHttpRequestBuilder().post(Collections.emptyMap()).uri(server.url("/post-expect-continue")).expectContinue().build(), String.class);
            Assertions.assertThat((CompletableFuture)response).succeedsWithin(10L, TimeUnit.SECONDS);
            ((ObjectAssert)Assertions.assertThat((Object)server.getLastRequest()).returns((Object)"POST", RecordedRequest::getMethod)).extracting(rr -> rr.getHeader("Expect")).asString().isEqualTo("100-continue");
        }
    }

    @Test
    public void expectFailure() throws IOException, URISyntaxException {
        try (ServerSocket serverSocket = new ServerSocket(0);
             HttpClient client = this.getHttpClientFactory().newBuilder().build();){
            URI uri = AbstractHttpPostTest.uriForPath(serverSocket, "/post-failing");
            serverSocket.close();
            CompletableFuture response = client.sendAsync(client.newHttpRequestBuilder().post("text/plain", (InputStream)new ByteArrayInputStream("A string body".getBytes(StandardCharsets.UTF_8)), -1L).uri(uri).timeout(250L, TimeUnit.MILLISECONDS).build(), String.class);
            Assertions.assertThat((CompletableFuture)response).failsWithin(30L, TimeUnit.SECONDS).withThrowableOfType(ExecutionException.class).withCauseInstanceOf(this.getConnectionFailedExceptionType());
        }
    }

    private static URI uriForPath(ServerSocket socket, String path) throws URISyntaxException {
        InetAddress httpServerAddress = socket.getInetAddress();
        return new URI(String.format("http://%s:%s%s", httpServerAddress.getHostName(), socket.getLocalPort(), path));
    }
}

