/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.utils;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.fabric8.kubernetes.api.model.Namespaced;
import io.fabric8.kubernetes.client.CustomResource;
import io.fabric8.kubernetes.client.utils.Serialization;
import io.fabric8.kubernetes.model.annotation.Group;
import io.fabric8.kubernetes.model.annotation.Version;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class SerializationWrappedPolymorphicTest {
    SerializationWrappedPolymorphicTest() {
    }

    @Test
    void testPolyRoundTrip() {
        TestCR original = new TestCR();
        FooChild foo = new FooChild();
        foo.setName("alice");
        BarChild bar = new BarChild();
        bar.setFile("bob");
        ((TestCR.TestCRSpec)original.getSpec()).setChildren(Arrays.asList(foo, bar));
        String json = Serialization.asJson((Object)((Object)original));
        Assertions.assertThat((String)json).isEqualTo("{\"apiVersion\":\"example.com/v1alpha1\",\"kind\":\"TestCR\",\"metadata\":{},\"spec\":{\"children\":[{\"foo\":{\"name\":\"alice\"}},{\"bar\":{\"file\":\"bob\"}}]}}");
        TestCR deserialized = (TestCR)((Object)Serialization.unmarshal((String)json, TestCR.class));
        org.junit.jupiter.api.Assertions.assertEquals(((TestCR.TestCRSpec)deserialized.getSpec()).getChildren(), ((TestCR.TestCRSpec)original.getSpec()).getChildren());
    }

    @JsonTypeName(value="bar")
    static class BarChild
    implements Child {
        private String file;

        public String getFile() {
            return this.file;
        }

        public void setFile(String file) {
            this.file = file;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof BarChild)) {
                return false;
            }
            BarChild other = (BarChild)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$file = this.getFile();
            String other$file = other.getFile();
            return !(this$file == null ? other$file != null : !this$file.equals(other$file));
        }

        protected boolean canEqual(Object other) {
            return other instanceof BarChild;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $file = this.getFile();
            result = result * 59 + ($file == null ? 43 : $file.hashCode());
            return result;
        }

        public String toString() {
            return "SerializationWrappedPolymorphicTest.BarChild(file=" + this.getFile() + ")";
        }
    }

    @JsonTypeName(value="foo")
    static class FooChild
    implements Child {
        private String name;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FooChild)) {
                return false;
            }
            FooChild other = (FooChild)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            return !(this$name == null ? other$name != null : !this$name.equals(other$name));
        }

        protected boolean canEqual(Object other) {
            return other instanceof FooChild;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            return result;
        }

        public String toString() {
            return "SerializationWrappedPolymorphicTest.FooChild(name=" + this.getName() + ")";
        }
    }

    @JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.WRAPPER_OBJECT)
    @JsonSubTypes(value={@JsonSubTypes.Type(value=FooChild.class), @JsonSubTypes.Type(value=BarChild.class)})
    @JsonDeserialize(using=JsonDeserializer.None.class)
    static interface Child
    extends KubernetesResource {
    }

    @Group(value="example.com")
    @Version(value="v1alpha1")
    static class TestCR
    extends CustomResource<TestCRSpec, Void>
    implements Namespaced {
        TestCR() {
        }

        protected TestCRSpec initSpec() {
            return new TestCRSpec();
        }

        @JsonDeserialize(using=JsonDeserializer.None.class)
        static class TestCRSpec
        implements KubernetesResource {
            @JsonIgnore
            private final Map<String, Object> additionalProperties = new HashMap<String, Object>();
            private List<Child> children = new ArrayList<Child>();

            TestCRSpec() {
            }

            public List<Child> getChildren() {
                return this.children;
            }

            public void setChildren(List<Child> children) {
                this.children = children;
            }

            @JsonAnyGetter
            public Map<String, Object> getAdditionalProperties() {
                return this.additionalProperties;
            }

            @JsonAnySetter
            public void setAdditionalProperty(String name, Object value) {
                this.additionalProperties.put(name, value);
            }
        }
    }
}

