package io.fabric8.kubernetes.client;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class SundrioConfigBuilder extends SundrioConfigFluent<SundrioConfigBuilder> implements VisitableBuilder<SundrioConfig,SundrioConfigBuilder>{
  public SundrioConfigBuilder() {
    this.fluent = this;
  }
  
  public SundrioConfigBuilder(SundrioConfigFluent<?> fluent) {
    this.fluent = fluent;
  }
  
  public SundrioConfigBuilder(SundrioConfigFluent<?> fluent,SundrioConfig instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public SundrioConfigBuilder(SundrioConfig instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  SundrioConfigFluent<?> fluent;
  
  public SundrioConfig build() {
    SundrioConfig buildable = new SundrioConfig(fluent.getMasterUrl(),fluent.getApiVersion(),fluent.getNamespace(),fluent.getTrustCerts(),fluent.getDisableHostnameVerification(),fluent.getCaCertFile(),fluent.getCaCertData(),fluent.getClientCertFile(),fluent.getClientCertData(),fluent.getClientKeyFile(),fluent.getClientKeyData(),fluent.getClientKeyAlgo(),fluent.getClientKeyPassphrase(),fluent.getUsername(),fluent.getPassword(),fluent.getOauthToken(),fluent.getAutoOAuthToken(),fluent.getWatchReconnectInterval(),fluent.getWatchReconnectLimit(),fluent.getConnectionTimeout(),fluent.getRequestTimeout(),fluent.getScaleTimeout(),fluent.getLoggingInterval(),fluent.getMaxConcurrentRequests(),fluent.getMaxConcurrentRequestsPerHost(),fluent.getHttp2Disable(),fluent.getHttpProxy(),fluent.getHttpsProxy(),fluent.getNoProxy(),fluent.getUserAgent(),fluent.getTlsVersions(),fluent.getWebsocketPingInterval(),fluent.getProxyUsername(),fluent.getProxyPassword(),fluent.getTrustStoreFile(),fluent.getTrustStorePassphrase(),fluent.getKeyStoreFile(),fluent.getKeyStorePassphrase(),fluent.getImpersonateUsername(),fluent.getImpersonateGroups(),fluent.getImpersonateExtras(),fluent.getOauthTokenProvider(),fluent.getCustomHeaders(),fluent.getRequestRetryBackoffLimit(),fluent.getRequestRetryBackoffInterval(),fluent.getUploadRequestTimeout(),fluent.getOnlyHttpWatches(),fluent.getCurrentContext(),fluent.getContexts(),fluent.getAutoConfigure());
    buildable.setAuthProvider(fluent.getAuthProvider());
    buildable.setErrorMessages(fluent.getErrorMessages());
    buildable.setFile(fluent.getFile());
    return buildable;
  }
  

}