/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.assertions;

import io.fabric8.kubernetes.api.KubernetesHelper;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.assertions.ServicePodsAssert;
import io.fabric8.kubernetes.client.KubernetesClient;
import java.util.List;
import java.util.Objects;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.ObjectAssert;

public class ServicesAssert
extends ListAssert<Service> {
    private final KubernetesClient client;
    private final List<? extends Service> actual;

    public ServicesAssert(KubernetesClient client, List<? extends Service> actual) {
        super(actual);
        this.client = client;
        this.actual = actual;
    }

    public ServicesAssert assertAllServicesHaveEndpointOrReadyPod() {
        for (Service service : this.actual) {
            ServicePodsAssert asserter = new ServicePodsAssert(this.client, service);
            asserter.hasEndpointOrReadyPod();
        }
        return this;
    }

    public ServicePodsAssert service(String serviceName) {
        Service service = null;
        for (Service service2 : this.actual) {
            String name = KubernetesHelper.getName((HasMetadata)service2);
            if (!Objects.equals(name, serviceName)) continue;
            service = service2;
        }
        ((ObjectAssert)Assertions.assertThat(service).describedAs("No service could be found for name: " + serviceName, new Object[0])).isNotNull();
        return new ServicePodsAssert(this.client, service);
    }
}

