/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.coordination.v1;

import io.fabric8.kubernetes.api.model.coordination.v1.LeaseSpec;
import java.time.ZonedDateTime;
import java.util.Map;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.MapAssert;
import org.assertj.core.api.StringAssert;
import org.assertj.core.api.ZonedDateTimeAssert;
import org.assertj.core.util.Objects;

public abstract class AbstractLeaseSpecAssert<S extends AbstractLeaseSpecAssert<S, A>, A extends LeaseSpec>
extends AbstractAssert<S, A> {
    protected AbstractLeaseSpecAssert(A actual, Class<S> selfType) {
        super(actual, selfType);
    }

    public ZonedDateTimeAssert acquireTime() {
        this.isNotNull();
        return (ZonedDateTimeAssert)Assertions.assertThat((ZonedDateTime)((LeaseSpec)this.actual).getAcquireTime()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "acquireTime"), new Object[0]);
    }

    public MapAssert additionalProperties() {
        this.isNotNull();
        return (MapAssert)Assertions.assertThat((Map)((LeaseSpec)this.actual).getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"), new Object[0]);
    }

    public StringAssert holderIdentity() {
        this.isNotNull();
        return (StringAssert)Assertions.assertThat((String)((LeaseSpec)this.actual).getHolderIdentity()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "holderIdentity"), new Object[0]);
    }

    public S hasLeaseDurationSeconds(Integer leaseDurationSeconds) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting leaseDurationSeconds of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        Integer actualLeaseDurationSeconds = ((LeaseSpec)this.actual).getLeaseDurationSeconds();
        if (!Objects.areEqual((Object)actualLeaseDurationSeconds, (Object)leaseDurationSeconds)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, leaseDurationSeconds, actualLeaseDurationSeconds});
        }
        return (S)((Object)((AbstractLeaseSpecAssert)this.myself));
    }

    public S hasLeaseTransitions(Integer leaseTransitions) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting leaseTransitions of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        Integer actualLeaseTransitions = ((LeaseSpec)this.actual).getLeaseTransitions();
        if (!Objects.areEqual((Object)actualLeaseTransitions, (Object)leaseTransitions)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, leaseTransitions, actualLeaseTransitions});
        }
        return (S)((Object)((AbstractLeaseSpecAssert)this.myself));
    }

    public ZonedDateTimeAssert renewTime() {
        this.isNotNull();
        return (ZonedDateTimeAssert)Assertions.assertThat((ZonedDateTime)((LeaseSpec)this.actual).getRenewTime()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "renewTime"), new Object[0]);
    }
}

