/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.model.ServicePort;
import io.fabric8.kubernetes.api.model.ServicePortAssert;
import io.fabric8.kubernetes.api.model.ServiceSpec;
import io.fabric8.kubernetes.api.model.SessionAffinityConfigAssert;
import io.fabric8.kubernetes.assertions.NavigationListAssert;
import java.util.Map;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AssertFactory;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.BooleanAssert;
import org.assertj.core.api.MapAssert;
import org.assertj.core.api.StringAssert;
import org.assertj.core.util.Objects;

public abstract class AbstractServiceSpecAssert<S extends AbstractServiceSpecAssert<S, A>, A extends ServiceSpec>
extends AbstractAssert<S, A> {
    protected AbstractServiceSpecAssert(A actual, Class<S> selfType) {
        super(actual, selfType);
    }

    public MapAssert additionalProperties() {
        this.isNotNull();
        return (MapAssert)Assertions.assertThat((Map)((ServiceSpec)this.actual).getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"), new Object[0]);
    }

    public StringAssert clusterIP() {
        this.isNotNull();
        return (StringAssert)Assertions.assertThat((String)((ServiceSpec)this.actual).getClusterIP()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "clusterIP"), new Object[0]);
    }

    public NavigationListAssert<String, StringAssert> externalIPs() {
        this.isNotNull();
        AssertFactory<String, StringAssert> assertFactory = new AssertFactory<String, StringAssert>(){

            public StringAssert createAssert(String t) {
                return (StringAssert)Assertions.assertThat((String)t);
            }
        };
        NavigationListAssert<String, StringAssert> answer = new NavigationListAssert<String, StringAssert>(((ServiceSpec)this.actual).getExternalIPs(), assertFactory);
        answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "externalIPs"), new Object[0]);
        return answer;
    }

    public StringAssert externalName() {
        this.isNotNull();
        return (StringAssert)Assertions.assertThat((String)((ServiceSpec)this.actual).getExternalName()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "externalName"), new Object[0]);
    }

    public StringAssert externalTrafficPolicy() {
        this.isNotNull();
        return (StringAssert)Assertions.assertThat((String)((ServiceSpec)this.actual).getExternalTrafficPolicy()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "externalTrafficPolicy"), new Object[0]);
    }

    public S hasHealthCheckNodePort(Integer healthCheckNodePort) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting healthCheckNodePort of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        Integer actualHealthCheckNodePort = ((ServiceSpec)this.actual).getHealthCheckNodePort();
        if (!Objects.areEqual((Object)actualHealthCheckNodePort, (Object)healthCheckNodePort)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, healthCheckNodePort, actualHealthCheckNodePort});
        }
        return (S)((Object)((AbstractServiceSpecAssert)this.myself));
    }

    public StringAssert ipFamily() {
        this.isNotNull();
        return (StringAssert)Assertions.assertThat((String)((ServiceSpec)this.actual).getIpFamily()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "ipFamily"), new Object[0]);
    }

    public StringAssert loadBalancerIP() {
        this.isNotNull();
        return (StringAssert)Assertions.assertThat((String)((ServiceSpec)this.actual).getLoadBalancerIP()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "loadBalancerIP"), new Object[0]);
    }

    public NavigationListAssert<String, StringAssert> loadBalancerSourceRanges() {
        this.isNotNull();
        AssertFactory<String, StringAssert> assertFactory = new AssertFactory<String, StringAssert>(){

            public StringAssert createAssert(String t) {
                return (StringAssert)Assertions.assertThat((String)t);
            }
        };
        NavigationListAssert<String, StringAssert> answer = new NavigationListAssert<String, StringAssert>(((ServiceSpec)this.actual).getLoadBalancerSourceRanges(), assertFactory);
        answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "loadBalancerSourceRanges"), new Object[0]);
        return answer;
    }

    public NavigationListAssert<ServicePort, ServicePortAssert> ports() {
        this.isNotNull();
        AssertFactory<ServicePort, ServicePortAssert> assertFactory = new AssertFactory<ServicePort, ServicePortAssert>(){

            public ServicePortAssert createAssert(ServicePort t) {
                return io.fabric8.kubernetes.assertions.internal.Assertions.assertThat(t);
            }
        };
        NavigationListAssert<ServicePort, ServicePortAssert> answer = new NavigationListAssert<ServicePort, ServicePortAssert>(((ServiceSpec)this.actual).getPorts(), assertFactory);
        answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "ports"), new Object[0]);
        return answer;
    }

    public BooleanAssert publishNotReadyAddresses() {
        this.isNotNull();
        return (BooleanAssert)Assertions.assertThat((Boolean)((ServiceSpec)this.actual).getPublishNotReadyAddresses()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "publishNotReadyAddresses"), new Object[0]);
    }

    public MapAssert selector() {
        this.isNotNull();
        return (MapAssert)Assertions.assertThat((Map)((ServiceSpec)this.actual).getSelector()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "selector"), new Object[0]);
    }

    public StringAssert sessionAffinity() {
        this.isNotNull();
        return (StringAssert)Assertions.assertThat((String)((ServiceSpec)this.actual).getSessionAffinity()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "sessionAffinity"), new Object[0]);
    }

    public SessionAffinityConfigAssert sessionAffinityConfig() {
        this.isNotNull();
        return (SessionAffinityConfigAssert)((Object)io.fabric8.kubernetes.assertions.internal.Assertions.assertThat(((ServiceSpec)this.actual).getSessionAffinityConfig()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "sessionAffinityConfig"), new Object[0]));
    }

    public NavigationListAssert<String, StringAssert> topologyKeys() {
        this.isNotNull();
        AssertFactory<String, StringAssert> assertFactory = new AssertFactory<String, StringAssert>(){

            public StringAssert createAssert(String t) {
                return (StringAssert)Assertions.assertThat((String)t);
            }
        };
        NavigationListAssert<String, StringAssert> answer = new NavigationListAssert<String, StringAssert>(((ServiceSpec)this.actual).getTopologyKeys(), assertFactory);
        answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "topologyKeys"), new Object[0]);
        return answer;
    }

    public StringAssert type() {
        this.isNotNull();
        return (StringAssert)Assertions.assertThat((String)((ServiceSpec)this.actual).getType()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "type"), new Object[0]);
    }
}

