/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.model.AffinityAssert;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerAssert;
import io.fabric8.kubernetes.api.model.EphemeralContainer;
import io.fabric8.kubernetes.api.model.EphemeralContainerAssert;
import io.fabric8.kubernetes.api.model.HostAlias;
import io.fabric8.kubernetes.api.model.HostAliasAssert;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceAssert;
import io.fabric8.kubernetes.api.model.PodDNSConfigAssert;
import io.fabric8.kubernetes.api.model.PodReadinessGate;
import io.fabric8.kubernetes.api.model.PodReadinessGateAssert;
import io.fabric8.kubernetes.api.model.PodSecurityContextAssert;
import io.fabric8.kubernetes.api.model.PodSpec;
import io.fabric8.kubernetes.api.model.Toleration;
import io.fabric8.kubernetes.api.model.TolerationAssert;
import io.fabric8.kubernetes.api.model.TopologySpreadConstraint;
import io.fabric8.kubernetes.api.model.TopologySpreadConstraintAssert;
import io.fabric8.kubernetes.api.model.Volume;
import io.fabric8.kubernetes.api.model.VolumeAssert;
import io.fabric8.kubernetes.assertions.NavigationListAssert;
import java.util.Map;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AssertFactory;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.BooleanAssert;
import org.assertj.core.api.MapAssert;
import org.assertj.core.api.StringAssert;
import org.assertj.core.util.Objects;

public abstract class AbstractPodSpecAssert<S extends AbstractPodSpecAssert<S, A>, A extends PodSpec>
extends AbstractAssert<S, A> {
    protected AbstractPodSpecAssert(A actual, Class<S> selfType) {
        super(actual, selfType);
    }

    public S hasActiveDeadlineSeconds(Long activeDeadlineSeconds) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting activeDeadlineSeconds of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        Long actualActiveDeadlineSeconds = ((PodSpec)this.actual).getActiveDeadlineSeconds();
        if (!Objects.areEqual((Object)actualActiveDeadlineSeconds, (Object)activeDeadlineSeconds)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, activeDeadlineSeconds, actualActiveDeadlineSeconds});
        }
        return (S)((Object)((AbstractPodSpecAssert)this.myself));
    }

    public MapAssert additionalProperties() {
        this.isNotNull();
        return (MapAssert)Assertions.assertThat((Map)((PodSpec)this.actual).getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"), new Object[0]);
    }

    public AffinityAssert affinity() {
        this.isNotNull();
        return (AffinityAssert)((Object)io.fabric8.kubernetes.assertions.internal.Assertions.assertThat(((PodSpec)this.actual).getAffinity()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "affinity"), new Object[0]));
    }

    public BooleanAssert automountServiceAccountToken() {
        this.isNotNull();
        return (BooleanAssert)Assertions.assertThat((Boolean)((PodSpec)this.actual).getAutomountServiceAccountToken()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "automountServiceAccountToken"), new Object[0]);
    }

    public NavigationListAssert<Container, ContainerAssert> containers() {
        this.isNotNull();
        AssertFactory<Container, ContainerAssert> assertFactory = new AssertFactory<Container, ContainerAssert>(){

            public ContainerAssert createAssert(Container t) {
                return io.fabric8.kubernetes.assertions.internal.Assertions.assertThat(t);
            }
        };
        NavigationListAssert<Container, ContainerAssert> answer = new NavigationListAssert<Container, ContainerAssert>(((PodSpec)this.actual).getContainers(), assertFactory);
        answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "containers"), new Object[0]);
        return answer;
    }

    public PodDNSConfigAssert dnsConfig() {
        this.isNotNull();
        return (PodDNSConfigAssert)((Object)io.fabric8.kubernetes.assertions.internal.Assertions.assertThat(((PodSpec)this.actual).getDnsConfig()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "dnsConfig"), new Object[0]));
    }

    public StringAssert dnsPolicy() {
        this.isNotNull();
        return (StringAssert)Assertions.assertThat((String)((PodSpec)this.actual).getDnsPolicy()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "dnsPolicy"), new Object[0]);
    }

    public BooleanAssert enableServiceLinks() {
        this.isNotNull();
        return (BooleanAssert)Assertions.assertThat((Boolean)((PodSpec)this.actual).getEnableServiceLinks()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "enableServiceLinks"), new Object[0]);
    }

    public NavigationListAssert<EphemeralContainer, EphemeralContainerAssert> ephemeralContainers() {
        this.isNotNull();
        AssertFactory<EphemeralContainer, EphemeralContainerAssert> assertFactory = new AssertFactory<EphemeralContainer, EphemeralContainerAssert>(){

            public EphemeralContainerAssert createAssert(EphemeralContainer t) {
                return io.fabric8.kubernetes.assertions.internal.Assertions.assertThat(t);
            }
        };
        NavigationListAssert<EphemeralContainer, EphemeralContainerAssert> answer = new NavigationListAssert<EphemeralContainer, EphemeralContainerAssert>(((PodSpec)this.actual).getEphemeralContainers(), assertFactory);
        answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "ephemeralContainers"), new Object[0]);
        return answer;
    }

    public NavigationListAssert<HostAlias, HostAliasAssert> hostAliases() {
        this.isNotNull();
        AssertFactory<HostAlias, HostAliasAssert> assertFactory = new AssertFactory<HostAlias, HostAliasAssert>(){

            public HostAliasAssert createAssert(HostAlias t) {
                return io.fabric8.kubernetes.assertions.internal.Assertions.assertThat(t);
            }
        };
        NavigationListAssert<HostAlias, HostAliasAssert> answer = new NavigationListAssert<HostAlias, HostAliasAssert>(((PodSpec)this.actual).getHostAliases(), assertFactory);
        answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "hostAliases"), new Object[0]);
        return answer;
    }

    public BooleanAssert hostIPC() {
        this.isNotNull();
        return (BooleanAssert)Assertions.assertThat((Boolean)((PodSpec)this.actual).getHostIPC()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "hostIPC"), new Object[0]);
    }

    public BooleanAssert hostNetwork() {
        this.isNotNull();
        return (BooleanAssert)Assertions.assertThat((Boolean)((PodSpec)this.actual).getHostNetwork()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "hostNetwork"), new Object[0]);
    }

    public BooleanAssert hostPID() {
        this.isNotNull();
        return (BooleanAssert)Assertions.assertThat((Boolean)((PodSpec)this.actual).getHostPID()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "hostPID"), new Object[0]);
    }

    public StringAssert hostname() {
        this.isNotNull();
        return (StringAssert)Assertions.assertThat((String)((PodSpec)this.actual).getHostname()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "hostname"), new Object[0]);
    }

    public NavigationListAssert<LocalObjectReference, LocalObjectReferenceAssert> imagePullSecrets() {
        this.isNotNull();
        AssertFactory<LocalObjectReference, LocalObjectReferenceAssert> assertFactory = new AssertFactory<LocalObjectReference, LocalObjectReferenceAssert>(){

            public LocalObjectReferenceAssert createAssert(LocalObjectReference t) {
                return io.fabric8.kubernetes.assertions.internal.Assertions.assertThat(t);
            }
        };
        NavigationListAssert<LocalObjectReference, LocalObjectReferenceAssert> answer = new NavigationListAssert<LocalObjectReference, LocalObjectReferenceAssert>(((PodSpec)this.actual).getImagePullSecrets(), assertFactory);
        answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "imagePullSecrets"), new Object[0]);
        return answer;
    }

    public NavigationListAssert<Container, ContainerAssert> initContainers() {
        this.isNotNull();
        AssertFactory<Container, ContainerAssert> assertFactory = new AssertFactory<Container, ContainerAssert>(){

            public ContainerAssert createAssert(Container t) {
                return io.fabric8.kubernetes.assertions.internal.Assertions.assertThat(t);
            }
        };
        NavigationListAssert<Container, ContainerAssert> answer = new NavigationListAssert<Container, ContainerAssert>(((PodSpec)this.actual).getInitContainers(), assertFactory);
        answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "initContainers"), new Object[0]);
        return answer;
    }

    public StringAssert nodeName() {
        this.isNotNull();
        return (StringAssert)Assertions.assertThat((String)((PodSpec)this.actual).getNodeName()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "nodeName"), new Object[0]);
    }

    public MapAssert nodeSelector() {
        this.isNotNull();
        return (MapAssert)Assertions.assertThat((Map)((PodSpec)this.actual).getNodeSelector()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "nodeSelector"), new Object[0]);
    }

    public MapAssert overhead() {
        this.isNotNull();
        return (MapAssert)Assertions.assertThat((Map)((PodSpec)this.actual).getOverhead()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "overhead"), new Object[0]);
    }

    public StringAssert preemptionPolicy() {
        this.isNotNull();
        return (StringAssert)Assertions.assertThat((String)((PodSpec)this.actual).getPreemptionPolicy()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "preemptionPolicy"), new Object[0]);
    }

    public S hasPriority(Integer priority) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting priority of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        Integer actualPriority = ((PodSpec)this.actual).getPriority();
        if (!Objects.areEqual((Object)actualPriority, (Object)priority)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, priority, actualPriority});
        }
        return (S)((Object)((AbstractPodSpecAssert)this.myself));
    }

    public StringAssert priorityClassName() {
        this.isNotNull();
        return (StringAssert)Assertions.assertThat((String)((PodSpec)this.actual).getPriorityClassName()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "priorityClassName"), new Object[0]);
    }

    public NavigationListAssert<PodReadinessGate, PodReadinessGateAssert> readinessGates() {
        this.isNotNull();
        AssertFactory<PodReadinessGate, PodReadinessGateAssert> assertFactory = new AssertFactory<PodReadinessGate, PodReadinessGateAssert>(){

            public PodReadinessGateAssert createAssert(PodReadinessGate t) {
                return io.fabric8.kubernetes.assertions.internal.Assertions.assertThat(t);
            }
        };
        NavigationListAssert<PodReadinessGate, PodReadinessGateAssert> answer = new NavigationListAssert<PodReadinessGate, PodReadinessGateAssert>(((PodSpec)this.actual).getReadinessGates(), assertFactory);
        answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "readinessGates"), new Object[0]);
        return answer;
    }

    public StringAssert restartPolicy() {
        this.isNotNull();
        return (StringAssert)Assertions.assertThat((String)((PodSpec)this.actual).getRestartPolicy()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "restartPolicy"), new Object[0]);
    }

    public StringAssert runtimeClassName() {
        this.isNotNull();
        return (StringAssert)Assertions.assertThat((String)((PodSpec)this.actual).getRuntimeClassName()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "runtimeClassName"), new Object[0]);
    }

    public StringAssert schedulerName() {
        this.isNotNull();
        return (StringAssert)Assertions.assertThat((String)((PodSpec)this.actual).getSchedulerName()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "schedulerName"), new Object[0]);
    }

    public PodSecurityContextAssert securityContext() {
        this.isNotNull();
        return (PodSecurityContextAssert)((Object)io.fabric8.kubernetes.assertions.internal.Assertions.assertThat(((PodSpec)this.actual).getSecurityContext()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "securityContext"), new Object[0]));
    }

    public StringAssert serviceAccount() {
        this.isNotNull();
        return (StringAssert)Assertions.assertThat((String)((PodSpec)this.actual).getServiceAccount()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "serviceAccount"), new Object[0]);
    }

    public StringAssert serviceAccountName() {
        this.isNotNull();
        return (StringAssert)Assertions.assertThat((String)((PodSpec)this.actual).getServiceAccountName()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "serviceAccountName"), new Object[0]);
    }

    public BooleanAssert shareProcessNamespace() {
        this.isNotNull();
        return (BooleanAssert)Assertions.assertThat((Boolean)((PodSpec)this.actual).getShareProcessNamespace()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "shareProcessNamespace"), new Object[0]);
    }

    public StringAssert subdomain() {
        this.isNotNull();
        return (StringAssert)Assertions.assertThat((String)((PodSpec)this.actual).getSubdomain()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "subdomain"), new Object[0]);
    }

    public S hasTerminationGracePeriodSeconds(Long terminationGracePeriodSeconds) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting terminationGracePeriodSeconds of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        Long actualTerminationGracePeriodSeconds = ((PodSpec)this.actual).getTerminationGracePeriodSeconds();
        if (!Objects.areEqual((Object)actualTerminationGracePeriodSeconds, (Object)terminationGracePeriodSeconds)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, terminationGracePeriodSeconds, actualTerminationGracePeriodSeconds});
        }
        return (S)((Object)((AbstractPodSpecAssert)this.myself));
    }

    public NavigationListAssert<Toleration, TolerationAssert> tolerations() {
        this.isNotNull();
        AssertFactory<Toleration, TolerationAssert> assertFactory = new AssertFactory<Toleration, TolerationAssert>(){

            public TolerationAssert createAssert(Toleration t) {
                return io.fabric8.kubernetes.assertions.internal.Assertions.assertThat(t);
            }
        };
        NavigationListAssert<Toleration, TolerationAssert> answer = new NavigationListAssert<Toleration, TolerationAssert>(((PodSpec)this.actual).getTolerations(), assertFactory);
        answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "tolerations"), new Object[0]);
        return answer;
    }

    public NavigationListAssert<TopologySpreadConstraint, TopologySpreadConstraintAssert> topologySpreadConstraints() {
        this.isNotNull();
        AssertFactory<TopologySpreadConstraint, TopologySpreadConstraintAssert> assertFactory = new AssertFactory<TopologySpreadConstraint, TopologySpreadConstraintAssert>(){

            public TopologySpreadConstraintAssert createAssert(TopologySpreadConstraint t) {
                return io.fabric8.kubernetes.assertions.internal.Assertions.assertThat(t);
            }
        };
        NavigationListAssert<TopologySpreadConstraint, TopologySpreadConstraintAssert> answer = new NavigationListAssert<TopologySpreadConstraint, TopologySpreadConstraintAssert>(((PodSpec)this.actual).getTopologySpreadConstraints(), assertFactory);
        answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "topologySpreadConstraints"), new Object[0]);
        return answer;
    }

    public NavigationListAssert<Volume, VolumeAssert> volumes() {
        this.isNotNull();
        AssertFactory<Volume, VolumeAssert> assertFactory = new AssertFactory<Volume, VolumeAssert>(){

            public VolumeAssert createAssert(Volume t) {
                return io.fabric8.kubernetes.assertions.internal.Assertions.assertThat(t);
            }
        };
        NavigationListAssert<Volume, VolumeAssert> answer = new NavigationListAssert<Volume, VolumeAssert>(((PodSpec)this.actual).getVolumes(), assertFactory);
        answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "volumes"), new Object[0]);
        return answer;
    }
}

