/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.model.ContainerStateAssert;
import io.fabric8.kubernetes.api.model.ContainerStatus;
import java.util.Map;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.BooleanAssert;
import org.assertj.core.api.MapAssert;
import org.assertj.core.api.StringAssert;
import org.assertj.core.util.Objects;

public abstract class AbstractContainerStatusAssert<S extends AbstractContainerStatusAssert<S, A>, A extends ContainerStatus>
extends AbstractAssert<S, A> {
    protected AbstractContainerStatusAssert(A actual, Class<S> selfType) {
        super(actual, selfType);
    }

    public MapAssert additionalProperties() {
        this.isNotNull();
        return (MapAssert)Assertions.assertThat((Map)((ContainerStatus)this.actual).getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"), new Object[0]);
    }

    public StringAssert containerID() {
        this.isNotNull();
        return (StringAssert)Assertions.assertThat((String)((ContainerStatus)this.actual).getContainerID()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "containerID"), new Object[0]);
    }

    public StringAssert image() {
        this.isNotNull();
        return (StringAssert)Assertions.assertThat((String)((ContainerStatus)this.actual).getImage()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "image"), new Object[0]);
    }

    public StringAssert imageID() {
        this.isNotNull();
        return (StringAssert)Assertions.assertThat((String)((ContainerStatus)this.actual).getImageID()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "imageID"), new Object[0]);
    }

    public ContainerStateAssert lastState() {
        this.isNotNull();
        return (ContainerStateAssert)((Object)io.fabric8.kubernetes.assertions.internal.Assertions.assertThat(((ContainerStatus)this.actual).getLastState()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "lastState"), new Object[0]));
    }

    public StringAssert name() {
        this.isNotNull();
        return (StringAssert)Assertions.assertThat((String)((ContainerStatus)this.actual).getName()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "name"), new Object[0]);
    }

    public BooleanAssert ready() {
        this.isNotNull();
        return (BooleanAssert)Assertions.assertThat((Boolean)((ContainerStatus)this.actual).getReady()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "ready"), new Object[0]);
    }

    public S hasRestartCount(Integer restartCount) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting restartCount of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        Integer actualRestartCount = ((ContainerStatus)this.actual).getRestartCount();
        if (!Objects.areEqual((Object)actualRestartCount, (Object)restartCount)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, restartCount, actualRestartCount});
        }
        return (S)((Object)((AbstractContainerStatusAssert)this.myself));
    }

    public BooleanAssert started() {
        this.isNotNull();
        return (BooleanAssert)Assertions.assertThat((Boolean)((ContainerStatus)this.actual).getStarted()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "started"), new Object[0]);
    }

    public ContainerStateAssert state() {
        this.isNotNull();
        return (ContainerStateAssert)((Object)io.fabric8.kubernetes.assertions.internal.Assertions.assertThat(((ContainerStatus)this.actual).getState()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "state"), new Object[0]));
    }
}

