/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.model.ContainerImage;
import io.fabric8.kubernetes.assertions.NavigationListAssert;
import java.util.Map;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AssertFactory;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.MapAssert;
import org.assertj.core.api.StringAssert;
import org.assertj.core.util.Objects;

public abstract class AbstractContainerImageAssert<S extends AbstractContainerImageAssert<S, A>, A extends ContainerImage>
extends AbstractAssert<S, A> {
    protected AbstractContainerImageAssert(A actual, Class<S> selfType) {
        super(actual, selfType);
    }

    public MapAssert additionalProperties() {
        this.isNotNull();
        return (MapAssert)Assertions.assertThat((Map)((ContainerImage)this.actual).getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"), new Object[0]);
    }

    public NavigationListAssert<String, StringAssert> names() {
        this.isNotNull();
        AssertFactory<String, StringAssert> assertFactory = new AssertFactory<String, StringAssert>(){

            public StringAssert createAssert(String t) {
                return (StringAssert)Assertions.assertThat((String)t);
            }
        };
        NavigationListAssert<String, StringAssert> answer = new NavigationListAssert<String, StringAssert>(((ContainerImage)this.actual).getNames(), assertFactory);
        answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "names"), new Object[0]);
        return answer;
    }

    public S hasSizeBytes(Long sizeBytes) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting sizeBytes of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        Long actualSizeBytes = ((ContainerImage)this.actual).getSizeBytes();
        if (!Objects.areEqual((Object)actualSizeBytes, (Object)sizeBytes)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, sizeBytes, actualSizeBytes});
        }
        return (S)((Object)((AbstractContainerImageAssert)this.myself));
    }
}

