/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.model.extensions.StatefulSetStatus;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.MapAssert;
import org.assertj.core.api.StringAssert;
import org.assertj.core.util.Objects;

public abstract class AbstractStatefulSetStatusAssert<S extends AbstractStatefulSetStatusAssert<S, A>, A extends StatefulSetStatus>
extends AbstractAssert<S, A> {
    protected AbstractStatefulSetStatusAssert(A actual, Class<S> selfType) {
        super(actual, selfType);
    }

    public MapAssert additionalProperties() {
        this.isNotNull();
        return (MapAssert)Assertions.assertThat(((StatefulSetStatus)this.actual).getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"), new Object[0]);
    }

    public S hasCurrentReplicas(Integer currentReplicas) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting currentReplicas of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        Integer actualCurrentReplicas = ((StatefulSetStatus)this.actual).getCurrentReplicas();
        if (!Objects.areEqual((Object)actualCurrentReplicas, (Object)currentReplicas)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, currentReplicas, actualCurrentReplicas});
        }
        return (S)((Object)((AbstractStatefulSetStatusAssert)this.myself));
    }

    public StringAssert currentRevision() {
        this.isNotNull();
        return (StringAssert)Assertions.assertThat((String)((StatefulSetStatus)this.actual).getCurrentRevision()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "currentRevision"), new Object[0]);
    }

    public S hasObservedGeneration(Long observedGeneration) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting observedGeneration of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        Long actualObservedGeneration = ((StatefulSetStatus)this.actual).getObservedGeneration();
        if (!Objects.areEqual((Object)actualObservedGeneration, (Object)observedGeneration)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, observedGeneration, actualObservedGeneration});
        }
        return (S)((Object)((AbstractStatefulSetStatusAssert)this.myself));
    }

    public S hasReadyReplicas(Integer readyReplicas) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting readyReplicas of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        Integer actualReadyReplicas = ((StatefulSetStatus)this.actual).getReadyReplicas();
        if (!Objects.areEqual((Object)actualReadyReplicas, (Object)readyReplicas)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, readyReplicas, actualReadyReplicas});
        }
        return (S)((Object)((AbstractStatefulSetStatusAssert)this.myself));
    }

    public S hasReplicas(Integer replicas) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting replicas of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        Integer actualReplicas = ((StatefulSetStatus)this.actual).getReplicas();
        if (!Objects.areEqual((Object)actualReplicas, (Object)replicas)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, replicas, actualReplicas});
        }
        return (S)((Object)((AbstractStatefulSetStatusAssert)this.myself));
    }

    public StringAssert updateRevision() {
        this.isNotNull();
        return (StringAssert)Assertions.assertThat((String)((StatefulSetStatus)this.actual).getUpdateRevision()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "updateRevision"), new Object[0]);
    }

    public S hasUpdatedReplicas(Integer updatedReplicas) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting updatedReplicas of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        Integer actualUpdatedReplicas = ((StatefulSetStatus)this.actual).getUpdatedReplicas();
        if (!Objects.areEqual((Object)actualUpdatedReplicas, (Object)updatedReplicas)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, updatedReplicas, actualUpdatedReplicas});
        }
        return (S)((Object)((AbstractStatefulSetStatusAssert)this.myself));
    }
}

