/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.extensions.DaemonSetUpdateStrategy;
import io.fabric8.kubernetes.api.model.extensions.DaemonSetUpdateStrategyFluent;
import io.fabric8.kubernetes.api.model.extensions.DaemonSetUpdateStrategyFluentImpl;
import io.fabric8.kubernetes.api.model.extensions.EditableDaemonSetUpdateStrategy;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class DaemonSetUpdateStrategyBuilder
extends DaemonSetUpdateStrategyFluentImpl<DaemonSetUpdateStrategyBuilder>
implements VisitableBuilder<DaemonSetUpdateStrategy, DaemonSetUpdateStrategyBuilder> {
    DaemonSetUpdateStrategyFluent<?> fluent;

    public DaemonSetUpdateStrategyBuilder() {
        this(new DaemonSetUpdateStrategy());
    }

    public DaemonSetUpdateStrategyBuilder(DaemonSetUpdateStrategyFluent<?> fluent) {
        this(fluent, new DaemonSetUpdateStrategy());
    }

    public DaemonSetUpdateStrategyBuilder(DaemonSetUpdateStrategyFluent<?> fluent, DaemonSetUpdateStrategy instance) {
        this.fluent = fluent;
        fluent.withRollingUpdate(instance.getRollingUpdate());
        fluent.withType(instance.getType());
    }

    public DaemonSetUpdateStrategyBuilder(DaemonSetUpdateStrategy instance) {
        this.fluent = this;
        this.withRollingUpdate(instance.getRollingUpdate());
        this.withType(instance.getType());
    }

    public EditableDaemonSetUpdateStrategy build() {
        EditableDaemonSetUpdateStrategy buildable = new EditableDaemonSetUpdateStrategy(this.fluent.getRollingUpdate(), this.fluent.getType());
        this.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DaemonSetUpdateStrategyBuilder that = (DaemonSetUpdateStrategyBuilder)o;
        return !(this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this);
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

