/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluentImpl;
import io.fabric8.kubernetes.api.model.RBDVolumeSource;
import io.fabric8.kubernetes.api.model.RBDVolumeSourceFluent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RBDVolumeSourceFluentImpl<T extends RBDVolumeSourceFluent<T>>
extends BaseFluent<T>
implements RBDVolumeSourceFluent<T> {
    String fsType;
    String image;
    String keyring;
    List<String> monitors = new ArrayList<String>();
    String pool;
    Boolean readOnly;
    VisitableBuilder<LocalObjectReference, ?> secretRef;
    String user;
    Map<String, Object> additionalProperties = new HashMap<String, Object>();

    public RBDVolumeSourceFluentImpl() {
    }

    public RBDVolumeSourceFluentImpl(RBDVolumeSource instance) {
        this.withFsType(instance.getFsType());
        this.withImage(instance.getImage());
        this.withKeyring(instance.getKeyring());
        this.withMonitors(instance.getMonitors());
        this.withPool(instance.getPool());
        this.withReadOnly(instance.getReadOnly());
        this.withSecretRef(instance.getSecretRef());
        this.withUser(instance.getUser());
    }

    @Override
    public String getFsType() {
        return this.fsType;
    }

    @Override
    public T withFsType(String fsType) {
        this.fsType = fsType;
        return (T)this;
    }

    @Override
    public String getImage() {
        return this.image;
    }

    @Override
    public T withImage(String image) {
        this.image = image;
        return (T)this;
    }

    @Override
    public String getKeyring() {
        return this.keyring;
    }

    @Override
    public T withKeyring(String keyring) {
        this.keyring = keyring;
        return (T)this;
    }

    @Override
    public T addToMonitors(String ... items) {
        for (String item : items) {
            this.monitors.add(item);
        }
        return (T)this;
    }

    @Override
    public T removeFromMonitors(String ... items) {
        for (String item : items) {
            this.monitors.remove(item);
        }
        return (T)this;
    }

    @Override
    public List<String> getMonitors() {
        return this.monitors;
    }

    @Override
    public T withMonitors(List<String> monitors) {
        this.monitors.clear();
        if (monitors != null) {
            for (String item : monitors) {
                this.addToMonitors(item);
            }
        }
        return (T)this;
    }

    @Override
    public T withMonitors(String ... monitors) {
        this.monitors.clear();
        if (monitors != null) {
            for (String item : monitors) {
                this.addToMonitors(item);
            }
        }
        return (T)this;
    }

    @Override
    public String getPool() {
        return this.pool;
    }

    @Override
    public T withPool(String pool) {
        this.pool = pool;
        return (T)this;
    }

    @Override
    public Boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public T withReadOnly(Boolean readOnly) {
        this.readOnly = readOnly;
        return (T)this;
    }

    @Override
    public LocalObjectReference getSecretRef() {
        return this.secretRef != null ? (LocalObjectReference)this.secretRef.build() : null;
    }

    @Override
    public T withSecretRef(LocalObjectReference secretRef) {
        if (secretRef != null) {
            this.secretRef = new LocalObjectReferenceBuilder(secretRef);
            this._visitables.add(this.secretRef);
        }
        return (T)this;
    }

    @Override
    public RBDVolumeSourceFluent.SecretRefNested<T> withNewSecretRef() {
        return new SecretRefNestedImpl();
    }

    @Override
    public RBDVolumeSourceFluent.SecretRefNested<T> withNewSecretRefLike(LocalObjectReference item) {
        return new SecretRefNestedImpl(item);
    }

    @Override
    public RBDVolumeSourceFluent.SecretRefNested<T> editSecretRef() {
        return this.withNewSecretRefLike(this.getSecretRef());
    }

    @Override
    public T withNewSecretRef(String name) {
        return this.withSecretRef(new LocalObjectReference(name));
    }

    @Override
    public String getUser() {
        return this.user;
    }

    @Override
    public T withUser(String user) {
        this.user = user;
        return (T)this;
    }

    @Override
    public T addToAdditionalProperties(String key, Object value) {
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (T)this;
    }

    @Override
    public T addToAdditionalProperties(Map<String, Object> map) {
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (T)this;
    }

    @Override
    public T removeFromAdditionalProperties(String key) {
        if (key != null) {
            this.additionalProperties.remove(key);
        }
        return (T)this;
    }

    @Override
    public T removeFromAdditionalProperties(Map<String, Object> map) {
        if (map != null) {
            for (String key : map.keySet()) {
                this.additionalProperties.remove(key);
            }
        }
        return (T)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public T withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties.clear();
        if (additionalProperties != null) {
            this.additionalProperties.putAll(additionalProperties);
        }
        return (T)this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RBDVolumeSourceFluentImpl that = (RBDVolumeSourceFluentImpl)o;
        if (this.fsType != null ? !this.fsType.equals(that.fsType) : that.fsType != null) {
            return false;
        }
        if (this.image != null ? !this.image.equals(that.image) : that.image != null) {
            return false;
        }
        if (this.keyring != null ? !this.keyring.equals(that.keyring) : that.keyring != null) {
            return false;
        }
        if (this.monitors != null ? !this.monitors.equals(that.monitors) : that.monitors != null) {
            return false;
        }
        if (this.pool != null ? !this.pool.equals(that.pool) : that.pool != null) {
            return false;
        }
        if (this.readOnly != null ? !this.readOnly.equals(that.readOnly) : that.readOnly != null) {
            return false;
        }
        if (this.secretRef != null ? !this.secretRef.equals(that.secretRef) : that.secretRef != null) {
            return false;
        }
        if (this.user != null ? !this.user.equals(that.user) : that.user != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    public class SecretRefNestedImpl<N>
    extends LocalObjectReferenceFluentImpl<RBDVolumeSourceFluent.SecretRefNested<N>>
    implements RBDVolumeSourceFluent.SecretRefNested<N> {
        private final LocalObjectReferenceBuilder builder;

        SecretRefNestedImpl(LocalObjectReference item) {
            this.builder = new LocalObjectReferenceBuilder(this, item);
        }

        SecretRefNestedImpl() {
            this.builder = new LocalObjectReferenceBuilder(this);
        }

        @Override
        public N endSecretRef() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)RBDVolumeSourceFluentImpl.this.withSecretRef(this.builder.build());
        }
    }
}

