/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import io.fabric8.kubernetes.api.model.PodTemplateSpecBuilder;
import io.fabric8.kubernetes.api.model.PodTemplateSpecFluentImpl;
import io.fabric8.openshift.api.model.DeploymentConfigSpec;
import io.fabric8.openshift.api.model.DeploymentConfigSpecFluent;
import io.fabric8.openshift.api.model.DeploymentStrategy;
import io.fabric8.openshift.api.model.DeploymentStrategyBuilder;
import io.fabric8.openshift.api.model.DeploymentStrategyFluentImpl;
import io.fabric8.openshift.api.model.DeploymentTriggerPolicy;
import io.fabric8.openshift.api.model.DeploymentTriggerPolicyBuilder;
import io.fabric8.openshift.api.model.DeploymentTriggerPolicyFluentImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DeploymentConfigSpecFluentImpl<T extends DeploymentConfigSpecFluent<T>>
extends BaseFluent<T>
implements DeploymentConfigSpecFluent<T> {
    Integer replicas;
    Map<String, String> selector = new HashMap<String, String>();
    VisitableBuilder<DeploymentStrategy, ?> strategy;
    VisitableBuilder<PodTemplateSpec, ?> template;
    List<VisitableBuilder<DeploymentTriggerPolicy, ?>> triggers = new ArrayList();
    Map<String, Object> additionalProperties = new HashMap<String, Object>();

    public DeploymentConfigSpecFluentImpl() {
    }

    public DeploymentConfigSpecFluentImpl(DeploymentConfigSpec instance) {
        this.withReplicas(instance.getReplicas());
        this.withSelector(instance.getSelector());
        this.withStrategy(instance.getStrategy());
        this.withTemplate(instance.getTemplate());
        this.withTriggers(instance.getTriggers());
    }

    @Override
    public Integer getReplicas() {
        return this.replicas;
    }

    @Override
    public T withReplicas(Integer replicas) {
        this.replicas = replicas;
        return (T)this;
    }

    @Override
    public T addToSelector(String key, String value) {
        if (key != null && value != null) {
            this.selector.put(key, value);
        }
        return (T)this;
    }

    @Override
    public T addToSelector(Map<String, String> map) {
        if (map != null) {
            this.selector.putAll(map);
        }
        return (T)this;
    }

    @Override
    public T removeFromSelector(String key) {
        if (key != null) {
            this.selector.remove(key);
        }
        return (T)this;
    }

    @Override
    public T removeFromSelector(Map<String, String> map) {
        if (map != null) {
            for (String key : map.keySet()) {
                this.selector.remove(key);
            }
        }
        return (T)this;
    }

    @Override
    public Map<String, String> getSelector() {
        return this.selector;
    }

    @Override
    public T withSelector(Map<String, String> selector) {
        this.selector.clear();
        if (selector != null) {
            this.selector.putAll(selector);
        }
        return (T)this;
    }

    @Override
    public DeploymentStrategy getStrategy() {
        return this.strategy != null ? (DeploymentStrategy)this.strategy.build() : null;
    }

    @Override
    public T withStrategy(DeploymentStrategy strategy) {
        if (strategy != null) {
            this.strategy = new DeploymentStrategyBuilder(strategy);
            this._visitables.add(this.strategy);
        }
        return (T)this;
    }

    @Override
    public DeploymentConfigSpecFluent.StrategyNested<T> withNewStrategy() {
        return new StrategyNestedImpl();
    }

    @Override
    public DeploymentConfigSpecFluent.StrategyNested<T> withNewStrategyLike(DeploymentStrategy item) {
        return new StrategyNestedImpl(item);
    }

    @Override
    public DeploymentConfigSpecFluent.StrategyNested<T> editStrategy() {
        return this.withNewStrategyLike(this.getStrategy());
    }

    @Override
    public PodTemplateSpec getTemplate() {
        return this.template != null ? (PodTemplateSpec)this.template.build() : null;
    }

    @Override
    public T withTemplate(PodTemplateSpec template) {
        if (template != null) {
            this.template = new PodTemplateSpecBuilder(template);
            this._visitables.add(this.template);
        }
        return (T)this;
    }

    @Override
    public DeploymentConfigSpecFluent.TemplateNested<T> withNewTemplate() {
        return new TemplateNestedImpl();
    }

    @Override
    public DeploymentConfigSpecFluent.TemplateNested<T> withNewTemplateLike(PodTemplateSpec item) {
        return new TemplateNestedImpl(item);
    }

    @Override
    public DeploymentConfigSpecFluent.TemplateNested<T> editTemplate() {
        return this.withNewTemplateLike(this.getTemplate());
    }

    @Override
    public T addToTriggers(DeploymentTriggerPolicy ... items) {
        for (DeploymentTriggerPolicy item : items) {
            DeploymentTriggerPolicyBuilder builder = new DeploymentTriggerPolicyBuilder(item);
            this._visitables.add(builder);
            this.triggers.add(builder);
        }
        return (T)this;
    }

    @Override
    public T removeFromTriggers(DeploymentTriggerPolicy ... items) {
        for (DeploymentTriggerPolicy item : items) {
            DeploymentTriggerPolicyBuilder builder = new DeploymentTriggerPolicyBuilder(item);
            this._visitables.remove(builder);
            this.triggers.remove(builder);
        }
        return (T)this;
    }

    @Override
    public List<DeploymentTriggerPolicy> getTriggers() {
        return this.build(this.triggers);
    }

    @Override
    public T withTriggers(List<DeploymentTriggerPolicy> triggers) {
        this.triggers.clear();
        if (triggers != null) {
            for (DeploymentTriggerPolicy item : triggers) {
                this.addToTriggers(item);
            }
        }
        return (T)this;
    }

    @Override
    public T withTriggers(DeploymentTriggerPolicy ... triggers) {
        this.triggers.clear();
        if (triggers != null) {
            for (DeploymentTriggerPolicy item : triggers) {
                this.addToTriggers(item);
            }
        }
        return (T)this;
    }

    @Override
    public DeploymentConfigSpecFluent.TriggersNested<T> addNewTrigger() {
        return new TriggersNestedImpl();
    }

    @Override
    public DeploymentConfigSpecFluent.TriggersNested<T> addNewTriggerLike(DeploymentTriggerPolicy item) {
        return new TriggersNestedImpl(item);
    }

    @Override
    public T addToAdditionalProperties(String key, Object value) {
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (T)this;
    }

    @Override
    public T addToAdditionalProperties(Map<String, Object> map) {
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (T)this;
    }

    @Override
    public T removeFromAdditionalProperties(String key) {
        if (key != null) {
            this.additionalProperties.remove(key);
        }
        return (T)this;
    }

    @Override
    public T removeFromAdditionalProperties(Map<String, Object> map) {
        if (map != null) {
            for (String key : map.keySet()) {
                this.additionalProperties.remove(key);
            }
        }
        return (T)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public T withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties.clear();
        if (additionalProperties != null) {
            this.additionalProperties.putAll(additionalProperties);
        }
        return (T)this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeploymentConfigSpecFluentImpl that = (DeploymentConfigSpecFluentImpl)o;
        if (this.replicas != null ? !this.replicas.equals(that.replicas) : that.replicas != null) {
            return false;
        }
        if (this.selector != null ? !this.selector.equals(that.selector) : that.selector != null) {
            return false;
        }
        if (this.strategy != null ? !this.strategy.equals(that.strategy) : that.strategy != null) {
            return false;
        }
        if (this.template != null ? !this.template.equals(that.template) : that.template != null) {
            return false;
        }
        if (this.triggers != null ? !this.triggers.equals(that.triggers) : that.triggers != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    public class TriggersNestedImpl<N>
    extends DeploymentTriggerPolicyFluentImpl<DeploymentConfigSpecFluent.TriggersNested<N>>
    implements DeploymentConfigSpecFluent.TriggersNested<N> {
        private final DeploymentTriggerPolicyBuilder builder;

        TriggersNestedImpl() {
            this.builder = new DeploymentTriggerPolicyBuilder(this);
        }

        TriggersNestedImpl(DeploymentTriggerPolicy item) {
            this.builder = new DeploymentTriggerPolicyBuilder(this, item);
        }

        @Override
        public N endTrigger() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)DeploymentConfigSpecFluentImpl.this.addToTriggers(this.builder.build());
        }
    }

    public class TemplateNestedImpl<N>
    extends PodTemplateSpecFluentImpl<DeploymentConfigSpecFluent.TemplateNested<N>>
    implements DeploymentConfigSpecFluent.TemplateNested<N> {
        private final PodTemplateSpecBuilder builder;

        TemplateNestedImpl() {
            this.builder = new PodTemplateSpecBuilder(this);
        }

        TemplateNestedImpl(PodTemplateSpec item) {
            this.builder = new PodTemplateSpecBuilder(this, item);
        }

        @Override
        public N endTemplate() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)DeploymentConfigSpecFluentImpl.this.withTemplate(this.builder.build());
        }
    }

    public class StrategyNestedImpl<N>
    extends DeploymentStrategyFluentImpl<DeploymentConfigSpecFluent.StrategyNested<N>>
    implements DeploymentConfigSpecFluent.StrategyNested<N> {
        private final DeploymentStrategyBuilder builder;

        StrategyNestedImpl() {
            this.builder = new DeploymentStrategyBuilder(this);
        }

        StrategyNestedImpl(DeploymentStrategy item) {
            this.builder = new DeploymentStrategyBuilder(this, item);
        }

        @Override
        public N endStrategy() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)DeploymentConfigSpecFluentImpl.this.withStrategy(this.builder.build());
        }
    }
}

