/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.common.VisitableBuilder;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import io.fabric8.kubernetes.api.model.ResourceRequirementsFluent;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class ResourceRequirementsBuilder
extends ResourceRequirementsFluent<ResourceRequirementsBuilder>
implements VisitableBuilder<ResourceRequirements, ResourceRequirementsBuilder> {
    ResourceRequirementsFluent<?> fluent;

    public ResourceRequirementsBuilder() {
        this(new ResourceRequirements());
    }

    public ResourceRequirementsBuilder(ResourceRequirementsFluent<?> fluent) {
        this(fluent, new ResourceRequirements());
    }

    public ResourceRequirementsBuilder(ResourceRequirementsFluent<?> fluent, ResourceRequirements instance) {
        this.fluent = fluent;
        fluent.withLimits(instance.getLimits());
        fluent.withRequests(instance.getRequests());
    }

    public ResourceRequirementsBuilder(ResourceRequirements instance) {
        this.fluent = this;
        this.withLimits(instance.getLimits());
        this.withRequests(instance.getRequests());
    }

    public ResourceRequirements build() {
        ResourceRequirements buildable = new ResourceRequirements(this.fluent.getLimits(), this.fluent.getRequests());
        this.validate(buildable);
        return buildable;
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

