/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.ValidationUtils;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.extensions.JobSpec;
import io.fabric8.kubernetes.api.model.extensions.JobSpecFluent;
import io.fabric8.kubernetes.api.model.extensions.JobSpecFluentImpl;

public class JobSpecBuilder
extends JobSpecFluentImpl<JobSpecBuilder>
implements VisitableBuilder<JobSpec, JobSpecBuilder> {
    JobSpecFluent<?> fluent;
    Boolean validationEnabled;

    public JobSpecBuilder() {
        this(true);
    }

    public JobSpecBuilder(Boolean validationEnabled) {
        this(new JobSpec(), validationEnabled);
    }

    public JobSpecBuilder(JobSpecFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public JobSpecBuilder(JobSpecFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new JobSpec(), validationEnabled);
    }

    public JobSpecBuilder(JobSpecFluent<?> fluent, JobSpec instance) {
        this(fluent, instance, true);
    }

    public JobSpecBuilder(JobSpecFluent<?> fluent, JobSpec instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withActiveDeadlineSeconds(instance.getActiveDeadlineSeconds());
        fluent.withAutoSelector(instance.getAutoSelector());
        fluent.withCompletions(instance.getCompletions());
        fluent.withParallelism(instance.getParallelism());
        fluent.withSelector(instance.getSelector());
        fluent.withTemplate(instance.getTemplate());
        this.validationEnabled = validationEnabled;
    }

    public JobSpecBuilder(JobSpec instance) {
        this(instance, (Boolean)true);
    }

    public JobSpecBuilder(JobSpec instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withActiveDeadlineSeconds(instance.getActiveDeadlineSeconds());
        this.withAutoSelector(instance.getAutoSelector());
        this.withCompletions(instance.getCompletions());
        this.withParallelism(instance.getParallelism());
        this.withSelector(instance.getSelector());
        this.withTemplate(instance.getTemplate());
        this.validationEnabled = validationEnabled;
    }

    public JobSpec build() {
        JobSpec buildable = new JobSpec(this.fluent.getActiveDeadlineSeconds(), this.fluent.isAutoSelector(), this.fluent.getCompletions(), this.fluent.getParallelism(), this.fluent.getSelector(), this.fluent.getTemplate());
        ValidationUtils.validate((Object)buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        JobSpecBuilder that = (JobSpecBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

