/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.openshift.api.model.OAuthClient;
import io.fabric8.openshift.api.model.OAuthClientFluent;
import io.fabric8.openshift.api.model.OAuthClientFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolationException;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class OAuthClientBuilder
extends OAuthClientFluentImpl<OAuthClientBuilder>
implements VisitableBuilder<OAuthClient, OAuthClientBuilder> {
    OAuthClientFluent<?> fluent;
    Boolean validationEnabled;

    public OAuthClientBuilder() {
        this(true);
    }

    public OAuthClientBuilder(Boolean validationEnabled) {
        this(new OAuthClient(), validationEnabled);
    }

    public OAuthClientBuilder(OAuthClientFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public OAuthClientBuilder(OAuthClientFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new OAuthClient(), validationEnabled);
    }

    public OAuthClientBuilder(OAuthClientFluent<?> fluent, OAuthClient instance) {
        this(fluent, instance, true);
    }

    public OAuthClientBuilder(OAuthClientFluent<?> fluent, OAuthClient instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withAdditionalSecrets(instance.getAdditionalSecrets());
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withGrantMethod(instance.getGrantMethod());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
        fluent.withRedirectURIs(instance.getRedirectURIs());
        fluent.withRespondWithChallenges(instance.getRespondWithChallenges());
        fluent.withScopeRestrictions(instance.getScopeRestrictions());
        fluent.withSecret(instance.getSecret());
        this.validationEnabled = validationEnabled;
    }

    public OAuthClientBuilder(OAuthClient instance) {
        this(instance, (Boolean)true);
    }

    public OAuthClientBuilder(OAuthClient instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withAdditionalSecrets(instance.getAdditionalSecrets());
        this.withApiVersion(instance.getApiVersion());
        this.withGrantMethod(instance.getGrantMethod());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withRedirectURIs(instance.getRedirectURIs());
        this.withRespondWithChallenges(instance.getRespondWithChallenges());
        this.withScopeRestrictions(instance.getScopeRestrictions());
        this.withSecret(instance.getSecret());
        this.validationEnabled = validationEnabled;
    }

    public OAuthClient build() {
        OAuthClient buildable = new OAuthClient(this.fluent.getAdditionalSecrets(), this.fluent.getApiVersion(), this.fluent.getGrantMethod(), this.fluent.getKind(), this.fluent.getMetadata(), this.fluent.getRedirectURIs(), this.fluent.isRespondWithChallenges(), this.fluent.getScopeRestrictions(), this.fluent.getSecret());
        this.validate(buildable);
        return buildable;
    }

    private <T> void validate(T item) {
        if (!this.validationEnabled.booleanValue()) {
            return;
        }
        Validator validator = null;
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            validator = factory.getValidator();
        }
        catch (ValidationException e) {
            return;
        }
        Set violations = validator.validate(item, new Class[0]);
        if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        OAuthClientBuilder that = (OAuthClientBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

