/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.openshift.api.model.RouteStatus;
import io.fabric8.openshift.api.model.RouteStatusFluent;
import io.fabric8.openshift.api.model.RouteStatusFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolationException;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class RouteStatusBuilder
extends RouteStatusFluentImpl<RouteStatusBuilder>
implements VisitableBuilder<RouteStatus, RouteStatusBuilder> {
    RouteStatusFluent<?> fluent;
    Boolean validationEnabled;

    public RouteStatusBuilder() {
        this(true);
    }

    public RouteStatusBuilder(Boolean validationEnabled) {
        this(new RouteStatus(), validationEnabled);
    }

    public RouteStatusBuilder(RouteStatusFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public RouteStatusBuilder(RouteStatusFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new RouteStatus(), validationEnabled);
    }

    public RouteStatusBuilder(RouteStatusFluent<?> fluent, RouteStatus instance) {
        this(fluent, instance, true);
    }

    public RouteStatusBuilder(RouteStatusFluent<?> fluent, RouteStatus instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withIngress(instance.getIngress());
        this.validationEnabled = validationEnabled;
    }

    public RouteStatusBuilder(RouteStatus instance) {
        this(instance, (Boolean)true);
    }

    public RouteStatusBuilder(RouteStatus instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withIngress(instance.getIngress());
        this.validationEnabled = validationEnabled;
    }

    public RouteStatus build() {
        RouteStatus buildable = new RouteStatus(this.fluent.getIngress());
        this.validate(buildable);
        return buildable;
    }

    private <T> void validate(T item) {
        if (!this.validationEnabled.booleanValue()) {
            return;
        }
        Validator validator = null;
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            validator = factory.getValidator();
        }
        catch (ValidationException e) {
            return;
        }
        Set violations = validator.validate(item, new Class[0]);
        if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RouteStatusBuilder that = (RouteStatusBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

