/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.FSGroupStrategyOptions;
import io.fabric8.kubernetes.api.model.FSGroupStrategyOptionsBuilder;
import io.fabric8.kubernetes.api.model.FSGroupStrategyOptionsFluentImpl;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.kubernetes.api.model.RunAsUserStrategyOptions;
import io.fabric8.kubernetes.api.model.RunAsUserStrategyOptionsBuilder;
import io.fabric8.kubernetes.api.model.RunAsUserStrategyOptionsFluentImpl;
import io.fabric8.kubernetes.api.model.SELinuxContextStrategyOptions;
import io.fabric8.kubernetes.api.model.SELinuxContextStrategyOptionsBuilder;
import io.fabric8.kubernetes.api.model.SELinuxContextStrategyOptionsFluentImpl;
import io.fabric8.kubernetes.api.model.SecurityContextConstraints;
import io.fabric8.kubernetes.api.model.SecurityContextConstraintsFluent;
import io.fabric8.kubernetes.api.model.SupplementalGroupsStrategyOptions;
import io.fabric8.kubernetes.api.model.SupplementalGroupsStrategyOptionsBuilder;
import io.fabric8.kubernetes.api.model.SupplementalGroupsStrategyOptionsFluentImpl;
import java.util.ArrayList;
import java.util.List;

public class SecurityContextConstraintsFluentImpl<A extends SecurityContextConstraintsFluent<A>>
extends BaseFluent<A>
implements SecurityContextConstraintsFluent<A> {
    private Boolean allowHostDirVolumePlugin;
    private Boolean allowHostIPC;
    private Boolean allowHostNetwork;
    private Boolean allowHostPID;
    private Boolean allowHostPorts;
    private Boolean allowPrivilegedContainer;
    private List<String> allowedCapabilities = new ArrayList<String>();
    private String apiVersion;
    private List<String> defaultAddCapabilities = new ArrayList<String>();
    private VisitableBuilder<? extends FSGroupStrategyOptions, ?> fsGroup;
    private List<String> groups = new ArrayList<String>();
    private String kind;
    private VisitableBuilder<? extends ObjectMeta, ?> metadata;
    private Integer priority;
    private Boolean readOnlyRootFilesystem;
    private List<String> requiredDropCapabilities = new ArrayList<String>();
    private VisitableBuilder<? extends RunAsUserStrategyOptions, ?> runAsUser;
    private VisitableBuilder<? extends SELinuxContextStrategyOptions, ?> seLinuxContext;
    private List<String> seccompProfiles = new ArrayList<String>();
    private VisitableBuilder<? extends SupplementalGroupsStrategyOptions, ?> supplementalGroups;
    private List<String> users = new ArrayList<String>();
    private List<String> volumes = new ArrayList<String>();

    public SecurityContextConstraintsFluentImpl() {
    }

    public SecurityContextConstraintsFluentImpl(SecurityContextConstraints instance) {
        this.withAllowHostDirVolumePlugin(instance.getAllowHostDirVolumePlugin());
        this.withAllowHostIPC(instance.getAllowHostIPC());
        this.withAllowHostNetwork(instance.getAllowHostNetwork());
        this.withAllowHostPID(instance.getAllowHostPID());
        this.withAllowHostPorts(instance.getAllowHostPorts());
        this.withAllowPrivilegedContainer(instance.getAllowPrivilegedContainer());
        this.withAllowedCapabilities(instance.getAllowedCapabilities());
        this.withApiVersion(instance.getApiVersion());
        this.withDefaultAddCapabilities(instance.getDefaultAddCapabilities());
        this.withFsGroup(instance.getFsGroup());
        this.withGroups(instance.getGroups());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withPriority(instance.getPriority());
        this.withReadOnlyRootFilesystem(instance.getReadOnlyRootFilesystem());
        this.withRequiredDropCapabilities(instance.getRequiredDropCapabilities());
        this.withRunAsUser(instance.getRunAsUser());
        this.withSeLinuxContext(instance.getSeLinuxContext());
        this.withSeccompProfiles(instance.getSeccompProfiles());
        this.withSupplementalGroups(instance.getSupplementalGroups());
        this.withUsers(instance.getUsers());
        this.withVolumes(instance.getVolumes());
    }

    @Override
    public Boolean isAllowHostDirVolumePlugin() {
        return this.allowHostDirVolumePlugin;
    }

    @Override
    public A withAllowHostDirVolumePlugin(Boolean allowHostDirVolumePlugin) {
        this.allowHostDirVolumePlugin = allowHostDirVolumePlugin;
        return (A)this;
    }

    @Override
    public Boolean isAllowHostIPC() {
        return this.allowHostIPC;
    }

    @Override
    public A withAllowHostIPC(Boolean allowHostIPC) {
        this.allowHostIPC = allowHostIPC;
        return (A)this;
    }

    @Override
    public Boolean isAllowHostNetwork() {
        return this.allowHostNetwork;
    }

    @Override
    public A withAllowHostNetwork(Boolean allowHostNetwork) {
        this.allowHostNetwork = allowHostNetwork;
        return (A)this;
    }

    @Override
    public Boolean isAllowHostPID() {
        return this.allowHostPID;
    }

    @Override
    public A withAllowHostPID(Boolean allowHostPID) {
        this.allowHostPID = allowHostPID;
        return (A)this;
    }

    @Override
    public Boolean isAllowHostPorts() {
        return this.allowHostPorts;
    }

    @Override
    public A withAllowHostPorts(Boolean allowHostPorts) {
        this.allowHostPorts = allowHostPorts;
        return (A)this;
    }

    @Override
    public Boolean isAllowPrivilegedContainer() {
        return this.allowPrivilegedContainer;
    }

    @Override
    public A withAllowPrivilegedContainer(Boolean allowPrivilegedContainer) {
        this.allowPrivilegedContainer = allowPrivilegedContainer;
        return (A)this;
    }

    @Override
    public A addToAllowedCapabilities(String ... items) {
        for (String item : items) {
            this.allowedCapabilities.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromAllowedCapabilities(String ... items) {
        for (String item : items) {
            this.allowedCapabilities.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getAllowedCapabilities() {
        return this.allowedCapabilities;
    }

    @Override
    public A withAllowedCapabilities(List<String> allowedCapabilities) {
        this.allowedCapabilities.clear();
        if (allowedCapabilities != null) {
            for (String item : allowedCapabilities) {
                this.addToAllowedCapabilities(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withAllowedCapabilities(String ... allowedCapabilities) {
        this.allowedCapabilities.clear();
        if (allowedCapabilities != null) {
            for (String item : allowedCapabilities) {
                this.addToAllowedCapabilities(item);
            }
        }
        return (A)this;
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public A addToDefaultAddCapabilities(String ... items) {
        for (String item : items) {
            this.defaultAddCapabilities.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromDefaultAddCapabilities(String ... items) {
        for (String item : items) {
            this.defaultAddCapabilities.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getDefaultAddCapabilities() {
        return this.defaultAddCapabilities;
    }

    @Override
    public A withDefaultAddCapabilities(List<String> defaultAddCapabilities) {
        this.defaultAddCapabilities.clear();
        if (defaultAddCapabilities != null) {
            for (String item : defaultAddCapabilities) {
                this.addToDefaultAddCapabilities(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withDefaultAddCapabilities(String ... defaultAddCapabilities) {
        this.defaultAddCapabilities.clear();
        if (defaultAddCapabilities != null) {
            for (String item : defaultAddCapabilities) {
                this.addToDefaultAddCapabilities(item);
            }
        }
        return (A)this;
    }

    @Override
    public FSGroupStrategyOptions getFsGroup() {
        return this.fsGroup != null ? (FSGroupStrategyOptions)this.fsGroup.build() : null;
    }

    @Override
    public A withFsGroup(FSGroupStrategyOptions fsGroup) {
        if (fsGroup != null) {
            this.fsGroup = new FSGroupStrategyOptionsBuilder(fsGroup);
            this._visitables.add(this.fsGroup);
        }
        return (A)this;
    }

    @Override
    public SecurityContextConstraintsFluent.FsGroupNested<A> withNewFsGroup() {
        return new FsGroupNestedImpl();
    }

    @Override
    public SecurityContextConstraintsFluent.FsGroupNested<A> withNewFsGroupLike(FSGroupStrategyOptions item) {
        return new FsGroupNestedImpl(item);
    }

    @Override
    public SecurityContextConstraintsFluent.FsGroupNested<A> editFsGroup() {
        return this.withNewFsGroupLike(this.getFsGroup());
    }

    @Override
    public A addToGroups(String ... items) {
        for (String item : items) {
            this.groups.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromGroups(String ... items) {
        for (String item : items) {
            this.groups.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getGroups() {
        return this.groups;
    }

    @Override
    public A withGroups(List<String> groups) {
        this.groups.clear();
        if (groups != null) {
            for (String item : groups) {
                this.addToGroups(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withGroups(String ... groups) {
        this.groups.clear();
        if (groups != null) {
            for (String item : groups) {
                this.addToGroups(item);
            }
        }
        return (A)this;
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public ObjectMeta getMetadata() {
        return this.metadata != null ? (ObjectMeta)this.metadata.build() : null;
    }

    @Override
    public A withMetadata(ObjectMeta metadata) {
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.add(this.metadata);
        }
        return (A)this;
    }

    @Override
    public SecurityContextConstraintsFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public SecurityContextConstraintsFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public SecurityContextConstraintsFluent.MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public Integer getPriority() {
        return this.priority;
    }

    @Override
    public A withPriority(Integer priority) {
        this.priority = priority;
        return (A)this;
    }

    @Override
    public Boolean isReadOnlyRootFilesystem() {
        return this.readOnlyRootFilesystem;
    }

    @Override
    public A withReadOnlyRootFilesystem(Boolean readOnlyRootFilesystem) {
        this.readOnlyRootFilesystem = readOnlyRootFilesystem;
        return (A)this;
    }

    @Override
    public A addToRequiredDropCapabilities(String ... items) {
        for (String item : items) {
            this.requiredDropCapabilities.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromRequiredDropCapabilities(String ... items) {
        for (String item : items) {
            this.requiredDropCapabilities.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getRequiredDropCapabilities() {
        return this.requiredDropCapabilities;
    }

    @Override
    public A withRequiredDropCapabilities(List<String> requiredDropCapabilities) {
        this.requiredDropCapabilities.clear();
        if (requiredDropCapabilities != null) {
            for (String item : requiredDropCapabilities) {
                this.addToRequiredDropCapabilities(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withRequiredDropCapabilities(String ... requiredDropCapabilities) {
        this.requiredDropCapabilities.clear();
        if (requiredDropCapabilities != null) {
            for (String item : requiredDropCapabilities) {
                this.addToRequiredDropCapabilities(item);
            }
        }
        return (A)this;
    }

    @Override
    public RunAsUserStrategyOptions getRunAsUser() {
        return this.runAsUser != null ? (RunAsUserStrategyOptions)this.runAsUser.build() : null;
    }

    @Override
    public A withRunAsUser(RunAsUserStrategyOptions runAsUser) {
        if (runAsUser != null) {
            this.runAsUser = new RunAsUserStrategyOptionsBuilder(runAsUser);
            this._visitables.add(this.runAsUser);
        }
        return (A)this;
    }

    @Override
    public SecurityContextConstraintsFluent.RunAsUserNested<A> withNewRunAsUser() {
        return new RunAsUserNestedImpl();
    }

    @Override
    public SecurityContextConstraintsFluent.RunAsUserNested<A> withNewRunAsUserLike(RunAsUserStrategyOptions item) {
        return new RunAsUserNestedImpl(item);
    }

    @Override
    public SecurityContextConstraintsFluent.RunAsUserNested<A> editRunAsUser() {
        return this.withNewRunAsUserLike(this.getRunAsUser());
    }

    @Override
    public A withNewRunAsUser(String type, Long uid, Long uidRangeMax, Long uidRangeMin) {
        return this.withRunAsUser(new RunAsUserStrategyOptions(type, uid, uidRangeMax, uidRangeMin));
    }

    @Override
    public SELinuxContextStrategyOptions getSeLinuxContext() {
        return this.seLinuxContext != null ? (SELinuxContextStrategyOptions)this.seLinuxContext.build() : null;
    }

    @Override
    public A withSeLinuxContext(SELinuxContextStrategyOptions seLinuxContext) {
        if (seLinuxContext != null) {
            this.seLinuxContext = new SELinuxContextStrategyOptionsBuilder(seLinuxContext);
            this._visitables.add(this.seLinuxContext);
        }
        return (A)this;
    }

    @Override
    public SecurityContextConstraintsFluent.SeLinuxContextNested<A> withNewSeLinuxContext() {
        return new SeLinuxContextNestedImpl();
    }

    @Override
    public SecurityContextConstraintsFluent.SeLinuxContextNested<A> withNewSeLinuxContextLike(SELinuxContextStrategyOptions item) {
        return new SeLinuxContextNestedImpl(item);
    }

    @Override
    public SecurityContextConstraintsFluent.SeLinuxContextNested<A> editSeLinuxContext() {
        return this.withNewSeLinuxContextLike(this.getSeLinuxContext());
    }

    @Override
    public A addToSeccompProfiles(String ... items) {
        for (String item : items) {
            this.seccompProfiles.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromSeccompProfiles(String ... items) {
        for (String item : items) {
            this.seccompProfiles.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getSeccompProfiles() {
        return this.seccompProfiles;
    }

    @Override
    public A withSeccompProfiles(List<String> seccompProfiles) {
        this.seccompProfiles.clear();
        if (seccompProfiles != null) {
            for (String item : seccompProfiles) {
                this.addToSeccompProfiles(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withSeccompProfiles(String ... seccompProfiles) {
        this.seccompProfiles.clear();
        if (seccompProfiles != null) {
            for (String item : seccompProfiles) {
                this.addToSeccompProfiles(item);
            }
        }
        return (A)this;
    }

    @Override
    public SupplementalGroupsStrategyOptions getSupplementalGroups() {
        return this.supplementalGroups != null ? (SupplementalGroupsStrategyOptions)this.supplementalGroups.build() : null;
    }

    @Override
    public A withSupplementalGroups(SupplementalGroupsStrategyOptions supplementalGroups) {
        if (supplementalGroups != null) {
            this.supplementalGroups = new SupplementalGroupsStrategyOptionsBuilder(supplementalGroups);
            this._visitables.add(this.supplementalGroups);
        }
        return (A)this;
    }

    @Override
    public SecurityContextConstraintsFluent.SupplementalGroupsNested<A> withNewSupplementalGroups() {
        return new SupplementalGroupsNestedImpl();
    }

    @Override
    public SecurityContextConstraintsFluent.SupplementalGroupsNested<A> withNewSupplementalGroupsLike(SupplementalGroupsStrategyOptions item) {
        return new SupplementalGroupsNestedImpl(item);
    }

    @Override
    public SecurityContextConstraintsFluent.SupplementalGroupsNested<A> editSupplementalGroups() {
        return this.withNewSupplementalGroupsLike(this.getSupplementalGroups());
    }

    @Override
    public A addToUsers(String ... items) {
        for (String item : items) {
            this.users.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromUsers(String ... items) {
        for (String item : items) {
            this.users.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getUsers() {
        return this.users;
    }

    @Override
    public A withUsers(List<String> users) {
        this.users.clear();
        if (users != null) {
            for (String item : users) {
                this.addToUsers(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withUsers(String ... users) {
        this.users.clear();
        if (users != null) {
            for (String item : users) {
                this.addToUsers(item);
            }
        }
        return (A)this;
    }

    @Override
    public A addToVolumes(String ... items) {
        for (String item : items) {
            this.volumes.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromVolumes(String ... items) {
        for (String item : items) {
            this.volumes.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getVolumes() {
        return this.volumes;
    }

    @Override
    public A withVolumes(List<String> volumes) {
        this.volumes.clear();
        if (volumes != null) {
            for (String item : volumes) {
                this.addToVolumes(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withVolumes(String ... volumes) {
        this.volumes.clear();
        if (volumes != null) {
            for (String item : volumes) {
                this.addToVolumes(item);
            }
        }
        return (A)this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SecurityContextConstraintsFluentImpl that = (SecurityContextConstraintsFluentImpl)o;
        if (this.allowHostDirVolumePlugin != null ? !this.allowHostDirVolumePlugin.equals(that.allowHostDirVolumePlugin) : that.allowHostDirVolumePlugin != null) {
            return false;
        }
        if (this.allowHostIPC != null ? !this.allowHostIPC.equals(that.allowHostIPC) : that.allowHostIPC != null) {
            return false;
        }
        if (this.allowHostNetwork != null ? !this.allowHostNetwork.equals(that.allowHostNetwork) : that.allowHostNetwork != null) {
            return false;
        }
        if (this.allowHostPID != null ? !this.allowHostPID.equals(that.allowHostPID) : that.allowHostPID != null) {
            return false;
        }
        if (this.allowHostPorts != null ? !this.allowHostPorts.equals(that.allowHostPorts) : that.allowHostPorts != null) {
            return false;
        }
        if (this.allowPrivilegedContainer != null ? !this.allowPrivilegedContainer.equals(that.allowPrivilegedContainer) : that.allowPrivilegedContainer != null) {
            return false;
        }
        if (this.allowedCapabilities != null ? !this.allowedCapabilities.equals(that.allowedCapabilities) : that.allowedCapabilities != null) {
            return false;
        }
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.defaultAddCapabilities != null ? !this.defaultAddCapabilities.equals(that.defaultAddCapabilities) : that.defaultAddCapabilities != null) {
            return false;
        }
        if (this.fsGroup != null ? !this.fsGroup.equals(that.fsGroup) : that.fsGroup != null) {
            return false;
        }
        if (this.groups != null ? !this.groups.equals(that.groups) : that.groups != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null) {
            return false;
        }
        if (this.priority != null ? !this.priority.equals(that.priority) : that.priority != null) {
            return false;
        }
        if (this.readOnlyRootFilesystem != null ? !this.readOnlyRootFilesystem.equals(that.readOnlyRootFilesystem) : that.readOnlyRootFilesystem != null) {
            return false;
        }
        if (this.requiredDropCapabilities != null ? !this.requiredDropCapabilities.equals(that.requiredDropCapabilities) : that.requiredDropCapabilities != null) {
            return false;
        }
        if (this.runAsUser != null ? !this.runAsUser.equals(that.runAsUser) : that.runAsUser != null) {
            return false;
        }
        if (this.seLinuxContext != null ? !this.seLinuxContext.equals(that.seLinuxContext) : that.seLinuxContext != null) {
            return false;
        }
        if (this.seccompProfiles != null ? !this.seccompProfiles.equals(that.seccompProfiles) : that.seccompProfiles != null) {
            return false;
        }
        if (this.supplementalGroups != null ? !this.supplementalGroups.equals(that.supplementalGroups) : that.supplementalGroups != null) {
            return false;
        }
        if (this.users != null ? !this.users.equals(that.users) : that.users != null) {
            return false;
        }
        return !(this.volumes != null ? !this.volumes.equals(that.volumes) : that.volumes != null);
    }

    public class SupplementalGroupsNestedImpl<N>
    extends SupplementalGroupsStrategyOptionsFluentImpl<SecurityContextConstraintsFluent.SupplementalGroupsNested<N>>
    implements SecurityContextConstraintsFluent.SupplementalGroupsNested<N>,
    Nested<N> {
        private final SupplementalGroupsStrategyOptionsBuilder builder;

        SupplementalGroupsNestedImpl() {
            this.builder = new SupplementalGroupsStrategyOptionsBuilder(this);
        }

        SupplementalGroupsNestedImpl(SupplementalGroupsStrategyOptions item) {
            this.builder = new SupplementalGroupsStrategyOptionsBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)SecurityContextConstraintsFluentImpl.this.withSupplementalGroups(this.builder.build());
        }

        @Override
        public N endSupplementalGroups() {
            return this.and();
        }
    }

    public class SeLinuxContextNestedImpl<N>
    extends SELinuxContextStrategyOptionsFluentImpl<SecurityContextConstraintsFluent.SeLinuxContextNested<N>>
    implements SecurityContextConstraintsFluent.SeLinuxContextNested<N>,
    Nested<N> {
        private final SELinuxContextStrategyOptionsBuilder builder;

        SeLinuxContextNestedImpl() {
            this.builder = new SELinuxContextStrategyOptionsBuilder(this);
        }

        SeLinuxContextNestedImpl(SELinuxContextStrategyOptions item) {
            this.builder = new SELinuxContextStrategyOptionsBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)SecurityContextConstraintsFluentImpl.this.withSeLinuxContext(this.builder.build());
        }

        @Override
        public N endSeLinuxContext() {
            return this.and();
        }
    }

    public class RunAsUserNestedImpl<N>
    extends RunAsUserStrategyOptionsFluentImpl<SecurityContextConstraintsFluent.RunAsUserNested<N>>
    implements SecurityContextConstraintsFluent.RunAsUserNested<N>,
    Nested<N> {
        private final RunAsUserStrategyOptionsBuilder builder;

        RunAsUserNestedImpl() {
            this.builder = new RunAsUserStrategyOptionsBuilder(this);
        }

        RunAsUserNestedImpl(RunAsUserStrategyOptions item) {
            this.builder = new RunAsUserStrategyOptionsBuilder(this, item);
        }

        @Override
        public N endRunAsUser() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)SecurityContextConstraintsFluentImpl.this.withRunAsUser(this.builder.build());
        }
    }

    public class MetadataNestedImpl<N>
    extends ObjectMetaFluentImpl<SecurityContextConstraintsFluent.MetadataNested<N>>
    implements SecurityContextConstraintsFluent.MetadataNested<N>,
    Nested<N> {
        private final ObjectMetaBuilder builder;

        MetadataNestedImpl(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder(this, item);
        }

        MetadataNestedImpl() {
            this.builder = new ObjectMetaBuilder(this);
        }

        @Override
        public N and() {
            return (N)SecurityContextConstraintsFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }

    public class FsGroupNestedImpl<N>
    extends FSGroupStrategyOptionsFluentImpl<SecurityContextConstraintsFluent.FsGroupNested<N>>
    implements SecurityContextConstraintsFluent.FsGroupNested<N>,
    Nested<N> {
        private final FSGroupStrategyOptionsBuilder builder;

        FsGroupNestedImpl() {
            this.builder = new FSGroupStrategyOptionsBuilder(this);
        }

        FsGroupNestedImpl(FSGroupStrategyOptions item) {
            this.builder = new FSGroupStrategyOptionsBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)SecurityContextConstraintsFluentImpl.this.withFsGroup(this.builder.build());
        }

        @Override
        public N endFsGroup() {
            return this.and();
        }
    }
}

