/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.openshift.api.model.EditableOAuthAuthorizeTokenList;
import io.fabric8.openshift.api.model.OAuthAuthorizeTokenList;
import io.fabric8.openshift.api.model.OAuthAuthorizeTokenListFluent;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class OAuthAuthorizeTokenListBuilder
extends OAuthAuthorizeTokenListFluent<OAuthAuthorizeTokenListBuilder>
implements VisitableBuilder<OAuthAuthorizeTokenList, OAuthAuthorizeTokenListBuilder> {
    OAuthAuthorizeTokenListFluent<?> fluent;

    public OAuthAuthorizeTokenListBuilder() {
        this(new OAuthAuthorizeTokenList());
    }

    public OAuthAuthorizeTokenListBuilder(OAuthAuthorizeTokenListFluent<?> fluent) {
        this(fluent, new OAuthAuthorizeTokenList());
    }

    public OAuthAuthorizeTokenListBuilder(OAuthAuthorizeTokenListFluent<?> fluent, OAuthAuthorizeTokenList instance) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withItems(instance.getItems());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
    }

    public OAuthAuthorizeTokenListBuilder(OAuthAuthorizeTokenList instance) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withItems(instance.getItems());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
    }

    public EditableOAuthAuthorizeTokenList build() {
        EditableOAuthAuthorizeTokenList buildable = new EditableOAuthAuthorizeTokenList(this.fluent.getApiVersion(), this.fluent.getItems(), this.fluent.getKind(), this.fluent.getMetadata());
        this.validate(buildable);
        return buildable;
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

