/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.EditableGCEPersistentDiskVolumeSource;
import io.fabric8.kubernetes.api.model.GCEPersistentDiskVolumeSource;
import io.fabric8.kubernetes.api.model.GCEPersistentDiskVolumeSourceFluent;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class GCEPersistentDiskVolumeSourceBuilder
extends GCEPersistentDiskVolumeSourceFluent<GCEPersistentDiskVolumeSourceBuilder>
implements VisitableBuilder<GCEPersistentDiskVolumeSource, GCEPersistentDiskVolumeSourceBuilder> {
    GCEPersistentDiskVolumeSourceFluent<?> fluent;

    public GCEPersistentDiskVolumeSourceBuilder() {
        this(new GCEPersistentDiskVolumeSource());
    }

    public GCEPersistentDiskVolumeSourceBuilder(GCEPersistentDiskVolumeSourceFluent<?> fluent) {
        this(fluent, new GCEPersistentDiskVolumeSource());
    }

    public GCEPersistentDiskVolumeSourceBuilder(GCEPersistentDiskVolumeSourceFluent<?> fluent, GCEPersistentDiskVolumeSource instance) {
        this.fluent = fluent;
        fluent.withFsType(instance.getFsType());
        fluent.withPartition(instance.getPartition());
        fluent.withPdName(instance.getPdName());
        fluent.withReadOnly(instance.getReadOnly());
    }

    public GCEPersistentDiskVolumeSourceBuilder(GCEPersistentDiskVolumeSource instance) {
        this.fluent = this;
        this.withFsType(instance.getFsType());
        this.withPartition(instance.getPartition());
        this.withPdName(instance.getPdName());
        this.withReadOnly(instance.getReadOnly());
    }

    public EditableGCEPersistentDiskVolumeSource build() {
        EditableGCEPersistentDiskVolumeSource buildable = new EditableGCEPersistentDiskVolumeSource(this.fluent.getFsType(), this.fluent.getPartition(), this.fluent.getPdName(), this.fluent.isReadOnly());
        this.validate(buildable);
        return buildable;
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

