/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.NodeSystemInfo;
import io.fabric8.kubernetes.api.model.NodeSystemInfoFluent;
import io.fabric8.kubernetes.api.model.NodeSystemInfoFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolationException;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class NodeSystemInfoBuilder
extends NodeSystemInfoFluentImpl<NodeSystemInfoBuilder>
implements VisitableBuilder<NodeSystemInfo, NodeSystemInfoBuilder> {
    NodeSystemInfoFluent<?> fluent;
    Boolean validationEnabled;

    public NodeSystemInfoBuilder() {
        this(true);
    }

    public NodeSystemInfoBuilder(Boolean validationEnabled) {
        this(new NodeSystemInfo(), validationEnabled);
    }

    public NodeSystemInfoBuilder(NodeSystemInfoFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public NodeSystemInfoBuilder(NodeSystemInfoFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new NodeSystemInfo(), validationEnabled);
    }

    public NodeSystemInfoBuilder(NodeSystemInfoFluent<?> fluent, NodeSystemInfo instance) {
        this(fluent, instance, true);
    }

    public NodeSystemInfoBuilder(NodeSystemInfoFluent<?> fluent, NodeSystemInfo instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withArchitecture(instance.getArchitecture());
        fluent.withBootID(instance.getBootID());
        fluent.withContainerRuntimeVersion(instance.getContainerRuntimeVersion());
        fluent.withKernelVersion(instance.getKernelVersion());
        fluent.withKubeProxyVersion(instance.getKubeProxyVersion());
        fluent.withKubeletVersion(instance.getKubeletVersion());
        fluent.withMachineID(instance.getMachineID());
        fluent.withOperatingSystem(instance.getOperatingSystem());
        fluent.withOsImage(instance.getOsImage());
        fluent.withSystemUUID(instance.getSystemUUID());
        this.validationEnabled = validationEnabled;
    }

    public NodeSystemInfoBuilder(NodeSystemInfo instance) {
        this(instance, (Boolean)true);
    }

    public NodeSystemInfoBuilder(NodeSystemInfo instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withArchitecture(instance.getArchitecture());
        this.withBootID(instance.getBootID());
        this.withContainerRuntimeVersion(instance.getContainerRuntimeVersion());
        this.withKernelVersion(instance.getKernelVersion());
        this.withKubeProxyVersion(instance.getKubeProxyVersion());
        this.withKubeletVersion(instance.getKubeletVersion());
        this.withMachineID(instance.getMachineID());
        this.withOperatingSystem(instance.getOperatingSystem());
        this.withOsImage(instance.getOsImage());
        this.withSystemUUID(instance.getSystemUUID());
        this.validationEnabled = validationEnabled;
    }

    public NodeSystemInfo build() {
        NodeSystemInfo buildable = new NodeSystemInfo(this.fluent.getArchitecture(), this.fluent.getBootID(), this.fluent.getContainerRuntimeVersion(), this.fluent.getKernelVersion(), this.fluent.getKubeProxyVersion(), this.fluent.getKubeletVersion(), this.fluent.getMachineID(), this.fluent.getOperatingSystem(), this.fluent.getOsImage(), this.fluent.getSystemUUID());
        this.validate(buildable);
        return buildable;
    }

    private <T> void validate(T item) {
        if (!this.validationEnabled.booleanValue()) {
            return;
        }
        Validator validator = null;
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            validator = factory.getValidator();
        }
        catch (ValidationException e) {
            return;
        }
        Set violations = validator.validate(item, new Class[0]);
        if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NodeSystemInfoBuilder that = (NodeSystemInfoBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

