/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.Cluster;
import io.fabric8.kubernetes.api.model.ClusterFluent;
import io.fabric8.kubernetes.api.model.NamedExtension;
import io.fabric8.kubernetes.api.model.NamedExtensionBuilder;
import io.fabric8.kubernetes.api.model.NamedExtensionFluentImpl;
import java.util.ArrayList;
import java.util.List;

public class ClusterFluentImpl<A extends ClusterFluent<A>>
extends BaseFluent<A>
implements ClusterFluent<A> {
    private String apiVersion;
    private String certificateAuthority;
    private String certificateAuthorityData;
    private List<VisitableBuilder<? extends NamedExtension, ?>> extensions = new ArrayList();
    private Boolean insecureSkipTlsVerify;
    private String server;

    public ClusterFluentImpl() {
    }

    public ClusterFluentImpl(Cluster instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withCertificateAuthority(instance.getCertificateAuthority());
        this.withCertificateAuthorityData(instance.getCertificateAuthorityData());
        this.withExtensions(instance.getExtensions());
        this.withInsecureSkipTlsVerify(instance.getInsecureSkipTlsVerify());
        this.withServer(instance.getServer());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public String getCertificateAuthority() {
        return this.certificateAuthority;
    }

    @Override
    public A withCertificateAuthority(String certificateAuthority) {
        this.certificateAuthority = certificateAuthority;
        return (A)this;
    }

    @Override
    public String getCertificateAuthorityData() {
        return this.certificateAuthorityData;
    }

    @Override
    public A withCertificateAuthorityData(String certificateAuthorityData) {
        this.certificateAuthorityData = certificateAuthorityData;
        return (A)this;
    }

    @Override
    public A addToExtensions(NamedExtension ... items) {
        for (NamedExtension item : items) {
            NamedExtensionBuilder builder = new NamedExtensionBuilder(item);
            this._visitables.add(builder);
            this.extensions.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromExtensions(NamedExtension ... items) {
        for (NamedExtension item : items) {
            NamedExtensionBuilder builder = new NamedExtensionBuilder(item);
            this._visitables.remove(builder);
            this.extensions.remove(builder);
        }
        return (A)this;
    }

    @Override
    public List<NamedExtension> getExtensions() {
        return ClusterFluentImpl.build(this.extensions);
    }

    @Override
    public A withExtensions(List<NamedExtension> extensions) {
        this.extensions.clear();
        if (extensions != null) {
            for (NamedExtension item : extensions) {
                this.addToExtensions(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withExtensions(NamedExtension ... extensions) {
        this.extensions.clear();
        if (extensions != null) {
            for (NamedExtension item : extensions) {
                this.addToExtensions(item);
            }
        }
        return (A)this;
    }

    @Override
    public ClusterFluent.ExtensionsNested<A> addNewExtension() {
        return new ExtensionsNestedImpl();
    }

    @Override
    public ClusterFluent.ExtensionsNested<A> addNewExtensionLike(NamedExtension item) {
        return new ExtensionsNestedImpl(item);
    }

    @Override
    public Boolean isInsecureSkipTlsVerify() {
        return this.insecureSkipTlsVerify;
    }

    @Override
    public A withInsecureSkipTlsVerify(Boolean insecureSkipTlsVerify) {
        this.insecureSkipTlsVerify = insecureSkipTlsVerify;
        return (A)this;
    }

    @Override
    public String getServer() {
        return this.server;
    }

    @Override
    public A withServer(String server) {
        this.server = server;
        return (A)this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ClusterFluentImpl that = (ClusterFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.certificateAuthority != null ? !this.certificateAuthority.equals(that.certificateAuthority) : that.certificateAuthority != null) {
            return false;
        }
        if (this.certificateAuthorityData != null ? !this.certificateAuthorityData.equals(that.certificateAuthorityData) : that.certificateAuthorityData != null) {
            return false;
        }
        if (this.extensions != null ? !this.extensions.equals(that.extensions) : that.extensions != null) {
            return false;
        }
        if (this.insecureSkipTlsVerify != null ? !this.insecureSkipTlsVerify.equals(that.insecureSkipTlsVerify) : that.insecureSkipTlsVerify != null) {
            return false;
        }
        return !(this.server != null ? !this.server.equals(that.server) : that.server != null);
    }

    public class ExtensionsNestedImpl<N>
    extends NamedExtensionFluentImpl<ClusterFluent.ExtensionsNested<N>>
    implements ClusterFluent.ExtensionsNested<N>,
    Nested<N> {
        private final NamedExtensionBuilder builder;

        ExtensionsNestedImpl() {
            this.builder = new NamedExtensionBuilder(this);
        }

        ExtensionsNestedImpl(NamedExtension item) {
            this.builder = new NamedExtensionBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)ClusterFluentImpl.this.addToExtensions(this.builder.build());
        }

        @Override
        public N endExtension() {
            return this.and();
        }
    }
}

