/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.assertions.support;

import io.fabric8.kubernetes.api.KubernetesHelper;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.assertions.PodSelectionAssert;
import io.fabric8.kubernetes.assertions.support.PodAsserter;
import io.fabric8.kubernetes.assertions.support.PodLogWatcher;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.Watcher;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.fusesource.jansi.Ansi;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PodWatcher
implements Watcher<Pod>,
Closeable {
    private static final transient Logger LOG = LoggerFactory.getLogger(PodWatcher.class);
    private final PodSelectionAssert podSelectionAssert;
    private final long readyTimeoutMS;
    private final long readyPeriodMS;
    private Map<String, PodAsserter> podAsserts = new HashMap<String, PodAsserter>();
    private Map<String, PodLogWatcher> podLogWatchers = new HashMap<String, PodLogWatcher>();
    private CountDownLatch podReady = new CountDownLatch(1);
    private CountDownLatch podReadyForEntireDuration = new CountDownLatch(1);
    private File basedir;

    public PodWatcher(PodSelectionAssert podSelectionAssert, long readyTimeoutMS, long readyPeriodMS) {
        this.podSelectionAssert = podSelectionAssert;
        this.readyTimeoutMS = readyTimeoutMS;
        this.readyPeriodMS = readyPeriodMS;
    }

    public KubernetesClient getClient() {
        return this.podSelectionAssert.getClient();
    }

    public String getDescription() {
        return this.podSelectionAssert.getDescription();
    }

    public long getReadyTimeoutMS() {
        return this.readyTimeoutMS;
    }

    public long getReadyPeriodMS() {
        return this.readyPeriodMS;
    }

    public void loadCurrentPods() {
        List<Pod> pods = this.podSelectionAssert.getPods();
        for (Pod pod : pods) {
            String name = KubernetesHelper.getName((HasMetadata)pod);
            if (this.podAsserts.containsKey(name)) continue;
            this.onPod(name, pod);
        }
    }

    public void eventReceived(Watcher.Action action, Pod pod) {
        String name = KubernetesHelper.getName((HasMetadata)pod);
        if (action.equals((Object)Watcher.Action.ERROR)) {
            LOG.warn("Got error for pod " + name);
        } else if (action.equals((Object)Watcher.Action.DELETED)) {
            this.closeCloser(name, this.podAsserts);
            this.closeCloser(name, this.podLogWatchers);
        } else {
            this.onPod(name, pod);
        }
    }

    protected void onPod(String name, Pod pod) {
        PodAsserter asserter = this.podAsserts.get(name);
        if (asserter == null) {
            asserter = new PodAsserter(this, name, pod);
            this.podAsserts.put(name, asserter);
        } else {
            asserter.updated(pod);
        }
        PodLogWatcher logWatcher = this.podLogWatchers.get(name);
        if (logWatcher == null) {
            File logFile;
            String logName = name;
            int counter = 2;
            while ((logFile = new File(this.getBaseDir(), "target/test-pod-logs/" + logName + ".log")).exists()) {
                logName = name + "-" + counter++;
            }
            try {
                logWatcher = new PodLogWatcher(this, name, pod, logFile);
                this.podLogWatchers.put(name, logWatcher);
                LOG.info("Watching pod " + name + " log at file: " + logFile.getAbsolutePath());
            }
            catch (FileNotFoundException e) {
                LOG.warn("Failed to create PodLogWatcher: " + e, (Throwable)e);
            }
        }
        File yamlFile = new File(this.getBaseDir(), "target/test-pod-status/" + name + ".yml");
        yamlFile.getParentFile().mkdirs();
        try {
            KubernetesHelper.saveYaml((Object)pod, (File)yamlFile);
        }
        catch (IOException e) {
            LOG.warn("Failed to write " + yamlFile + ". " + e, (Throwable)e);
        }
    }

    public File getBaseDir() {
        if (this.basedir == null) {
            this.basedir = new File(System.getProperty("basedir", "."));
        }
        return this.basedir;
    }

    public void setBasedir(File basedir) {
        this.basedir = basedir;
    }

    public void onClose(KubernetesClientException e) {
        LOG.info("onClose: " + e);
    }

    @Override
    public void close() {
        this.closeAllClosers(this.podAsserts);
        this.closeAllClosers(this.podLogWatchers);
    }

    protected void closeAllClosers(Map<String, ? extends Closeable> closers) {
        while (!closers.isEmpty()) {
            Set<String> keys = closers.keySet();
            for (String key : keys) {
                this.closeCloser(key, closers);
            }
        }
    }

    private void closeCloser(String name, Map<String, ? extends Closeable> closers) {
        Closeable closer = closers.remove(name);
        if (closer != null) {
            try {
                closer.close();
            }
            catch (Exception e) {
                LOG.warn("Failed to close " + closer + ". " + e, (Throwable)e);
            }
        }
    }

    public void waitForPodReady() {
        boolean ready = false;
        try {
            ready = this.podReady.await(this.readyTimeoutMS, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            LOG.warn("Interupted waiting for podReady: " + e);
            boolean bl = ready = this.podReady.getCount() == 0L;
        }
        if (!ready) {
            Assertions.fail((String)(this.podSelectionAssert.getDescription() + " did not have a pod become Ready within " + this.readyTimeoutMS + " millis"));
        }
        try {
            ready = this.podReadyForEntireDuration.await(this.readyPeriodMS * 2L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            LOG.warn("Interupted waiting for podReadyForEntireDuration: " + e);
            boolean bl = ready = this.podReadyForEntireDuration.getCount() == 0L;
        }
        if (!ready) {
            Assertions.fail((String)(this.podSelectionAssert.getDescription() + " did not have a pod Ready for a duration of " + this.readyPeriodMS + " millis"));
        }
    }

    public void podIsReadyForEntireDuration(String name, Pod pod) {
        String message = "Pod " + name + " has been Ready now for " + this.getReadyPeriodMS() + " millis!";
        LOG.info(Ansi.ansi().fg(Ansi.Color.GREEN).a(message).reset().toString());
        this.podReadyForEntireDuration.countDown();
    }

    public void podIsReady(String name, Pod pod) {
        if (this.podReady.getCount() > 0L) {
            String message = "Pod " + name + " is Ready!";
            LOG.info(Ansi.ansi().fg(Ansi.Color.GREEN).a(message).reset().toString());
            this.podReady.countDown();
        }
    }
}

