/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.extensions.IngressRule;
import io.fabric8.kubernetes.api.model.extensions.IngressRuleFluent;
import io.fabric8.kubernetes.api.model.extensions.IngressRuleFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolationException;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class IngressRuleBuilder
extends IngressRuleFluentImpl<IngressRuleBuilder>
implements VisitableBuilder<IngressRule, IngressRuleBuilder> {
    IngressRuleFluent<?> fluent;
    Boolean validationEnabled;

    public IngressRuleBuilder() {
        this(true);
    }

    public IngressRuleBuilder(Boolean validationEnabled) {
        this(new IngressRule(), validationEnabled);
    }

    public IngressRuleBuilder(IngressRuleFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public IngressRuleBuilder(IngressRuleFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new IngressRule(), validationEnabled);
    }

    public IngressRuleBuilder(IngressRuleFluent<?> fluent, IngressRule instance) {
        this(fluent, instance, true);
    }

    public IngressRuleBuilder(IngressRuleFluent<?> fluent, IngressRule instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withHost(instance.getHost());
        fluent.withHttp(instance.getHttp());
        this.validationEnabled = validationEnabled;
    }

    public IngressRuleBuilder(IngressRule instance) {
        this(instance, (Boolean)true);
    }

    public IngressRuleBuilder(IngressRule instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withHost(instance.getHost());
        this.withHttp(instance.getHttp());
        this.validationEnabled = validationEnabled;
    }

    public IngressRule build() {
        IngressRule buildable = new IngressRule(this.fluent.getHost(), this.fluent.getHttp());
        this.validate(buildable);
        return buildable;
    }

    private <T> void validate(T item) {
        if (!this.validationEnabled.booleanValue()) {
            return;
        }
        Validator validator = null;
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            validator = factory.getValidator();
        }
        catch (ValidationException e) {
            return;
        }
        Set violations = validator.validate(item, new Class[0]);
        if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        IngressRuleBuilder that = (IngressRuleBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

