/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.ConfigMapVolumeSource;
import io.fabric8.kubernetes.api.model.ConfigMapVolumeSourceFluent;
import io.fabric8.kubernetes.api.model.ConfigMapVolumeSourceFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolationException;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class ConfigMapVolumeSourceBuilder
extends ConfigMapVolumeSourceFluentImpl<ConfigMapVolumeSourceBuilder>
implements VisitableBuilder<ConfigMapVolumeSource, ConfigMapVolumeSourceBuilder> {
    ConfigMapVolumeSourceFluent<?> fluent;
    Boolean validationEnabled;

    public ConfigMapVolumeSourceBuilder() {
        this(true);
    }

    public ConfigMapVolumeSourceBuilder(Boolean validationEnabled) {
        this(new ConfigMapVolumeSource(), validationEnabled);
    }

    public ConfigMapVolumeSourceBuilder(ConfigMapVolumeSourceFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public ConfigMapVolumeSourceBuilder(ConfigMapVolumeSourceFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new ConfigMapVolumeSource(), validationEnabled);
    }

    public ConfigMapVolumeSourceBuilder(ConfigMapVolumeSourceFluent<?> fluent, ConfigMapVolumeSource instance) {
        this(fluent, instance, true);
    }

    public ConfigMapVolumeSourceBuilder(ConfigMapVolumeSourceFluent<?> fluent, ConfigMapVolumeSource instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withItems(instance.getItems());
        fluent.withName(instance.getName());
        this.validationEnabled = validationEnabled;
    }

    public ConfigMapVolumeSourceBuilder(ConfigMapVolumeSource instance) {
        this(instance, (Boolean)true);
    }

    public ConfigMapVolumeSourceBuilder(ConfigMapVolumeSource instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withItems(instance.getItems());
        this.withName(instance.getName());
        this.validationEnabled = validationEnabled;
    }

    public ConfigMapVolumeSource build() {
        ConfigMapVolumeSource buildable = new ConfigMapVolumeSource(this.fluent.getItems(), this.fluent.getName());
        this.validate(buildable);
        return buildable;
    }

    private <T> void validate(T item) {
        if (!this.validationEnabled.booleanValue()) {
            return;
        }
        Validator validator = null;
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            validator = factory.getValidator();
        }
        catch (ValidationException e) {
            return;
        }
        Set violations = validator.validate(item, new Class[0]);
        if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ConfigMapVolumeSourceBuilder that = (ConfigMapVolumeSourceBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

