/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluentImpl;
import io.fabric8.openshift.api.model.SecretSpec;
import io.fabric8.openshift.api.model.SecretSpecFluent;
import java.util.HashMap;
import java.util.Map;

public class SecretSpecFluentImpl<T extends SecretSpecFluent<T>>
extends BaseFluent<T>
implements SecretSpecFluent<T> {
    String mountPath;
    VisitableBuilder<LocalObjectReference, ?> secretSource;
    Map<String, Object> additionalProperties = new HashMap<String, Object>();

    public SecretSpecFluentImpl() {
    }

    public SecretSpecFluentImpl(SecretSpec instance) {
        this.withMountPath(instance.getMountPath());
        this.withSecretSource(instance.getSecretSource());
    }

    @Override
    public String getMountPath() {
        return this.mountPath;
    }

    @Override
    public T withMountPath(String mountPath) {
        this.mountPath = mountPath;
        return (T)this;
    }

    @Override
    public LocalObjectReference getSecretSource() {
        return this.secretSource != null ? (LocalObjectReference)this.secretSource.build() : null;
    }

    @Override
    public T withSecretSource(LocalObjectReference secretSource) {
        if (secretSource != null) {
            this.secretSource = new LocalObjectReferenceBuilder(secretSource);
            this._visitables.add(this.secretSource);
        }
        return (T)this;
    }

    @Override
    public SecretSpecFluent.SecretSourceNested<T> withNewSecretSource() {
        return new SecretSourceNestedImpl();
    }

    @Override
    public SecretSpecFluent.SecretSourceNested<T> withNewSecretSourceLike(LocalObjectReference item) {
        return new SecretSourceNestedImpl(item);
    }

    @Override
    public SecretSpecFluent.SecretSourceNested<T> editSecretSource() {
        return this.withNewSecretSourceLike(this.getSecretSource());
    }

    @Override
    public T withNewSecretSource(String name) {
        return this.withSecretSource(new LocalObjectReference(name));
    }

    @Override
    public T addToAdditionalProperties(String key, Object value) {
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (T)this;
    }

    @Override
    public T addToAdditionalProperties(Map<String, Object> map) {
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (T)this;
    }

    @Override
    public T removeFromAdditionalProperties(String key) {
        if (key != null) {
            this.additionalProperties.remove(key);
        }
        return (T)this;
    }

    @Override
    public T removeFromAdditionalProperties(Map<String, Object> map) {
        if (map != null) {
            for (String key : map.keySet()) {
                this.additionalProperties.remove(key);
            }
        }
        return (T)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public T withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties.clear();
        if (additionalProperties != null) {
            this.additionalProperties.putAll(additionalProperties);
        }
        return (T)this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SecretSpecFluentImpl that = (SecretSpecFluentImpl)o;
        if (this.mountPath != null ? !this.mountPath.equals(that.mountPath) : that.mountPath != null) {
            return false;
        }
        if (this.secretSource != null ? !this.secretSource.equals(that.secretSource) : that.secretSource != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    public class SecretSourceNestedImpl<N>
    extends LocalObjectReferenceFluentImpl<SecretSpecFluent.SecretSourceNested<N>>
    implements SecretSpecFluent.SecretSourceNested<N> {
        private final LocalObjectReferenceBuilder builder;

        SecretSourceNestedImpl() {
            this.builder = new LocalObjectReferenceBuilder(this);
        }

        SecretSourceNestedImpl(LocalObjectReference item) {
            this.builder = new LocalObjectReferenceBuilder(this, item);
        }

        @Override
        public N endSecretSource() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)SecretSpecFluentImpl.this.withSecretSource(this.builder.build());
        }
    }
}

