/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.openshift.api.model.RouteStatus;
import io.fabric8.openshift.api.model.RouteStatusFluent;
import io.fabric8.openshift.api.model.RouteStatusFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class RouteStatusBuilder
extends RouteStatusFluentImpl<RouteStatusBuilder>
implements VisitableBuilder<RouteStatus, RouteStatusBuilder> {
    RouteStatusFluent<?> fluent;

    public RouteStatusBuilder() {
        this(new RouteStatus());
    }

    public RouteStatusBuilder(RouteStatusFluent<?> fluent) {
        this(fluent, new RouteStatus());
    }

    public RouteStatusBuilder(RouteStatusFluent<?> fluent, RouteStatus instance) {
        this.fluent = fluent;
        fluent.withIngress(instance.getIngress());
    }

    public RouteStatusBuilder(RouteStatus instance) {
        this.fluent = this;
        this.withIngress(instance.getIngress());
    }

    public RouteStatus build() {
        RouteStatus buildable = new RouteStatus(this.fluent.getIngress());
        this.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RouteStatusBuilder that = (RouteStatusBuilder)o;
        return !(this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this);
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

