/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.openshift.api.model.PolicyRule;
import io.fabric8.openshift.api.model.PolicyRuleFluent;
import io.fabric8.openshift.api.model.PolicyRuleFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class PolicyRuleBuilder
extends PolicyRuleFluentImpl<PolicyRuleBuilder>
implements VisitableBuilder<PolicyRule, PolicyRuleBuilder> {
    PolicyRuleFluent<?> fluent;

    public PolicyRuleBuilder() {
        this(new PolicyRule());
    }

    public PolicyRuleBuilder(PolicyRuleFluent<?> fluent) {
        this(fluent, new PolicyRule());
    }

    public PolicyRuleBuilder(PolicyRuleFluent<?> fluent, PolicyRule instance) {
        this.fluent = fluent;
        fluent.withApiGroups(instance.getApiGroups());
        fluent.withAttributeRestrictions(instance.getAttributeRestrictions());
        fluent.withNonResourceURLs(instance.getNonResourceURLs());
        fluent.withResourceNames(instance.getResourceNames());
        fluent.withResources(instance.getResources());
        fluent.withVerbs(instance.getVerbs());
    }

    public PolicyRuleBuilder(PolicyRule instance) {
        this.fluent = this;
        this.withApiGroups(instance.getApiGroups());
        this.withAttributeRestrictions(instance.getAttributeRestrictions());
        this.withNonResourceURLs(instance.getNonResourceURLs());
        this.withResourceNames(instance.getResourceNames());
        this.withResources(instance.getResources());
        this.withVerbs(instance.getVerbs());
    }

    public PolicyRule build() {
        PolicyRule buildable = new PolicyRule(this.fluent.getApiGroups(), this.fluent.getAttributeRestrictions(), this.fluent.getNonResourceURLs(), this.fluent.getResourceNames(), this.fluent.getResources(), this.fluent.getVerbs());
        this.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PolicyRuleBuilder that = (PolicyRuleBuilder)o;
        return !(this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this);
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

