/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.NamedCluster;
import io.fabric8.kubernetes.api.model.NamedClusterFluent;
import io.fabric8.kubernetes.api.model.NamedClusterFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class NamedClusterBuilder
extends NamedClusterFluentImpl<NamedClusterBuilder>
implements VisitableBuilder<NamedCluster, NamedClusterBuilder> {
    NamedClusterFluent<?> fluent;

    public NamedClusterBuilder() {
        this(new NamedCluster());
    }

    public NamedClusterBuilder(NamedClusterFluent<?> fluent) {
        this(fluent, new NamedCluster());
    }

    public NamedClusterBuilder(NamedClusterFluent<?> fluent, NamedCluster instance) {
        this.fluent = fluent;
        fluent.withCluster(instance.getCluster());
        fluent.withName(instance.getName());
    }

    public NamedClusterBuilder(NamedCluster instance) {
        this.fluent = this;
        this.withCluster(instance.getCluster());
        this.withName(instance.getName());
    }

    public NamedCluster build() {
        NamedCluster buildable = new NamedCluster(this.fluent.getCluster(), this.fluent.getName());
        this.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NamedClusterBuilder that = (NamedClusterBuilder)o;
        return !(this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this);
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

