/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.ComponentStatus;
import io.fabric8.kubernetes.api.model.ComponentStatusFluent;
import io.fabric8.kubernetes.api.model.ComponentStatusFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class ComponentStatusBuilder
extends ComponentStatusFluentImpl<ComponentStatusBuilder>
implements VisitableBuilder<ComponentStatus, ComponentStatusBuilder> {
    ComponentStatusFluent<?> fluent;

    public ComponentStatusBuilder() {
        this(new ComponentStatus());
    }

    public ComponentStatusBuilder(ComponentStatusFluent<?> fluent) {
        this(fluent, new ComponentStatus());
    }

    public ComponentStatusBuilder(ComponentStatusFluent<?> fluent, ComponentStatus instance) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withConditions(instance.getConditions());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
    }

    public ComponentStatusBuilder(ComponentStatus instance) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withConditions(instance.getConditions());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
    }

    public ComponentStatus build() {
        ComponentStatus buildable = new ComponentStatus(this.fluent.getApiVersion(), this.fluent.getConditions(), this.fluent.getKind(), this.fluent.getMetadata());
        this.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ComponentStatusBuilder that = (ComponentStatusBuilder)o;
        return !(this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this);
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

