/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.LimitRangeSpec;
import io.fabric8.kubernetes.api.model.LimitRangeSpecFluent;
import io.fabric8.kubernetes.api.model.LimitRangeSpecFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class LimitRangeSpecBuilder
extends LimitRangeSpecFluentImpl<LimitRangeSpecBuilder>
implements VisitableBuilder<LimitRangeSpec, LimitRangeSpecBuilder> {
    LimitRangeSpecFluent<?> fluent;

    public LimitRangeSpecBuilder() {
        this(new LimitRangeSpec());
    }

    public LimitRangeSpecBuilder(LimitRangeSpecFluent<?> fluent) {
        this(fluent, new LimitRangeSpec());
    }

    public LimitRangeSpecBuilder(LimitRangeSpecFluent<?> fluent, LimitRangeSpec instance) {
        this.fluent = fluent;
        fluent.withLimits(instance.getLimits());
    }

    public LimitRangeSpecBuilder(LimitRangeSpec instance) {
        this.fluent = this;
        this.withLimits(instance.getLimits());
    }

    public LimitRangeSpec build() {
        LimitRangeSpec buildable = new LimitRangeSpec(this.fluent.getLimits());
        this.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        LimitRangeSpecBuilder that = (LimitRangeSpecBuilder)o;
        return !(this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this);
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

