/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.model.FSGroupStrategyOptionsAssert;
import io.fabric8.kubernetes.api.model.ObjectMetaAssert;
import io.fabric8.kubernetes.api.model.RunAsUserStrategyOptionsAssert;
import io.fabric8.kubernetes.api.model.SELinuxContextStrategyOptionsAssert;
import io.fabric8.kubernetes.api.model.SecurityContextConstraints;
import io.fabric8.kubernetes.api.model.SupplementalGroupsStrategyOptionsAssert;
import io.fabric8.kubernetes.assertions.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.BooleanAssert;
import org.assertj.core.api.MapAssert;
import org.assertj.core.api.StringAssert;
import org.assertj.core.util.Objects;

public abstract class AbstractSecurityContextConstraintsAssert<S extends AbstractSecurityContextConstraintsAssert<S, A>, A extends SecurityContextConstraints>
extends AbstractAssert<S, A> {
    protected AbstractSecurityContextConstraintsAssert(A actual, Class<S> selfType) {
        super(actual, selfType);
    }

    public MapAssert additionalProperties() {
        this.isNotNull();
        return (MapAssert)Assertions.assertThat(((SecurityContextConstraints)this.actual).getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"), new Object[0]);
    }

    public BooleanAssert allowHostDirVolumePlugin() {
        this.isNotNull();
        return (BooleanAssert)Assertions.assertThat((Boolean)((SecurityContextConstraints)this.actual).getAllowHostDirVolumePlugin()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "allowHostDirVolumePlugin"), new Object[0]);
    }

    public BooleanAssert allowHostIPC() {
        this.isNotNull();
        return (BooleanAssert)Assertions.assertThat((Boolean)((SecurityContextConstraints)this.actual).getAllowHostIPC()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "allowHostIPC"), new Object[0]);
    }

    public BooleanAssert allowHostNetwork() {
        this.isNotNull();
        return (BooleanAssert)Assertions.assertThat((Boolean)((SecurityContextConstraints)this.actual).getAllowHostNetwork()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "allowHostNetwork"), new Object[0]);
    }

    public BooleanAssert allowHostPID() {
        this.isNotNull();
        return (BooleanAssert)Assertions.assertThat((Boolean)((SecurityContextConstraints)this.actual).getAllowHostPID()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "allowHostPID"), new Object[0]);
    }

    public BooleanAssert allowHostPorts() {
        this.isNotNull();
        return (BooleanAssert)Assertions.assertThat((Boolean)((SecurityContextConstraints)this.actual).getAllowHostPorts()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "allowHostPorts"), new Object[0]);
    }

    public BooleanAssert allowPrivilegedContainer() {
        this.isNotNull();
        return (BooleanAssert)Assertions.assertThat((Boolean)((SecurityContextConstraints)this.actual).getAllowPrivilegedContainer()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "allowPrivilegedContainer"), new Object[0]);
    }

    public NavigationListAssert<String, StringAssert> allowedCapabilities() {
        this.isNotNull();
        AssertFactory<String, StringAssert> assertFactory = new AssertFactory<String, StringAssert>(){

            @Override
            public StringAssert createAssert(String t) {
                return (StringAssert)Assertions.assertThat((String)t);
            }
        };
        NavigationListAssert<String, StringAssert> answer = new NavigationListAssert<String, StringAssert>(((SecurityContextConstraints)this.actual).getAllowedCapabilities(), assertFactory);
        answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "allowedCapabilities"), new Object[0]);
        return answer;
    }

    public StringAssert apiVersion() {
        this.isNotNull();
        return (StringAssert)Assertions.assertThat((String)((SecurityContextConstraints)this.actual).getApiVersion()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "apiVersion"), new Object[0]);
    }

    public NavigationListAssert<String, StringAssert> defaultAddCapabilities() {
        this.isNotNull();
        AssertFactory<String, StringAssert> assertFactory = new AssertFactory<String, StringAssert>(){

            @Override
            public StringAssert createAssert(String t) {
                return (StringAssert)Assertions.assertThat((String)t);
            }
        };
        NavigationListAssert<String, StringAssert> answer = new NavigationListAssert<String, StringAssert>(((SecurityContextConstraints)this.actual).getDefaultAddCapabilities(), assertFactory);
        answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "defaultAddCapabilities"), new Object[0]);
        return answer;
    }

    public FSGroupStrategyOptionsAssert fsGroup() {
        this.isNotNull();
        return (FSGroupStrategyOptionsAssert)io.fabric8.openshift.assertions.Assertions.assertThat(((SecurityContextConstraints)this.actual).getFsGroup()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "fsGroup"), new Object[0]);
    }

    public NavigationListAssert<String, StringAssert> groups() {
        this.isNotNull();
        AssertFactory<String, StringAssert> assertFactory = new AssertFactory<String, StringAssert>(){

            @Override
            public StringAssert createAssert(String t) {
                return (StringAssert)Assertions.assertThat((String)t);
            }
        };
        NavigationListAssert<String, StringAssert> answer = new NavigationListAssert<String, StringAssert>(((SecurityContextConstraints)this.actual).getGroups(), assertFactory);
        answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "groups"), new Object[0]);
        return answer;
    }

    public StringAssert kind() {
        this.isNotNull();
        return (StringAssert)Assertions.assertThat((String)((SecurityContextConstraints)this.actual).getKind()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "kind"), new Object[0]);
    }

    public ObjectMetaAssert metadata() {
        this.isNotNull();
        return (ObjectMetaAssert)io.fabric8.openshift.assertions.Assertions.assertThat(((SecurityContextConstraints)this.actual).getMetadata()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "metadata"), new Object[0]);
    }

    public S hasPriority(Integer priority) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting priority of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        Integer actualPriority = ((SecurityContextConstraints)this.actual).getPriority();
        if (!Objects.areEqual((Object)actualPriority, (Object)priority)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, priority, actualPriority});
        }
        return (S)((Object)((AbstractSecurityContextConstraintsAssert)this.myself));
    }

    public BooleanAssert readOnlyRootFilesystem() {
        this.isNotNull();
        return (BooleanAssert)Assertions.assertThat((Boolean)((SecurityContextConstraints)this.actual).getReadOnlyRootFilesystem()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "readOnlyRootFilesystem"), new Object[0]);
    }

    public NavigationListAssert<String, StringAssert> requiredDropCapabilities() {
        this.isNotNull();
        AssertFactory<String, StringAssert> assertFactory = new AssertFactory<String, StringAssert>(){

            @Override
            public StringAssert createAssert(String t) {
                return (StringAssert)Assertions.assertThat((String)t);
            }
        };
        NavigationListAssert<String, StringAssert> answer = new NavigationListAssert<String, StringAssert>(((SecurityContextConstraints)this.actual).getRequiredDropCapabilities(), assertFactory);
        answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "requiredDropCapabilities"), new Object[0]);
        return answer;
    }

    public RunAsUserStrategyOptionsAssert runAsUser() {
        this.isNotNull();
        return (RunAsUserStrategyOptionsAssert)io.fabric8.openshift.assertions.Assertions.assertThat(((SecurityContextConstraints)this.actual).getRunAsUser()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "runAsUser"), new Object[0]);
    }

    public SELinuxContextStrategyOptionsAssert seLinuxContext() {
        this.isNotNull();
        return (SELinuxContextStrategyOptionsAssert)io.fabric8.openshift.assertions.Assertions.assertThat(((SecurityContextConstraints)this.actual).getSeLinuxContext()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "seLinuxContext"), new Object[0]);
    }

    public SupplementalGroupsStrategyOptionsAssert supplementalGroups() {
        this.isNotNull();
        return (SupplementalGroupsStrategyOptionsAssert)io.fabric8.openshift.assertions.Assertions.assertThat(((SecurityContextConstraints)this.actual).getSupplementalGroups()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "supplementalGroups"), new Object[0]);
    }

    public NavigationListAssert<String, StringAssert> users() {
        this.isNotNull();
        AssertFactory<String, StringAssert> assertFactory = new AssertFactory<String, StringAssert>(){

            @Override
            public StringAssert createAssert(String t) {
                return (StringAssert)Assertions.assertThat((String)t);
            }
        };
        NavigationListAssert<String, StringAssert> answer = new NavigationListAssert<String, StringAssert>(((SecurityContextConstraints)this.actual).getUsers(), assertFactory);
        answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "users"), new Object[0]);
        return answer;
    }

    public NavigationListAssert<String, StringAssert> volumes() {
        this.isNotNull();
        AssertFactory<String, StringAssert> assertFactory = new AssertFactory<String, StringAssert>(){

            @Override
            public StringAssert createAssert(String t) {
                return (StringAssert)Assertions.assertThat((String)t);
            }
        };
        NavigationListAssert<String, StringAssert> answer = new NavigationListAssert<String, StringAssert>(((SecurityContextConstraints)this.actual).getVolumes(), assertFactory);
        answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "volumes"), new Object[0]);
        return answer;
    }
}

